/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.filters.CommonFiltersTab;
import org.eclipse.ui.internal.navigator.filters.ContentExtensionsTab;
import org.eclipse.ui.internal.navigator.filters.FilterDialogSelectionListener;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveExtensionsOperation;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonFilterSelectionDialog
extends Dialog {
    private final CommonViewer commonViewer;
    private final INavigatorContentService contentService;
    private TabFolder customizationsTabFolder;
    private CommonFiltersTab commonFiltersTab;
    private ContentExtensionsTab contentExtensionsTab;
    private Text descriptionText;
    private ISelectionChangedListener updateDescriptionSelectionListener;

    protected CommonFilterSelectionDialog(CommonViewer aCommonViewer) {
        super(aCommonViewer.getControl().getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.commonViewer = aCommonViewer;
        this.contentService = this.commonViewer.getNavigatorContentService();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonNavigatorMessages.CommonFilterSelectionDialog_Available_customization_);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.createCustomizationsTabFolder(superComposite);
        this.commonFiltersTab = new CommonFiltersTab((Composite)this.customizationsTabFolder, this.contentService);
        this.createTabItem(this.customizationsTabFolder, CommonNavigatorMessages.CommonFilterSelectionDialog_Available_Filters, this.commonFiltersTab);
        boolean hideExtensionsTab = this.contentService.getViewerDescriptor().getBooleanConfigProperty("org.eclipse.ui.navigator.hideAvailableExtensionsTab");
        if (!hideExtensionsTab) {
            this.contentExtensionsTab = new ContentExtensionsTab((Composite)this.customizationsTabFolder, this.contentService);
            this.createTabItem(this.customizationsTabFolder, CommonNavigatorMessages.CommonFilterSelectionDialog_Available_Content, this.contentExtensionsTab);
        }
        this.createDescriptionText(superComposite);
        this.descriptionText.setBackground(superComposite.getBackground());
        this.commonFiltersTab.addSelectionChangedListener(this.getSelectionListener());
        if (this.contentExtensionsTab != null) {
            this.contentExtensionsTab.addSelectionChangedListener(this.getSelectionListener());
        }
        return this.customizationsTabFolder;
    }

    private void createCustomizationsTabFolder(Composite superComposite) {
        this.customizationsTabFolder = new TabFolder(superComposite, 16);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.customizationsTabFolder.setLayout((Layout)layout);
        this.customizationsTabFolder.setLayoutData((Object)new GridData(1808));
        this.customizationsTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CommonFilterSelectionDialog.this.descriptionText != null) {
                    CommonFilterSelectionDialog.this.descriptionText.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTabItem(TabFolder aTabFolder, String label, Composite composite) {
        TabItem extensionsTabItem = new TabItem(aTabFolder, 0);
        extensionsTabItem.setText(label);
        extensionsTabItem.setControl((Control)composite);
    }

    private void createDescriptionText(Composite composite) {
        this.descriptionText = new Text(composite, 2624);
        GridData descriptionTextGridData = new GridData(768);
        descriptionTextGridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
    }

    private ISelectionChangedListener getSelectionListener() {
        if (this.updateDescriptionSelectionListener == null) {
            this.updateDescriptionSelectionListener = new FilterDialogSelectionListener(this.descriptionText);
        }
        return this.updateDescriptionSelectionListener;
    }

    protected void okPressed() {
        String[] contentExtensionIdsToActivate = new String[]{};
        if (this.contentExtensionsTab != null) {
            ArrayList<String> checkedExtensions = new ArrayList<String>();
            TableItem[] tableItems = this.contentExtensionsTab.getTable().getItems();
            int i = 0;
            while (i < tableItems.length) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)tableItems[i].getData();
                if (tableItems[i].getChecked()) {
                    checkedExtensions.add(descriptor.getId());
                }
                ++i;
            }
            if (checkedExtensions.size() != 0) {
                contentExtensionIdsToActivate = checkedExtensions.toArray(new String[checkedExtensions.size()]);
            }
        }
        String[] filterIdsToActivate = new String[]{};
        if (this.commonFiltersTab != null) {
            ArrayList<String> checkedFilters = new ArrayList<String>();
            TableItem[] tableItems = this.commonFiltersTab.getTable().getItems();
            int i = 0;
            while (i < tableItems.length) {
                ICommonFilterDescriptor descriptor = (ICommonFilterDescriptor)tableItems[i].getData();
                if (tableItems[i].getChecked()) {
                    checkedFilters.add(descriptor.getId());
                }
                ++i;
            }
            if (checkedFilters.size() != 0) {
                filterIdsToActivate = checkedFilters.toArray(new String[checkedFilters.size()]);
            }
        }
        UpdateActiveExtensionsOperation updateExtensions = new UpdateActiveExtensionsOperation(this.commonViewer, contentExtensionIdsToActivate);
        UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(this.commonViewer, filterIdsToActivate, true);
        updateExtensions.execute(null, null);
        updateFilters.execute(null, null);
        super.okPressed();
    }
}

