/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private FileSearchPage fPage;
    private AbstractTextSearchResult fResult;

    public FileTableContentProvider(FileSearchPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileSearchResult) {
            Object[] elements = ((FileSearchResult)inputElement).getElements();
            int tableLimit = SearchPreferencePage.getTableLimit();
            if (SearchPreferencePage.isTableLimited() && elements.length > tableLimit) {
                Object[] shownElements = new Object[tableLimit];
                System.arraycopy(elements, 0, shownElements, 0, tableLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSearchResult) {
            this.fResult = (FileSearchResult)newInput;
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        boolean tableLimited = SearchPreferencePage.isTableLimited();
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < SearchPreferencePage.getTableLimit()) {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    public void clear() {
        this.getViewer().refresh();
    }
}

