/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Arrays;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class SmartSemicolonAutoEditStrategy
implements IAutoEditStrategy {
    private static final String SEMICOLON = ";";
    private static final char SEMICHAR = ';';
    private static final String BRACE = "{";
    private static final char BRACECHAR = '{';
    private char fCharacter;
    private String fPartitioning;

    public SmartSemicolonAutoEditStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        TextSelection line;
        if (command.text == null) {
            return;
        }
        if (command.text.equals(SEMICOLON)) {
            this.fCharacter = (char)59;
        } else if (command.text.equals(BRACE)) {
            this.fCharacter = (char)123;
        } else {
            return;
        }
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fCharacter == ';' && !store.getBoolean("smart_semicolon")) {
            return;
        }
        if (this.fCharacter == '{' && !store.getBoolean("smart_opening_brace")) {
            return;
        }
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart part = page.getActiveEditor();
        if (!(part instanceof CompilationUnitEditor)) {
            return;
        }
        CompilationUnitEditor editor = (CompilationUnitEditor)part;
        if (editor.getInsertMode() != ITextEditorExtension3.SMART_INSERT || !editor.isEditable()) {
            return;
        }
        ITextEditorExtension2 extension = (ITextEditorExtension2)editor.getAdapter(ITextEditorExtension2.class);
        if (extension != null && !extension.validateEditorInputState()) {
            return;
        }
        if (this.isMultilineSelection(document, command)) {
            return;
        }
        int pos = command.offset;
        try {
            IRegion l = document.getLineInformationOfOffset(pos);
            line = new TextSelection(document, l.getOffset(), l.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int positionInLine = SmartSemicolonAutoEditStrategy.computeCharacterPosition(document, (ITextSelection)line, pos - line.getOffset(), this.fCharacter, this.fPartitioning);
        int position = positionInLine + line.getOffset();
        if (position < pos) {
            return;
        }
        if (this.alreadyPresent(document, this.fCharacter, position)) {
            return;
        }
        String insertion = this.adjustSpacing(document, position, this.fCharacter);
        if (command.offset == position && insertion.equals(command.text)) {
            return;
        }
        try {
            SmartBackspaceManager manager = (SmartBackspaceManager)editor.getAdapter(SmartBackspaceManager.class);
            if (manager != null && JavaPlugin.getDefault().getPreferenceStore().getBoolean("smart_backspace")) {
                ReplaceEdit e1 = new ReplaceEdit(command.offset, command.text.length(), document.get(command.offset, command.length));
                SmartBackspaceManager.UndoSpec s1 = new SmartBackspaceManager.UndoSpec(command.offset + command.text.length(), (IRegion)new Region(command.offset, 0), new TextEdit[]{e1}, 0, null);
                DeleteEdit smart = new DeleteEdit(position, insertion.length());
                ReplaceEdit raw = new ReplaceEdit(command.offset, command.length, command.text);
                SmartBackspaceManager.UndoSpec s2 = new SmartBackspaceManager.UndoSpec(position + insertion.length(), (IRegion)new Region(command.offset + command.text.length(), 0), new TextEdit[]{smart, raw}, 2, s1);
                manager.register(s2);
            }
            command.offset = position;
            command.length = 0;
            command.caretOffset = position;
            command.text = insertion;
            command.doit = true;
            command.owner = null;
        }
        catch (MalformedTreeException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private boolean isMultilineSelection(IDocument document, DocumentCommand command) {
        try {
            return document.getNumberOfLines(command.offset, command.length) > 1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private String adjustSpacing(IDocument doc, int position, char character) {
        int pos;
        if (character == '{' && position > 0 && position <= doc.getLength() && (SmartSemicolonAutoEditStrategy.looksLike(doc, pos = position - 1, ")") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "=") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "]") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "try") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "else") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "static") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "finally") || SmartSemicolonAutoEditStrategy.looksLike(doc, pos, "do"))) {
            return new String(new char[]{' ', character});
        }
        return new String(new char[]{character});
    }

    private boolean alreadyPresent(IDocument document, char ch, int position) {
        int pos = SmartSemicolonAutoEditStrategy.firstNonWhitespaceForward(document, position, this.fPartitioning, document.getLength());
        try {
            if (pos != -1 && document.getChar(pos) == ch) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected static int computeCharacterPosition(IDocument document, ITextSelection line, int offset, char character, String partitioning) {
        int insertPos;
        String text = line.getText();
        if (text == null) {
            return 0;
        }
        if (character == '{') {
            insertPos = SmartSemicolonAutoEditStrategy.computeArrayInitializationPos(document, line, offset, partitioning);
            if (insertPos == -1) {
                insertPos = SmartSemicolonAutoEditStrategy.computeAfterTryDoElse(document, line, offset);
            }
            if (insertPos == -1) {
                insertPos = SmartSemicolonAutoEditStrategy.computeAfterParenthesis(document, line, offset, partitioning);
            }
        } else if (character == ';') {
            if (SmartSemicolonAutoEditStrategy.isForStatement(text, offset)) {
                insertPos = -1;
            } else {
                int opening;
                int nextPartitionPos = SmartSemicolonAutoEditStrategy.nextPartitionOrLineEnd(document, line, offset, partitioning);
                insertPos = SmartSemicolonAutoEditStrategy.startOfWhitespaceBeforeOffset(text, nextPartitionPos);
                if (insertPos > 0 && text.charAt(insertPos - 1) == character) {
                    --insertPos;
                } else if (insertPos > 0 && text.charAt(insertPos - 1) == '}' && (opening = SmartSemicolonAutoEditStrategy.scanBackward(document, insertPos - 1 + line.getOffset(), partitioning, -1, new char[]{'{'})) > -1 && opening < offset + line.getOffset() && SmartSemicolonAutoEditStrategy.computeArrayInitializationPos(document, line, opening - line.getOffset(), partitioning) == -1) {
                    insertPos = offset;
                }
            }
        } else {
            Assert.isTrue((boolean)false);
            return -1;
        }
        return insertPos;
    }

    private static int computeArrayInitializationPos(IDocument document, ITextSelection line, int offset, String partitioning) {
        char ch;
        int p;
        block9: {
            block8: {
                int pos = offset + line.getOffset();
                if (pos == 0) {
                    return -1;
                }
                p = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, pos - 1, partitioning, -1);
                if (p == -1) {
                    return -1;
                }
                try {
                    ch = document.getChar(p);
                    if (ch == '=' || ch == ']') break block8;
                    return -1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (p == 0) {
                return offset;
            }
            if ((p = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, p - 1, partitioning, -1)) != -1) break block9;
            return -1;
        }
        ch = document.getChar(p);
        if (Character.isJavaIdentifierPart(ch) || ch == ']' || ch == '[') {
            return offset;
        }
        return -1;
    }

    private static int computeAfterTryDoElse(IDocument doc, ITextSelection line, int offset) {
        int p = offset + line.getOffset();
        if ((p = SmartSemicolonAutoEditStrategy.firstWhitespaceToRight(doc, p)) == -1) {
            return -1;
        }
        if (SmartSemicolonAutoEditStrategy.looksLike(doc, --p, "try") || SmartSemicolonAutoEditStrategy.looksLike(doc, p, "do") || SmartSemicolonAutoEditStrategy.looksLike(doc, p, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(doc, p, "static") || SmartSemicolonAutoEditStrategy.looksLike(doc, p, "finally") || SmartSemicolonAutoEditStrategy.looksLike(doc, p, "else")) {
            return p + 1 - line.getOffset();
        }
        return -1;
    }

    private static int computeAfterParenthesis(IDocument document, ITextSelection line, int offset, String partitioning) {
        int openingParen;
        int startScan;
        int length;
        int pos = offset + line.getOffset();
        int scanTo = SmartSemicolonAutoEditStrategy.scanForward(document, pos, partitioning, length = line.getOffset() + line.getLength(), '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = SmartSemicolonAutoEditStrategy.findClosingParenToLeft(document, pos, partitioning) - 1;
        while ((closingParen = SmartSemicolonAutoEditStrategy.scanForward(document, startScan = closingParen + 1, partitioning, scanTo, ')')) != -1 && (openingParen = SmartSemicolonAutoEditStrategy.findOpeningParenMatch(document, closingParen, partitioning)) >= 1) {
            if (openingParen > pos) continue;
            if (SmartSemicolonAutoEditStrategy.looksLikeAnonymousClassDef(document, openingParen - 1, partitioning)) {
                return closingParen + 1 - line.getOffset();
            }
            if (SmartSemicolonAutoEditStrategy.looksLikeIfWhileForCatch(document, openingParen - 1, partitioning)) {
                return closingParen + 1 - line.getOffset();
            }
            if (!SmartSemicolonAutoEditStrategy.looksLikeMethodDecl(document, openingParen - 1, partitioning)) continue;
            return closingParen + 1 - line.getOffset();
        }
        return -1;
    }

    private static int findClosingParenToLeft(IDocument document, int position, String partitioning) {
        try {
            if (position < 1) {
                return position;
            }
            int nonWS = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, position - 1, partitioning, -1);
            if (nonWS != -1 && document.getChar(nonWS) == ')') {
                return nonWS;
            }
        }
        catch (BadLocationException badLocationException) {}
        return position;
    }

    private static int firstWhitespaceToRight(IDocument document, int position) {
        int length = document.getLength();
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= length ? 1 : 0) != 0);
        try {
            while (position < length) {
                char ch = document.getChar(position);
                if (Character.isWhitespace(ch)) {
                    return position;
                }
                ++position;
            }
            return position;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static int firstNonWhitespaceBackward(IDocument document, int position, String partitioning, int bound) {
        Assert.isTrue((position < document.getLength() ? 1 : 0) != 0);
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        try {
            while (position > bound) {
                char ch = document.getChar(position);
                if (!Character.isWhitespace(ch) && SmartSemicolonAutoEditStrategy.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                --position;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int firstNonWhitespaceForward(IDocument document, int position, String partitioning, int bound) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((bound <= document.getLength() ? 1 : 0) != 0);
        try {
            while (position < bound) {
                char ch = document.getChar(position);
                if (!Character.isWhitespace(ch) && SmartSemicolonAutoEditStrategy.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                ++position;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanBackward(IDocument document, int position, String partitioning, int bound, char[] chars) {
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        Assert.isTrue((position < document.getLength() ? 1 : 0) != 0);
        Arrays.sort(chars);
        try {
            while (position > bound) {
                if (Arrays.binarySearch(chars, document.getChar(position)) >= 0 && SmartSemicolonAutoEditStrategy.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                --position;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanForward(IDocument document, int position, String partitioning, int bound, char[] chars) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((bound <= document.getLength() ? 1 : 0) != 0);
        Arrays.sort(chars);
        try {
            while (position < bound) {
                if (Arrays.binarySearch(chars, document.getChar(position)) >= 0 && SmartSemicolonAutoEditStrategy.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                ++position;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanForward(IDocument document, int position, String partitioning, int bound, char ch) {
        return SmartSemicolonAutoEditStrategy.scanForward(document, position, partitioning, bound, new char[]{ch});
    }

    private static boolean isNewMatch(IDocument document, int offset, int length, String partitioning) {
        int pos;
        String text;
        block6: {
            block5: {
                Assert.isTrue((length >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset + length < document.getLength() + 1 ? 1 : 0) != 0);
                try {
                    text = document.get(offset, length);
                    pos = text.indexOf("new");
                    while (pos != -1 && !SmartSemicolonAutoEditStrategy.isDefaultPartition(document, pos + offset, partitioning)) {
                        pos = text.indexOf("new", pos + 2);
                    }
                    if (pos >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (pos == 0 || !Character.isJavaIdentifierPart(text.charAt(pos - 1))) break block6;
            return false;
        }
        return pos + 3 >= length || !Character.isJavaIdentifierPart(text.charAt(pos + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument document, int position, String partitioning) {
        int previousCommaParenEqual = SmartSemicolonAutoEditStrategy.scanBackward(document, position - 1, partitioning, -1, new char[]{',', '(', '='});
        if (previousCommaParenEqual == -1 || position < previousCommaParenEqual + 5) {
            return false;
        }
        return SmartSemicolonAutoEditStrategy.isNewMatch(document, previousCommaParenEqual + 1, position - previousCommaParenEqual - 2, partitioning);
    }

    private static boolean isDefaultPartition(IDocument document, int position, String partitioning) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)position, (boolean)false);
            return region.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findOpeningParenMatch(IDocument document, int position, String partitioning) {
        Assert.isTrue((position < document.getLength() ? 1 : 0) != 0);
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)SmartSemicolonAutoEditStrategy.isDefaultPartition(document, position, partitioning));
        try {
            Assert.isTrue((document.getChar(position) == ')' ? 1 : 0) != 0);
            int depth = 1;
            do {
                if ((position = SmartSemicolonAutoEditStrategy.scanBackward(document, position - 1, partitioning, -1, new char[]{')', '('})) == -1) {
                    return -1;
                }
                if (document.getChar(position) == ')') {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return position;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static boolean looksLikeIfWhileForCatch(IDocument document, int position, String partitioning) {
        if ((position = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, position, partitioning, -1)) == -1) {
            return false;
        }
        return SmartSemicolonAutoEditStrategy.looksLike(document, position, "if") || SmartSemicolonAutoEditStrategy.looksLike(document, position, "while") || SmartSemicolonAutoEditStrategy.looksLike(document, position, "catch") || SmartSemicolonAutoEditStrategy.looksLike(document, position, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(document, position, "switch") || SmartSemicolonAutoEditStrategy.looksLike(document, position, "for");
    }

    private static boolean looksLike(IDocument document, int position, String like) {
        int length;
        block5: {
            length = like.length();
            if (position < length - 1) {
                return false;
            }
            try {
                if (like.equals(document.get(position - length + 1, length))) break block5;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return position < length || !Character.isJavaIdentifierPart(like.charAt(0)) || !Character.isJavaIdentifierPart(document.getChar(position - length));
    }

    private static boolean looksLikeMethodDecl(IDocument document, int position, String partitioning) {
        if ((position = SmartSemicolonAutoEditStrategy.eatIdentToLeft(document, position, partitioning)) < 1) {
            return false;
        }
        if ((position = SmartSemicolonAutoEditStrategy.eatBrackets(document, position - 1, partitioning)) < 1) {
            return false;
        }
        return (position = SmartSemicolonAutoEditStrategy.eatIdentToLeft(document, position - 1, partitioning)) != -1;
    }

    private static int eatBrackets(IDocument document, int position, String partitioning) {
        int pos = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, position, partitioning, -1);
        try {
            if (pos > 1 && document.getChar(pos) == ']' && (pos = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(document, pos - 1, partitioning, -1)) > 0 && document.getChar(pos) == '[') {
                return pos;
            }
        }
        catch (BadLocationException badLocationException) {}
        return position;
    }

    /*
     * Exception decompiling
     */
    private static int eatIdentToLeft(IDocument document, int position, String partitioning) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int nextPartitionOrLineEnd(IDocument document, ITextSelection line, int offset, String partitioning) {
        int eol;
        int docOffset = offset + line.getOffset();
        int nextPartitionPos = eol = line.getOffset() + line.getLength();
        int validPosition = docOffset;
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)nextPartitionPos, (boolean)true);
            validPosition = SmartSemicolonAutoEditStrategy.getValidPositionForPartition(document, partition, eol);
            while (validPosition == -1) {
                nextPartitionPos = partition.getOffset() - 1;
                if (nextPartitionPos < docOffset) {
                    validPosition = docOffset;
                    break;
                }
                partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)nextPartitionPos, (boolean)false);
                validPosition = SmartSemicolonAutoEditStrategy.getValidPositionForPartition(document, partition, eol);
            }
        }
        catch (BadLocationException badLocationException) {}
        validPosition = Math.max(validPosition, docOffset);
        return validPosition -= line.getOffset();
    }

    private static int getValidPositionForPartition(IDocument doc, ITypedRegion partition, int maxOffset) {
        if ("__java_javadoc".equals(partition.getType())) {
            return -1;
        }
        if ("__java_multiline_comment".equals(partition.getType())) {
            return -1;
        }
        if ("__java_singleline_comment".equals(partition.getType())) {
            return -1;
        }
        int endOffset = Math.min(maxOffset, partition.getOffset() + partition.getLength());
        if ("__java_character".equals(partition.getType())) {
            return endOffset;
        }
        if ("__java_string".equals(partition.getType())) {
            return endOffset;
        }
        if ("__dftl_partition_content_type".equals(partition.getType())) {
            block9: {
                try {
                    if (doc.get(partition.getOffset(), endOffset - partition.getOffset()).trim().length() != 0) break block9;
                    return -1;
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }
            return endOffset;
        }
        return endOffset;
    }

    private static boolean isForStatement(String line, int offset) {
        int forPos = line.indexOf("for");
        return !(forPos == -1 || forPos != 0 && Character.isJavaIdentifierPart(line.charAt(forPos - 1)) || line.length() != forPos + 3 && Character.isJavaIdentifierPart(line.charAt(forPos + 3)));
    }

    private static int startOfWhitespaceBeforeOffset(String text, int offset) {
        int i = Math.min(offset, text.length());
        while (i >= 1) {
            if (!Character.isWhitespace(text.charAt(i - 1))) break;
            --i;
        }
        return i;
    }
}

