/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.jdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class ReorgPolicyFactory {
    private ReorgPolicyFactory() {
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, javaElements);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, javaElements);
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IJavaElement[] selectedJavaElements) throws JavaModelException {
        Object[] javaElements;
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedJavaElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        if (ReorgPolicyFactory.isNothingToReorg((IResource[])resources, (IJavaElement[])(javaElements = selectionComputer.getActualJavaElementsToReorg())) || ReorgPolicyFactory.containsNull(resources) || ReorgPolicyFactory.containsNull(javaElements) || ReorgUtils.isArchiveMember((IJavaElement[])javaElements) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 2) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 1) || ReorgUtils.hasElementsOfType((IResource[])resources, 12) || !ReorgPolicyFactory.haveCommonParent((IResource[])resources, (IJavaElement[])javaElements)) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 4)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 3)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 3) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 5)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])javaElements)) {
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 6) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IJavaElement[])javaElements) ? 1 : 0) != 0);
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            return new MoveSubCuElementsPolicy((IJavaElement[])javaElements);
        }
        return NO;
    }

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isInsideCompilationUnit(javaElements[i])) {
                return true;
            }
            if (ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(javaElements[i]) && !ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean haveCommonParent(IResource[] resources, IJavaElement[] javaElements) {
        return new ParentChecker(resources, javaElements).haveCommonParent();
    }

    private static boolean isNothingToReorg(IResource[] resources, IJavaElement[] javaElements) {
        return resources.length + javaElements.length == 0;
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private IResource fResourceDestination;
        private IJavaElement fJavaElementDestination;

        private ReorgPolicy() {
        }

        public final RefactoringStatus setDestination(IResource destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fResourceDestination = destination;
            return this.verifyDestination(destination);
        }

        public final RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            this.resetDestinations();
            this.fJavaElementDestination = destination;
            return this.verifyDestination(destination);
        }

        protected abstract RefactoringStatus verifyDestination(IJavaElement var1) throws JavaModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws JavaModelException;

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            return true;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        private void resetDestinations() {
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
        }

        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        public final IJavaElement getJavaElementDestination() {
            return this.fJavaElementDestination;
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IFile[] allModifiedFiles = this.getAllModifiedFiles();
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < allModifiedFiles.length) {
                deltaFactory.change(allModifiedFiles[i]);
                ++i;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker(ValidateEditChecker.class));
            }
            return new RefactoringStatus();
        }

        public boolean hasAllInputSet() {
            return this.fJavaElementDestination != null || this.fResourceDestination != null;
        }

        public boolean canUpdateReferences() {
            return false;
        }

        public boolean getUpdateReferences() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public void setUpdateReferences(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        public boolean canUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public String getFilePatterns() {
            Assert.isTrue((boolean)false);
            return null;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public void setFilePatterns(String patterns) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateQualifiedNames(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public boolean canEnable() throws JavaModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IJavaElement[] javaElements = this.getJavaElements();
            int i2 = 0;
            while (i2 < javaElements.length) {
                IJavaElement element = javaElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        private ICompilationUnit[] fCus;
        private IFolder[] fFolders;
        private IFile[] fFiles;

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            IOpenable openable;
            Assert.isNotNull((Object)javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!javaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (javaElement instanceof IOpenable && !(openable = (IOpenable)javaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideCompilationUnit(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            Assert.isTrue((resource.getType() != 8 ? 1 : 0) != 0);
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IContainer;
        }

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IJavaElement jelDest = this.getJavaElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(jelDest));
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IJavaElement je = JavaCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment javaAsPackage = FilesFoldersAndCusReorgPolicy.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            if (javaAsPackage != null) {
                return javaAsPackage;
            }
            return FilesFoldersAndCusReorgPolicy.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        private static IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement javaDest) {
            if (javaDest == null || !javaDest.exists()) {
                return null;
            }
            if (javaDest instanceof IPackageFragment) {
                return (IPackageFragment)javaDest;
            }
            if (javaDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)javaDest).getPackageFragment("");
            }
            if (javaDest instanceof IJavaProject) {
                try {
                    IPackageFragmentRoot root = ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaDest);
                    if (root != null) {
                        return root.getPackageFragment("");
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return (IPackageFragment)javaDest.getAncestor(4);
        }

        private static IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) {
            if (resource instanceof IFile) {
                return FilesFoldersAndCusReorgPolicy.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setFiles(this.fFiles);
            oh.setFolders(this.fFolders);
            oh.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                oh.confirmOverwritting(reorgQueries, (IJavaElement)destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    oh.confirmOverwritting(reorgQueries, (IResource)destinationAsContainer);
                }
            }
            this.fFiles = oh.getFilesWithoutUnconfirmedOnes();
            this.fFolders = oh.getFoldersWithoutUnconfirmedOnes();
            this.fCus = oh.getCusWithoutUnconfirmedOnes();
        }
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        private final IJavaElement[] fJavaElements;

        SubCuElementReorgPolicy(IJavaElement[] javaElements) {
            Assert.isNotNull((Object)javaElements);
            this.fJavaElements = javaElements;
        }

        protected final RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }

        protected final ICompilationUnit getSourceCu() {
            return (ICompilationUnit)this.fJavaElements[0].getAncestor(5);
        }

        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        public final IResource[] getResources() {
            return new IResource[0];
        }

        protected final ICompilationUnit getDestinationCu() {
            return SubCuElementReorgPolicy.getDestinationCu(this.getJavaElementDestination());
        }

        protected static final ICompilationUnit getDestinationCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        protected static CompilationUnitChange createCompilationUnitChange(ICompilationUnit cu, CompilationUnitRewrite rewrite) throws CoreException {
            CompilationUnitChange change = rewrite.createChange();
            if (change != null && cu.isWorkingCopy()) {
                change.setSaveMode(4);
            }
            return change;
        }

        protected void copyToDestination(IJavaElement element, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws CoreException {
            ASTRewrite rewrite = targetRewriter.getASTRewrite();
            switch (element.getElementType()) {
                case 8: {
                    this.copyMemberToDestination((IMember)element, targetRewriter, sourceCuNode, targetCuNode, this.createNewFieldDeclarationNode((IField)element, rewrite, sourceCuNode));
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private BodyDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite, CompilationUnit sourceCuNode) throws CoreException {
            block12: {
                block13: {
                    targetAst = rewrite.getAST();
                    buffer = null;
                    newDeclaration = null;
                    unit = field.getCompilationUnit();
                    buffer = RefactoringFileBuffers.acquire(unit);
                    document = buffer.getDocument();
                    bodyDeclaration = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration(field, sourceCuNode);
                    if (!(bodyDeclaration instanceof FieldDeclaration)) ** GOTO lbl25
                    fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                    if (fieldDeclaration.fragments().size() != 1) break block12;
                    var14_12 = (FieldDeclaration)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration);
                    if (buffer == null) break block13;
                    RefactoringFileBuffers.release(unit);
                }
                return var14_12;
            }
            try {
                try {
                    block15: {
                        originalFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, sourceCuNode);
                        copiedFragment = (VariableDeclarationFragment)ASTNode.copySubtree((AST)targetAst, (ASTNode)originalFragment);
                        newDeclaration = targetAst.newFieldDeclaration(copiedFragment);
                        newDeclaration.setType((Type)ASTNode.copySubtree((AST)targetAst, (ASTNode)fieldDeclaration.getType()));
                        break block15;
lbl25:
                        // 1 sources

                        if (bodyDeclaration instanceof EnumConstantDeclaration) {
                            constantDeclaration = (EnumConstantDeclaration)bodyDeclaration;
                            newConstDeclaration = targetAst.newEnumConstantDeclaration();
                            newConstDeclaration.setName((SimpleName)ASTNode.copySubtree((AST)targetAst, (ASTNode)constantDeclaration.getName()));
                            anonymousDeclaration = constantDeclaration.getAnonymousClassDeclaration();
                            if (anonymousDeclaration != null) {
                                newConstDeclaration.setAnonymousClassDeclaration((AnonymousClassDeclaration)rewrite.createStringPlaceholder(document.get(anonymousDeclaration.getStartPosition(), anonymousDeclaration.getLength()), 1));
                            }
                            newDeclaration = newConstDeclaration;
                        } else {
                            Assert.isTrue((boolean)false);
                        }
                    }
                    if (newDeclaration != null) {
                        newDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(targetAst, bodyDeclaration.getModifiers()));
                        javadoc = bodyDeclaration.getJavadoc();
                        if (javadoc != null) {
                            newDeclaration.setJavadoc((Javadoc)rewrite.createStringPlaceholder(document.get(javadoc.getStartPosition(), javadoc.getLength()), 29));
                        }
                    }
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                }
            }
            catch (Throwable var13_17) {
                throw var13_17;
            }
            finally {
                if (buffer != null) {
                    RefactoringFileBuffers.release(unit);
                }
            }
            return newDeclaration;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            IJavaElement[] importDeclarations = container.getChildren();
            int i = 0;
            while (i < importDeclarations.length) {
                Assert.isTrue((boolean)(importDeclarations[i] instanceof IImportDeclaration));
                IImportDeclaration importDeclaration = (IImportDeclaration)importDeclarations[i];
                this.copyImportToDestination(importDeclaration, rewrite, sourceCuNode, destinationCuNode);
                ++i;
            }
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
            ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY).insertLast((ASTNode)copiedNode, null);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            if (destinationCuNode.getPackage() != null) {
                return;
            }
            PackageDeclaration sourceNode = ASTNodeSearchUtil.getPackageDeclarationNode(declaration, sourceCuNode);
            PackageDeclaration copiedNode = (PackageDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.set((ASTNode)destinationCuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)copiedNode, null);
        }

        private void copyInitializerToDestination(IInitializer initializer, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newInitializer = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)initializer), 28);
            this.copyMemberToDestination((IMember)initializer, targetRewriter, sourceCuNode, targetCuNode, newInitializer);
        }

        private void copyTypeToDestination(IType type, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            AbstractTypeDeclaration newType = (AbstractTypeDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)type), 55);
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(this.getJavaElementDestination());
            if (enclosingType != null) {
                this.copyMemberToDestination((IMember)type, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newType);
            } else {
                targetRewriter.getASTRewrite().getListRewrite((ASTNode)targetCuNode, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)newType, null);
            }
        }

        private void copyMethodToDestination(IMethod method, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newMethod = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)method), 31);
            this.copyMemberToDestination((IMember)method, targetRewriter, sourceCuNode, targetCuNode, newMethod);
        }

        private void copyMemberToDestination(IMember member, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode, BodyDeclaration newMember) throws JavaModelException {
            BodyDeclaration decl;
            ASTNode destinationContainer;
            Initializer nodeDestination;
            IJavaElement javaElementDestination = this.getJavaElementDestination();
            switch (javaElementDestination.getElementType()) {
                case 10: {
                    nodeDestination = ASTNodeSearchUtil.getInitializerNode((IInitializer)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 8: {
                    nodeDestination = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 9: {
                    nodeDestination = ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 7: {
                    nodeDestination = null;
                    IType typeDestination = (IType)javaElementDestination;
                    if (typeDestination.isAnonymous()) {
                        destinationContainer = ASTNodeSearchUtil.getClassInstanceCreationNode(typeDestination, targetCuNode).getAnonymousClassDeclaration();
                        break;
                    }
                    destinationContainer = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(typeDestination, targetCuNode);
                    break;
                }
                default: {
                    nodeDestination = null;
                    destinationContainer = null;
                }
            }
            if (!(member instanceof IInitializer) && (decl = ASTNodeSearchUtil.getBodyDeclarationNode(member, sourceCuNode)) != null) {
                ImportRewriteUtil.addImports(targetRewriter, (ASTNode)decl, new HashMap(), new HashMap(), false);
            }
            if (destinationContainer != null) {
                ListRewrite listRewrite = destinationContainer instanceof AbstractTypeDeclaration ? (newMember instanceof EnumConstantDeclaration && destinationContainer instanceof EnumDeclaration ? targetRewriter.getASTRewrite().getListRewrite(destinationContainer, EnumDeclaration.ENUM_CONSTANTS_PROPERTY) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, ((AbstractTypeDeclaration)destinationContainer).getBodyDeclarationsProperty())) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                if (nodeDestination != null) {
                    List list = listRewrite.getOriginalList();
                    int index = list.indexOf(nodeDestination);
                    if (index > 0 && index < list.size() - 1) {
                        listRewrite.insertBefore((ASTNode)newMember, (ASTNode)list.get(index), null);
                    } else {
                        listRewrite.insertLast((ASTNode)newMember, null);
                    }
                } else {
                    listRewrite.insertAt((ASTNode)newMember, ASTNodes.getInsertionIndex(newMember, listRewrite.getRewrittenList()), null);
                }
                return;
            }
            AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDestinationAsType(), targetCuNode);
            targetRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertLast((ASTNode)newMember, null);
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws JavaModelException {
            Assert.isTrue((boolean)(sourceReference instanceof IJavaElement));
            String[] lines = Strings.convertIntoLines(sourceReference.getSource());
            IJavaProject project = ((IJavaElement)sourceReference).getJavaProject();
            Strings.trimIndentation(lines, project, false);
            return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)sourceReference));
        }

        private IType getDestinationAsType() throws JavaModelException {
            IJavaElement destination = this.getJavaElementDestination();
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(destination);
            if (enclosingType != null) {
                return enclosingType;
            }
            ICompilationUnit enclosingCu = SubCuElementReorgPolicy.getEnclosingCu(destination);
            Assert.isNotNull((Object)enclosingCu);
            IType mainType = JavaElementUtil.getMainType(enclosingCu);
            Assert.isNotNull((Object)mainType);
            return mainType;
        }

        private static ICompilationUnit getEnclosingCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement destination) {
            if (destination instanceof IType) {
                return (IType)destination;
            }
            return (IType)destination.getAncestor(7);
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fJavaElements.length) {
                IMember member;
                if (this.fJavaElements[i] instanceof IMember && (member = (IMember)this.fJavaElements[i]).isBinary() && member.getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            return this.recursiveVerifyDestination(destination);
        }

        private RefactoringStatus recursiveVerifyDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof ICompilationUnit) && !ReorgUtils.isInsideCompilationUnit(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ICompilationUnit destinationCu = SubCuElementReorgPolicy.getDestinationCu(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 5: {
                    int[] types0 = new int[]{8, 10, 9};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types0)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package_decl);
                }
                case 12: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 13: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.recursiveVerifyDestination(destination.getParent());
                }
                case 7: {
                    int[] types1 = new int[]{13, 12, 11};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types1)) break;
                    return this.recursiveVerifyDestination(destination.getParent());
                }
            }
            return new RefactoringStatus();
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IPackageFragmentRoot[] getRoots() {
            return this.fPackageFragmentRoots;
        }

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] roots) {
            Assert.isNotNull((Object)roots);
            this.fPackageFragmentRoots = roots;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                if (!(ReorgUtils.isSourceFolder((IJavaElement)this.fPackageFragmentRoots[i]) || this.fPackageFragmentRoots[i].isArchive() && !this.fPackageFragmentRoots[i].isExternal())) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return javaElement.getElementType() == 2;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(javaElement instanceof IJavaProject) && !(javaElement instanceof IPackageFragmentRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtils.isPackageFragmentRoot(javaElement.getJavaProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        protected IJavaProject getDestinationJavaProject() {
            return this.getDestinationAsJavaProject(this.getJavaElementDestination());
        }

        private IJavaProject getDestinationAsJavaProject(IJavaElement javaElementDestination) {
            if (javaElementDestination == null) {
                return null;
            }
            return javaElementDestination.getJavaProject();
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return status;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject javaProject = this.getDestinationJavaProject();
            oh.confirmOverwritting(reorgQueries, (IJavaElement)javaProject);
            this.fPackageFragmentRoots = oh.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        public PackagesReorgPolicy(IPackageFragment[] packageFragments) {
            Assert.isNotNull((Object)packageFragments);
            this.fPackageFragments = packageFragments;
        }

        public boolean canEnable() throws JavaModelException {
            int i = 0;
            while (i < this.fPackageFragments.length) {
                if (JavaElementUtil.isDefaultPackage(this.fPackageFragments[i]) || this.fPackageFragments[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement javaElement) throws JavaModelException {
            IPackageFragment pack;
            if (javaElement == null) {
                return null;
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)javaElement;
            }
            if (javaElement instanceof IPackageFragment && (pack = (IPackageFragment)javaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)pack.getParent();
            }
            if (javaElement instanceof IJavaProject) {
                return ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaElement);
            }
            return null;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot(javaElement);
            if (!ReorgUtils.isSourceFolder((IJavaElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwritting(reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwritting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackages(this.fPackageFragments);
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot();
            oh.confirmOverwritting(reorgQueries, (IJavaElement)destRoot);
            this.fPackageFragments = oh.getPackagesWithoutUnconfirmedOnes();
        }
    }

    private static class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments args = new CopyArguments((Object)this.getJavaElementDestination(), this.fReorgExecutionLog);
            IJavaElement[] javaElements = this.getJavaElements();
            int i = 0;
            while (i < javaElements.length) {
                this.fModifications.copy(javaElements[i], args, null);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit targetCu = this.getDestinationCu();
                CompilationUnitRewrite targetRewriter = new CompilationUnitRewrite(targetCu);
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewriter, sourceCuNode, targetRewriter.getRoot());
                    ++i;
                }
                return CopySubCuElementsPolicy.createCompilationUnitChange(targetCu, targetRewriter);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue((this.getSourceCu() != null || this.getSourceClassFile() != null ? 1 : 0) != 0);
            Assert.isTrue((this.getSourceCu() == null || this.getSourceClassFile() == null ? 1 : 0) != 0);
            ASTParser parser = ASTParser.newParser((int)3);
            if (this.getSourceCu() != null) {
                parser.setSource(this.getSourceCu());
            } else {
                parser.setSource(this.getSourceClassFile());
            }
            return (CompilationUnit)parser.createAST(null);
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }
    }

    private static class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ICompilationUnit[] cus = this.getCus();
            int i = 0;
            while (i < cus.length) {
                this.fModifications.copy(cus[i], jArgs, rArgs);
                ++i;
            }
            IResource[] resources = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int i2 = 0;
            while (i2 < resources.length) {
                this.fModifications.copy(resources[i2], rArgs);
                ++i2;
            }
            return this.fModifications;
        }

        private Object getDestination() {
            IPackageFragment result = this.getDestinationAsPackageFragment();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            composite.markAsSynthetic();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(ICompilationUnit unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        private static Change copyFileToContainer(ICompilationUnit cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource((IJavaElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        private static Change copyCuToPackage(ICompilationUnit cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtils.getResource((IJavaElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = ResourceUtil.getResource(cu).getParent().getFullPath().append(newName);
                INewNameQuery nameQuery = copyQueries.createNewCompilationUnitNameQuery(cu, newName);
                return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }
    }

    private static class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments javaArgs = new CopyArguments((Object)this.getDestinationJavaProject(), this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)this.getDestinationJavaProject().getProject(), this.fReorgExecutionLog);
            IPackageFragmentRoot[] roots = this.getRoots();
            int i = 0;
            while (i < roots.length) {
                this.fModifications.copy(roots[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination, nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageFragmentRootNameQuery(root, newName);
            return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, null);
        }
    }

    private static class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IPackageFragmentRoot destination = this.getDestinationAsPackageFragmentRoot();
            CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)destination.getResource(), this.fReorgExecutionLog);
            IPackageFragment[] packages = this.getPackages();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.copy(packages[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws JavaModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            composite.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                composite.add(this.createChange(fragments[i], root, nameProposer, newNameQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack, destination);
            if (newName == null || JavaConventions.validatePackageName((String)newName).getSeverity() < 4) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyPackageChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }
    }

    private static class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }
    }

    private static class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        private NewNameProposer() {
        }

        public String createNewName(ICompilationUnit cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOf1, cu.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOfMore, new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return NewNameProposer.removeTrailingJava(newName);
                }
                ++i;
            }
        }

        private static String removeTrailingJava(String name) {
            return JavaCore.removeJavaLikeExtension((String)name);
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOf1, res.getName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOfMore, new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, pack.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getCompilationUnit(newName).exists();
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }
    }

    private static class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private MoveModifications fModifications;

        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            boolean updateReferences;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IJavaProject destination = this.getDestinationJavaProject();
            boolean bl = updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            if (destination != null) {
                IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.move(roots[i], new MoveArguments((Object)destination, updateReferences));
                    ++i;
                }
            }
            return this.fModifications;
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination) {
            return new MovePackageFragmentRootChange(root, destination.getProject(), null);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(javaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IJavaProject javaProject, IPackageFragmentRoot[] roots) {
            int i = 0;
            while (i < roots.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(roots[i], javaProject)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                ResourceAttributes attributes;
                if (roots[i].isReadOnly() && !roots[i].isArchive() && ((attributes = roots[i].getResource().getResourceAttributes()) == null || attributes.isReadOnly())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private MoveModifications fModifications;

        MovePackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            IPackageFragment[] packages = this.getPackages();
            IPackageFragmentRoot javaDestination = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.move(packages[i], new MoveArguments((Object)javaDestination, updateReferences));
                ++i;
            }
            return this.fModifications;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return superStatus;
        }

        private static boolean isParentOfAny(IPackageFragmentRoot root, IPackageFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            result.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                result.add(this.createChange(fragments[i], root));
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            pm.done();
            return result;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination) {
            return new MovePackageChange(pack, destination);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private boolean fUpdateReferences = true;
        private boolean fUpdateQualifiedNames = false;
        private QualifiedNameSearchResult fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        private String fFilePatterns;
        private TextChangeManager fChangeManager;
        private MoveModifications fModifications;

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        protected RefactoringModifications getModifications() throws CoreException {
            int i;
            boolean updateReferenes;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean bl = updateReferenes = this.canUpdateReferences() && this.getUpdateReferences();
            if (unitDestination != null) {
                ICompilationUnit[] units = this.getCus();
                i = 0;
                while (i < units.length) {
                    this.fModifications.move(units[i], new MoveArguments(unitDestination, updateReferenes));
                    ++i;
                }
            }
            if (container != null) {
                IFile[] files = this.getFiles();
                i = 0;
                while (i < files.length) {
                    this.fModifications.move((IResource)files[i], new MoveArguments((Object)container, updateReferenes));
                    ++i;
                }
                IFolder[] folders = this.getFolders();
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fModifications.move((IResource)folders[i2], new MoveArguments((Object)container, updateReferenes));
                    ++i2;
                }
            }
            return this.fModifications;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IJavaElement destinationContainerAsPackage = this.getDestinationContainerAsJavaElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            if (this.fQualifiedNameSearchResult != null) {
                return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
            }
            return null;
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                    RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null);
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                composite.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                Change fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (fileMove instanceof CompositeChange) {
                    composite.merge((CompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                DynamicValidationStateChange dynamicValidationStateChange = composite;
                return dynamicValidationStateChange;
            }
            finally {
                pm.done();
            }
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            pm.beginTask("", 1);
            try {
                if (!this.fUpdateReferences) {
                    TextChangeManager textChangeManager = new TextChangeManager();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest != null) {
                    MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.getCus(), packageDest);
                    TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
                    return textChangeManager;
                }
                TextChangeManager textChangeManager = new TextChangeManager();
                return textChangeManager;
            }
            finally {
                pm.done();
            }
        }

        private Change createSimpleMoveChange(IProgressMonitor pm) {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            result.markAsSynthetic();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            int i = 0;
            while (i < files.length) {
                result.add(this.createChange((IResource)files[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                result.add(this.createChange((IResource)folders[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < cus.length) {
                result.add(this.createChange(cus[i]));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        private Change createChange(ICompilationUnit cu) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        private static Change moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
            IResource resource = ResourceUtil.getResource(cu);
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveCompilationUnitChange(cu, dest);
        }

        private static Change moveFileToContainer(ICompilationUnit cu, IContainer dest) {
            return new MoveResourceChange(ResourceUtil.getResource(cu), dest);
        }

        private Change createChange(IResource res) {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment destination = this.getDestinationAsPackageFragment();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length);
            pm.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                IType[] types = cu.getTypes();
                SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                typesMonitor.beginTask("", types.length);
                int j = 0;
                while (j < types.length) {
                    this.handleType(types[j], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                    if (typesMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ++j;
                }
                typesMonitor.done();
                ++i;
            }
            pm.done();
        }

        private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, type.getFullyQualifiedName(), String.valueOf(destination.getElementName()) + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                pm.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                RefactoringStatus result = new RefactoringStatus();
                this.confirmMovingReadOnly(reorgQueries);
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                if (this.fUpdateQualifiedNames) {
                    this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 4));
                }
                result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        public IFile[] getAllModifiedFiles() {
            HashSet result = new HashSet();
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        public boolean canUpdateReferences() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null && pack.isDefaultPackage()) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return !JavaElementUtil.isDefaultPackage(commonParent);
        }

        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        public boolean canUpdateQualifiedNames() {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            return this.canEnableQualifiedNameUpdating() && pack != null && !pack.isDefaultPackage();
        }

        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        public boolean isTextualMove() {
            return false;
        }
    }

    private static class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        MoveSubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            IJavaElement[] elements = this.getJavaElements();
            int i = 0;
            while (i < elements.length) {
                IJavaElement parent = destination.getParent();
                while (parent != null) {
                    if (parent.equals(elements[i])) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    parent = parent.getParent();
                }
                ++i;
            }
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent) || Arrays.asList(this.getJavaElements()).contains(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            pm.beginTask("", 3);
            try {
                CompilationUnitRewrite targetRewriter;
                ICompilationUnit sourceCu = this.getSourceCu();
                CompilationUnit sourceCuNode = RefactoringASTParser.parseWithASTProvider(sourceCu, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(sourceCu, sourceCuNode);
                ICompilationUnit destinationCu = this.getDestinationCu();
                if (sourceCu.equals(destinationCu)) {
                    targetRewriter = sourceRewriter;
                    pm.worked(1);
                } else {
                    CompilationUnit destinationCuNode = RefactoringASTParser.parseWithASTProvider(destinationCu, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    targetRewriter = new CompilationUnitRewrite(destinationCu, destinationCuNode);
                }
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewriter, sourceRewriter.getRoot(), targetRewriter.getRoot());
                    ++i;
                }
                ASTNodeDeleteUtil.markAsDeleted(javaElements, sourceRewriter, null);
                CompilationUnitChange targetCuChange = MoveSubCuElementsPolicy.createCompilationUnitChange(destinationCu, targetRewriter);
                if (sourceCu.equals(destinationCu)) {
                    CompilationUnitChange compilationUnitChange = targetCuChange;
                    return compilationUnitChange;
                }
                DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_members);
                result.markAsSynthetic();
                result.add((Change)targetCuChange);
                if (Arrays.asList(this.getJavaElements()).containsAll((Collection)Arrays.asList(sourceCu.getTypes()))) {
                    result.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{sourceCu}, RefactoringCoreMessages.ReorgPolicy_move));
                } else {
                    result.add((Change)MoveSubCuElementsPolicy.createCompilationUnitChange(sourceCu, sourceRewriter));
                }
                DynamicValidationStateChange dynamicValidationStateChange = result;
                return dynamicValidationStateChange;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            finally {
                pm.done();
            }
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getSourceCu()), ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return true;
        }
    }

    private static class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        public boolean isTextualMove() {
            return true;
        }
    }

    private static class ActualSelectionComputer {
        private final IResource[] fResources;
        private final IJavaElement[] fJavaElements;

        public ActualSelectionComputer(IJavaElement[] javaElements, IResource[] resources) {
            this.fJavaElements = javaElements;
            this.fResources = resources;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                if (element != null && !ReorgUtils.isDeletedFromEditor(element)) {
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        ICompilationUnit cu = type.getCompilationUnit();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!result.contains(element)) {
                        result.add(element);
                    }
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet javaElementSet = new HashSet(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                IJavaElement element;
                if (!(this.fResources[i] == null || (element = JavaCore.create((IResource)this.fResources[i])) != null && element.exists() && javaElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }
}

