/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedFix;
import org.eclipse.jdt.internal.corext.fix.PositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEditGroup;

public class ConvertForLoopOperation
extends LinkedFix.AbstractLinkedFixRewriteOperation {
    private ForStatement fOldForStatement;
    private EnhancedForStatement fEnhancedForStatement;
    private AST fAst;
    private Name fCollectionName;
    private SingleVariableDeclaration fParameterDeclaration;
    private ITypeBinding fOldCollectionTypeBinding;
    private IBinding fOldCollectionBinding;
    private IBinding fIndexBinding;
    private boolean fCollectionIsMethodCall = false;
    private MethodInvocation fMethodInvocation;
    private final String fParameterName;
    private final ICompilationUnit fCompilationUnit;
    private FieldAccess fFieldAccess;
    private final CompilationUnit fRoot;
    private final boolean fAddBlock;
    private final boolean fRemoveUnnecessaryBlocks;

    public ConvertForLoopOperation(CompilationUnit root, ForStatement forStatement, String parameterName, boolean addBlock, boolean removeUnnecessaryBlocks) {
        this.fRoot = root;
        this.fAddBlock = addBlock;
        this.fRemoveUnnecessaryBlocks = removeUnnecessaryBlocks;
        this.fCompilationUnit = (ICompilationUnit)root.getJavaElement();
        this.fOldForStatement = forStatement;
        this.fAst = root.getAST();
        this.fParameterName = parameterName;
    }

    public boolean satisfiesPreconditions() {
        return JavaModelUtil.is50OrHigher(this.fCompilationUnit.getJavaProject()) && this.fOldForStatement.getExpression() != null && this.arrayCanBeInferred() && this.typeBindingsAreNotNull() && this.bodySatifiesPreconditions() && this.initializersSatisfyPreconditions() && this.updatersSatifyPreconditions();
    }

    private boolean typeBindingsAreNotNull() {
        this.fIndexBinding = this.getIndexBinding();
        return this.fOldCollectionBinding != null && this.fOldCollectionTypeBinding != null && this.fIndexBinding != null;
    }

    private boolean bodySatifiesPreconditions() {
        final ArrayList writeAccesses = new ArrayList();
        final boolean[] isIndexReferenced = new boolean[1];
        this.fOldForStatement.getBody().accept(new ASTVisitor(){

            public boolean visit(Assignment assignment) {
                this.classifyWriteAccess(assignment.getLeftHandSide());
                return true;
            }

            public boolean visit(PostfixExpression node) {
                this.classifyWriteAccess(node.getOperand());
                return true;
            }

            public boolean visit(PrefixExpression node) {
                this.classifyWriteAccess(node.getOperand());
                return true;
            }

            public boolean visit(SimpleName name) {
                IBinding binding = name.resolveBinding();
                if (Bindings.equals(ConvertForLoopOperation.this.fIndexBinding, binding)) {
                    ASTNode parent = name.getParent();
                    isIndexReferenced[0] = parent instanceof ArrayAccess ? isIndexReferenced[0] || ConvertForLoopOperation.this.isAccessToADifferentArray((ArrayAccess)parent) : true;
                }
                return false;
            }

            private void classifyWriteAccess(Expression expression) {
                if (expression instanceof ArrayAccess) {
                    ConvertForLoopOperation.this.checkThatArrayIsNotAssigned(writeAccesses, expression);
                } else if (expression instanceof Name) {
                    ConvertForLoopOperation.this.checkThatIndexIsNotAssigned(writeAccesses, expression);
                }
            }
        });
        return writeAccesses.isEmpty() && !isIndexReferenced[0];
    }

    private void checkThatIndexIsNotAssigned(List writeAccesses, Expression expression) {
        Name name = (Name)expression;
        IBinding binding = name.resolveBinding();
        if (binding == this.fIndexBinding) {
            writeAccesses.add(name);
        }
    }

    private void checkThatArrayIsNotAssigned(List writeAccesses, Expression expression) {
        Name arrayName;
        IBinding binding;
        ArrayAccess arrayAccess = (ArrayAccess)expression;
        if (arrayAccess.getArray() instanceof Name && (binding = (arrayName = (Name)arrayAccess.getArray()).resolveBinding()) == this.fOldCollectionBinding) {
            writeAccesses.add(arrayAccess);
        }
    }

    private boolean isAccessToADifferentArray(ArrayAccess arrayAccess) {
        Expression expression = arrayAccess.getArray();
        if (expression instanceof Name) {
            return this.isNameDifferentThanInferredArray((Name)expression);
        }
        if (expression instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)expression;
            return this.isNameDifferentThanInferredArray((Name)fieldAccess.getName());
        }
        if (expression instanceof MethodInvocation) {
            return true;
        }
        return true;
    }

    private boolean isNameDifferentThanInferredArray(Name name) {
        IBinding arrayBinding = name.resolveBinding();
        return !Bindings.equals(this.fOldCollectionBinding, arrayBinding);
    }

    private boolean updatersSatifyPreconditions() {
        return this.onlyOneIndexUsed() && this.indexNotDecremented();
    }

    private boolean indexNotDecremented() {
        ASTNode updater = (ASTNode)this.fOldForStatement.updaters().get(0);
        if (updater instanceof PostfixExpression && "++".equals(((PostfixExpression)updater).getOperator().toString())) {
            return true;
        }
        return updater instanceof PrefixExpression && "++".equals(((PrefixExpression)updater).getOperator().toString());
    }

    private boolean initializersSatisfyPreconditions() {
        final ArrayList tempVarsInInitializers = new ArrayList();
        final boolean[] startsFromZero = new boolean[1];
        List initializers = this.fOldForStatement.initializers();
        for (Expression element : initializers) {
            if (!(element instanceof VariableDeclarationExpression)) {
                return false;
            }
            element.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment declarationFragment) {
                    SimpleName indexName = declarationFragment.getName();
                    tempVarsInInitializers.add(indexName);
                    startsFromZero[0] = ConvertForLoopOperation.this.doesIndexStartFromZero((Name)indexName, (ASTNode)declarationFragment);
                    return false;
                }

                public boolean visit(Assignment assignment) {
                    if (assignment.getLeftHandSide() instanceof Name) {
                        Name indexName = (Name)assignment.getLeftHandSide();
                        tempVarsInInitializers.add(indexName);
                        startsFromZero[0] = ConvertForLoopOperation.this.doesIndexStartFromZero(indexName, (ASTNode)assignment);
                    }
                    return false;
                }
            });
        }
        this.removeInferredIndexFrom(tempVarsInInitializers);
        return startsFromZero[0] && this.additionalTempsNotReferenced(tempVarsInInitializers);
    }

    private boolean doesIndexStartFromZero(Name indexName, ASTNode declaringNode) {
        IBinding binding = indexName.resolveBinding();
        if (Bindings.equals(this.fIndexBinding, binding)) {
            Expression initializer = null;
            if (declaringNode instanceof VariableDeclarationFragment) {
                initializer = ((VariableDeclarationFragment)declaringNode).getInitializer();
            } else if (declaringNode instanceof Assignment) {
                initializer = ((Assignment)declaringNode).getRightHandSide();
            }
            if (initializer instanceof NumberLiteral) {
                NumberLiteral number = (NumberLiteral)initializer;
                if (!"0".equals(number.getToken())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void removeInferredIndexFrom(List localTemps) {
        Name indexName = null;
        for (Name name : localTemps) {
            IBinding binding = name.resolveBinding();
            if (!Bindings.equals(this.fIndexBinding, binding)) continue;
            indexName = name;
            break;
        }
        localTemps.remove(indexName);
    }

    private boolean additionalTempsNotReferenced(List localTemps) {
        for (Name name : localTemps) {
            LocalOccurencesFinder finder = new LocalOccurencesFinder(name, (ASTNode)this.fOldForStatement.getBody());
            finder.perform();
            if (finder.getOccurences().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean onlyOneIndexUsed() {
        return this.fOldForStatement.updaters().size() == 1;
    }

    private boolean arrayCanBeInferred() {
        this.doInferCollection();
        return this.fCollectionName != null && this.fOldCollectionTypeBinding != null && this.fOldCollectionTypeBinding.isArray();
    }

    private IBinding inferIndexBinding() {
        Assignment assignment;
        Expression lhs;
        List initializers = this.fOldForStatement.initializers();
        if (initializers.size() == 0) {
            return null;
        }
        Expression expression = (Expression)initializers.get(0);
        if (expression instanceof VariableDeclarationExpression) {
            VariableDeclarationFragment declaration = (VariableDeclarationFragment)((VariableDeclarationExpression)expression).fragments().get(0);
            SimpleName indexName = declaration.getName();
            this.fIndexBinding = indexName.resolveBinding();
        } else if (expression instanceof Assignment && (lhs = (assignment = (Assignment)expression).getLeftHandSide()) instanceof Name) {
            Name indexName = (Name)lhs;
            this.fIndexBinding = indexName.resolveBinding();
        }
        return this.fIndexBinding;
    }

    private ITrackedNodePosition doConvert(ASTRewrite rewrite, ImportRewrite importRewrite, TextEditGroup group) throws CoreException {
        Statement theBody;
        this.doInferCollection();
        this.doInferElement(importRewrite);
        this.doFindAndReplaceInBody(rewrite, group);
        AST ast = this.fOldForStatement.getAST();
        this.fEnhancedForStatement = ast.newEnhancedForStatement();
        if (this.fAddBlock && !(this.fOldForStatement.getBody() instanceof Block)) {
            theBody = (Statement)rewrite.createMoveTarget((ASTNode)this.fOldForStatement.getBody());
            Block newBody = ast.newBlock();
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)newBody, Block.STATEMENTS_PROPERTY);
            listRewrite.insertFirst((ASTNode)theBody, group);
            this.fEnhancedForStatement.setBody((Statement)newBody);
        } else if (this.fRemoveUnnecessaryBlocks && this.fOldForStatement.getBody() instanceof Block && ((Block)this.fOldForStatement.getBody()).statements().size() == 1) {
            Statement moveTarget = (Statement)rewrite.createMoveTarget((ASTNode)((Statement)((Block)this.fOldForStatement.getBody()).statements().get(0)));
            this.fEnhancedForStatement.setBody(moveTarget);
        } else {
            theBody = (Statement)rewrite.createMoveTarget((ASTNode)this.fOldForStatement.getBody());
            this.fEnhancedForStatement.setBody(theBody);
        }
        this.fEnhancedForStatement.setExpression(this.createExpression(rewrite, ast));
        this.fEnhancedForStatement.setParameter(this.fParameterDeclaration);
        PositionGroup pg = this.getPositionGroup(this.fParameterName);
        pg.addFirstPosition(rewrite.track((ASTNode)this.fParameterDeclaration.getName()));
        String name = this.fParameterDeclaration.getName().getIdentifier();
        List proposals = this.getProposalsForElement();
        if (!proposals.contains(name)) {
            proposals.add(0, name);
        }
        Iterator iterator = proposals.iterator();
        while (iterator.hasNext()) {
            pg.addProposal((String)iterator.next(), null);
        }
        rewrite.replace((ASTNode)this.fOldForStatement, (ASTNode)this.fEnhancedForStatement, group);
        return null;
    }

    private Expression createExpression(ASTRewrite rewrite, AST ast) {
        if (this.fCollectionIsMethodCall) {
            MethodInvocation methodCall = (MethodInvocation)rewrite.createMoveTarget((ASTNode)this.fMethodInvocation);
            return methodCall;
        }
        if (this.fFieldAccess != null) {
            return (FieldAccess)rewrite.createMoveTarget((ASTNode)this.fFieldAccess);
        }
        return this.fCollectionName;
    }

    private List getProposalsForElement() {
        ArrayList<String> list = new ArrayList<String>();
        ICompilationUnit icu = this.fCompilationUnit;
        IJavaProject javaProject = icu.getJavaProject();
        int dimensions = this.fOldCollectionTypeBinding.getDimensions() - 1;
        List used = this.getUsedVariableNames();
        String type = this.fOldCollectionTypeBinding.getName();
        if (this.fOldCollectionTypeBinding.isArray()) {
            type = this.fOldCollectionTypeBinding.getElementType().getName();
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(javaProject, type, dimensions, used.toArray(new String[used.size()]));
        int i = 0;
        while (i < proposals.length) {
            list.add(proposals[i]);
            ++i;
        }
        return list;
    }

    private List getUsedVariableNames() {
        CompilationUnit root = (CompilationUnit)this.fOldForStatement.getRoot();
        IBinding[] varsBefore = new ScopeAnalyzer(root).getDeclarationsInScope(this.fOldForStatement.getStartPosition(), 2);
        IBinding[] varsAfter = new ScopeAnalyzer(root).getDeclarationsAfter(this.fOldForStatement.getStartPosition() + this.fOldForStatement.getLength(), 2);
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < varsBefore.length) {
            names.add(varsBefore[i].getName());
            ++i;
        }
        i = 0;
        while (i < varsAfter.length) {
            names.add(varsAfter[i].getName());
            ++i;
        }
        return names;
    }

    private void doFindAndReplaceInBody(ASTRewrite rewrite, TextEditGroup group) {
        LocalOccurencesFinder finder = new LocalOccurencesFinder(this.fCollectionName, this.fOldCollectionBinding, this.fOldCollectionTypeBinding, (ASTNode)this.fOldForStatement.getBody());
        finder.perform();
        List occurences = finder.getOccurences();
        if (occurences.size() == 1) {
            ArrayAccess arrayAccess;
            ASTNode soleOccurence = (ASTNode)occurences.get(0);
            ArrayAccess arrayAccess2 = arrayAccess = soleOccurence instanceof ArrayAccess ? (ArrayAccess)soleOccurence : (ArrayAccess)ASTNodes.getParent(soleOccurence, ArrayAccess.class);
            if (arrayAccess != null && arrayAccess.getParent() instanceof VariableDeclarationFragment) {
                this.replaceSingleVariableDeclaration(rewrite, arrayAccess, group);
                return;
            }
        }
        this.replaceMultipleOccurences(rewrite, occurences, group);
    }

    private void replaceSingleVariableDeclaration(ASTRewrite rewrite, ArrayAccess arrayAccess, TextEditGroup group) {
        VariableDeclarationFragment declarationFragment = (VariableDeclarationFragment)arrayAccess.getParent();
        VariableDeclarationStatement declarationStatement = (VariableDeclarationStatement)declarationFragment.getParent();
        if (this.fParameterDeclaration == null) {
            this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
        }
        SimpleName theTempVariable = declarationFragment.getName();
        SimpleName name = this.fAst.newSimpleName(theTempVariable.getIdentifier());
        Type type = ASTNodeFactory.newType(this.getAst(), (VariableDeclaration)declarationFragment);
        this.fParameterDeclaration.setName(name);
        this.fParameterDeclaration.setType(type);
        if (ASTNodes.findModifierNode(16, declarationStatement.modifiers()) != null) {
            ModifierRewrite.create(rewrite, (ASTNode)this.fParameterDeclaration).setModifiers(16, 0, group);
        }
        LocalOccurencesFinder finder2 = new LocalOccurencesFinder(theTempVariable.resolveBinding(), (ASTNode)this.fOldForStatement.getBody());
        finder2.perform();
        List occurences2 = finder2.getOccurences();
        this.linkAllReferences(rewrite, occurences2);
        rewrite.replace((ASTNode)declarationStatement, null, group);
    }

    private void linkAllReferences(ASTRewrite rewrite, List occurences) {
        for (ASTNode variableRef : occurences) {
            this.getPositionGroup(this.fParameterName).addPosition(rewrite.track(variableRef));
        }
    }

    private void replaceMultipleOccurences(ASTRewrite rewrite, List occurences, TextEditGroup group) {
        for (ASTNode element : occurences) {
            ArrayAccess arrayAccess;
            ArrayAccess arrayAccess2 = arrayAccess = element instanceof ArrayAccess ? (ArrayAccess)element : (ArrayAccess)ASTNodes.getParent(element, ArrayAccess.class);
            if (arrayAccess == null) continue;
            SimpleName elementReference = this.fAst.newSimpleName(this.fParameterDeclaration.getName().getIdentifier());
            rewrite.replace((ASTNode)arrayAccess, (ASTNode)elementReference, group);
            this.getPositionGroup(this.fParameterName).addPosition(rewrite.track((ASTNode)elementReference));
        }
    }

    private void doInferElement(ImportRewrite importRewrite) throws CoreException {
        if (this.fCollectionName == null) {
            this.createDefaultParameter();
        } else if (this.fOldCollectionTypeBinding.isArray()) {
            ITypeBinding elementType = this.fOldCollectionTypeBinding.getElementType();
            this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
            SimpleName name = this.fAst.newSimpleName(this.fParameterName);
            this.fParameterDeclaration.setName(name);
            Type theType = this.importType(elementType, (ASTNode)this.fOldForStatement, importRewrite, this.fRoot);
            if (this.fOldCollectionTypeBinding.getDimensions() != 1) {
                theType = this.fAst.newArrayType(theType, this.fOldCollectionTypeBinding.getDimensions() - 1);
            }
            this.fParameterDeclaration.setType(theType);
        }
    }

    private void createDefaultParameter() {
        this.fParameterDeclaration = this.fAst.newSingleVariableDeclaration();
        SimpleName name = this.fAst.newSimpleName(this.fParameterName);
        PrimitiveType type = this.fAst.newPrimitiveType(PrimitiveType.INT);
        this.fParameterDeclaration.setName(name);
        this.fParameterDeclaration.setType((Type)type);
    }

    private void doInferCollection() {
        if (this.fCollectionName != null) {
            return;
        }
        this.doInferCollectionFromExpression();
        if (this.fCollectionName == null) {
            this.doInferCollectionFromInitializers();
        }
    }

    private void doInferCollectionFromExpression() {
        Expression stopCondition = this.fOldForStatement.getExpression();
        if (stopCondition.getNodeType() == 27) {
            FieldAccess fieldAccess;
            Expression rightOperand = ((InfixExpression)stopCondition).getRightOperand();
            if (rightOperand.getNodeType() == 40) {
                Name qualifier = ((QualifiedName)rightOperand).getQualifier();
                this.fCollectionName = ASTNodeFactory.newName(this.fAst, qualifier.getFullyQualifiedName());
                this.fOldCollectionBinding = qualifier.resolveBinding();
                this.fOldCollectionTypeBinding = qualifier.resolveTypeBinding();
            } else if (rightOperand.getNodeType() == 32) {
                MethodInvocation methodCall = (MethodInvocation)rightOperand;
                Expression exp = methodCall.getExpression();
                if (exp instanceof Name) {
                    Name collectionName = (Name)exp;
                    this.fOldCollectionBinding = collectionName.resolveBinding();
                    this.fOldCollectionTypeBinding = collectionName.resolveTypeBinding();
                    this.fCollectionName = ASTNodeFactory.newName(this.fAst, collectionName.getFullyQualifiedName());
                }
            } else if (rightOperand instanceof FieldAccess && "length".equals((fieldAccess = (FieldAccess)rightOperand).getName().getIdentifier())) {
                if (fieldAccess.getExpression() instanceof MethodInvocation) {
                    MethodInvocation methodCall;
                    this.fCollectionIsMethodCall = true;
                    this.fMethodInvocation = methodCall = (MethodInvocation)fieldAccess.getExpression();
                    this.fOldCollectionBinding = methodCall.resolveMethodBinding();
                    this.fOldCollectionTypeBinding = methodCall.resolveTypeBinding();
                    this.fCollectionName = ASTNodeFactory.newName(this.fAst, methodCall.getName().getFullyQualifiedName());
                } else if (fieldAccess.getExpression() instanceof FieldAccess) {
                    FieldAccess fieldCall;
                    this.fFieldAccess = fieldCall = (FieldAccess)fieldAccess.getExpression();
                    this.fOldCollectionBinding = fieldCall.resolveFieldBinding();
                    this.fOldCollectionTypeBinding = fieldCall.resolveTypeBinding();
                    this.fCollectionName = ASTNodeFactory.newName(this.fAst, fieldCall.getName().getFullyQualifiedName());
                }
            }
        }
    }

    private void doInferCollectionFromInitializers() {
        List initializers = this.fOldForStatement.initializers();
        for (Object next : initializers) {
            if (next instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression element = (VariableDeclarationExpression)next;
                List declarationFragments = element.fragments();
                for (VariableDeclarationFragment fragment : declarationFragments) {
                    Expression initializer = fragment.getInitializer();
                    if (initializer == null) continue;
                    this.doInferCollectionFromExpression(initializer);
                }
                continue;
            }
            if (!(next instanceof Assignment)) continue;
            Assignment assignemnt = (Assignment)next;
            this.doInferCollectionFromExpression(assignemnt.getRightHandSide());
        }
    }

    private void doInferCollectionFromExpression(Expression expression) {
        final boolean[] foundMoreThenOneArray = new boolean[]{false};
        expression.accept(new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                this.initializeBindings(qualifiedName.getQualifier());
                return false;
            }

            public boolean visit(SimpleName simpleName) {
                this.initializeBindings((Name)simpleName);
                return false;
            }

            public boolean visit(MethodInvocation methodCall) {
                ITypeBinding typeBinding = methodCall.resolveTypeBinding();
                if (typeBinding.isArray()) {
                    ConvertForLoopOperation.this.fCollectionIsMethodCall = true;
                    ConvertForLoopOperation.this.fMethodInvocation = methodCall;
                    ConvertForLoopOperation.this.fOldCollectionTypeBinding = typeBinding;
                    ConvertForLoopOperation.this.fOldCollectionBinding = (IBinding)methodCall.resolveMethodBinding();
                    ConvertForLoopOperation.this.fCollectionName = ASTNodeFactory.newName(ConvertForLoopOperation.this.fAst, methodCall.getName().getFullyQualifiedName());
                }
                return false;
            }

            public boolean visit(FieldAccess field) {
                if (this.initializeBindings((Name)field.getName())) {
                    ConvertForLoopOperation.this.fFieldAccess = field;
                }
                return true;
            }

            private boolean initializeBindings(Name name) {
                ITypeBinding typeBinding = name.resolveTypeBinding();
                if (typeBinding != null && typeBinding.isArray()) {
                    ConvertForLoopOperation.this.fOldCollectionTypeBinding = typeBinding;
                    if (ConvertForLoopOperation.this.fOldCollectionBinding == null) {
                        ConvertForLoopOperation.this.fOldCollectionBinding = name.resolveBinding();
                        ConvertForLoopOperation.this.fCollectionName = ASTNodeFactory.newName(ConvertForLoopOperation.this.fAst, name.getFullyQualifiedName());
                        return true;
                    }
                    if (name.resolveBinding() != ConvertForLoopOperation.this.fOldCollectionBinding) {
                        foundMoreThenOneArray[0] = true;
                    }
                    return true;
                }
                return false;
            }
        });
        if (foundMoreThenOneArray[0]) {
            this.fOldCollectionBinding = null;
            this.fCollectionName = null;
        }
    }

    private AST getAst() {
        return this.fAst;
    }

    private IBinding getIndexBinding() {
        if (this.fIndexBinding != null) {
            return this.fIndexBinding;
        }
        return this.inferIndexBinding();
    }

    public ITrackedNodePosition rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups, List positionGroups) throws CoreException {
        TextEditGroup group = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description);
        textEditGroups.add(group);
        this.clearPositionGroups();
        ITrackedNodePosition endPosition = this.doConvert(cuRewrite.getASTRewrite(), cuRewrite.getImportRewrite(), group);
        positionGroups.addAll(this.getAllPositionGroups());
        return endPosition;
    }

    private class LocalOccurencesFinder
    extends ASTVisitor {
        private List fOccurences;
        private ASTNode fScope;
        private IBinding fTempBinding;
        private ITypeBinding fTempTypeBinding;

        public LocalOccurencesFinder(Name collectionName, IBinding oldCollectionBinding, ITypeBinding oldCollectionTypeBinding, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = oldCollectionBinding;
            this.fTempTypeBinding = oldCollectionTypeBinding;
        }

        public LocalOccurencesFinder(Name name, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = name.resolveBinding();
        }

        public LocalOccurencesFinder(IBinding binding, ASTNode scope) {
            this.fScope = scope;
            this.fOccurences = new ArrayList();
            this.fTempBinding = binding;
        }

        public void perform() {
            this.fScope.accept((ASTVisitor)this);
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof VariableDeclaration && ((VariableDeclaration)node.getParent()).getName() == node) {
                return true;
            }
            if (this.fTempBinding != null && Bindings.equals(this.fTempBinding, node.resolveBinding())) {
                this.fOccurences.add(node);
            }
            return true;
        }

        public boolean visit(MethodInvocation methodInvocation) {
            ArrayAccess arrayAccess = (ArrayAccess)ASTNodes.getParent((ASTNode)methodInvocation, ArrayAccess.class);
            if (arrayAccess != null && this.fTempTypeBinding != null && Bindings.equals(this.fTempBinding, (IBinding)methodInvocation.resolveMethodBinding())) {
                this.fOccurences.add(arrayAccess);
                return false;
            }
            return true;
        }

        public List getOccurences() {
            return this.fOccurences;
        }
    }
}

