/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.tables;

import org.eclipse.wst.rdb.internal.models.sql.expressions.ValueExpression;
import org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier;
import org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType;
import org.eclipse.wst.rdb.internal.models.sql.schema.TypedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Column</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 4.13 Columns, fields, and attributes
 * 
 * The terms column, field, and attribute refer to structural components of tables, row types, and structured types, respectively, in analogous fashion. As the structure of a table consists of one or more columns, so does the structure of a row type consist of one or more fields and that of a structured type one or more attributes. Every structural element, whether a column, a field, or an attribute, is primarily a name paired with a declared type.
 * 
 * The elements of a structure are ordered. Elements in different positions in the same structure can have the same declared type but not the same name. Although the elements of a structure are distinguished from each other by name, in some circumstances the compatibility of two structures (for the purpose at hand) is determined solely by considering the declared types of each pair of elements at the same ordinal position.
 * 
 * A table (see Subclause 4.14, "Tables") is defined on one or more columns and consists of zero or more rows. A column has a name and a declared type. Each row in a table has exactly one value for each column. Each value in a row is a value in the declared type of the column.
 * NOTE 21: The declared type includes the null value and values in proper subtypes of the declared type. Every column has a nullability characteristic that indicates whether the value from that column can be the null value. The possible values of nullability characteristic are known not nullable and possibly nullable.
 * 
 * A column C is described by a column descriptor. A column descriptor includes:
 *  - The name of the column.
 *  - Whether the name of the column is an implementation-dependent name.
 *  - If the column is based on a domain, then the name of that domain; otherwise, the data type descriptor of the declared type of C.
 *  - The value of <default option> , if any, of C.
 *  - The nullability characteristic of C.
 *  - The ordinal position of C within the table that contains it.
 *  - An indication of whether C is a self-referencing column of a base table or not.
 *  - If the declared type of C is a reference type, then an indication of whether references are to be checked, and the <reference scope check action> , if specified or implied.
 *  - An indication of whether C is an identity column or not.
 *  - If C is an identity column, then an indication of whether values are always generated or generated by default.
 *  - If C is an identity column, then the start value of C.
 *  - If C is an identity column, then the descriptor of the internal sequence generator for C.
 * NOTE 22 - Identity columns and the meaning of "start value" are described in Subclause 4.14.4, "Identity columns".
 * 
 *  - If C is a generated column, then the generation expression of C.
 * NOTE 23 - Generated columns and the meaning of "generation expression" are described in Subclause 4.14.5, "Base columns and generated columns".
 * 
 * An attribute A is described by an attribute descriptor. An attribute descriptor includes:
 *  - The name of the attribute.
 *  - The data type descriptor of the declared type of A.
 *  - The ordinal position of A within the structured type that contains it.
 *  - The value of the implicit or explicit <attribute default> of A.
 *  - If the data type of the attribute is a reference type, then an indication of whether reference values shall be checked, and the <reference scope check action> , if specified or implied.
 *  - The name of the structured type defined by the <user-defined type definition> that defines A.
 * 
 * A field F is described by a field descriptor. A field descriptor includes:
 *  - The name of the field.
 *  - The data type descriptor of the declared type of F.
 *  - The ordinal position of F within the row type that simply contains it.
 *  - If the data type of the field is a reference type, then an indication of whether reference values shall be checked, and the <reference scope check action> , if specified or implied.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getTable <em>Table</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getIdentitySpecifier <em>Identity Specifier</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getGenerateExpression <em>Generate Expression</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isImplementationDependent <em>Implementation Dependent</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isNullable <em>Nullable</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getDefaultValue <em>Default Value</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getScopeCheck <em>Scope Check</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isScopeChecked <em>Scope Checked</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn()
 * @model 
 * @generated
 */
public interface Column extends TypedElement{
	/**
	 * Returns the value of the '<em><b>Table</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Table#getColumns <em>Columns</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Table</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Table</em>' container reference.
	 * @see #setTable(Table)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_Table()
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.Table#getColumns
	 * @model opposite="columns" required="true"
	 * @generated
	 */
	Table getTable();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getTable <em>Table</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Table</em>' container reference.
	 * @see #getTable()
	 * @generated
	 */
	void setTable(Table value);

	/**
	 * Returns the value of the '<em><b>Identity Specifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identity Specifier</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identity Specifier</em>' containment reference.
	 * @see #setIdentitySpecifier(IdentitySpecifier)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_IdentitySpecifier()
	 * @model containment="true"
	 * @generated
	 */
	IdentitySpecifier getIdentitySpecifier();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getIdentitySpecifier <em>Identity Specifier</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identity Specifier</em>' containment reference.
	 * @see #getIdentitySpecifier()
	 * @generated
	 */
	void setIdentitySpecifier(IdentitySpecifier value);

	/**
	 * Returns the value of the '<em><b>Generate Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Generate Expression</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Generate Expression</em>' containment reference.
	 * @see #setGenerateExpression(ValueExpression)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_GenerateExpression()
	 * @model containment="true"
	 * @generated
	 */
	ValueExpression getGenerateExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getGenerateExpression <em>Generate Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Generate Expression</em>' containment reference.
	 * @see #getGenerateExpression()
	 * @generated
	 */
	void setGenerateExpression(ValueExpression value);

	/**
	 * Returns the value of the '<em><b>Implementation Dependent</b></em>' attribute.
	 * The default value is <code>"False"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Implementation Dependent</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Implementation Dependent</em>' attribute.
	 * @see #setImplementationDependent(boolean)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_ImplementationDependent()
	 * @model default="False"
	 * @generated
	 */
	boolean isImplementationDependent();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isImplementationDependent <em>Implementation Dependent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Implementation Dependent</em>' attribute.
	 * @see #isImplementationDependent()
	 * @generated
	 */
	void setImplementationDependent(boolean value);

	/**
	 * Returns the value of the '<em><b>Nullable</b></em>' attribute.
	 * The default value is <code>"True"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Nullable</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Nullable</em>' attribute.
	 * @see #setNullable(boolean)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_Nullable()
	 * @model default="True"
	 * @generated
	 */
	boolean isNullable();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isNullable <em>Nullable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Nullable</em>' attribute.
	 * @see #isNullable()
	 * @generated
	 */
	void setNullable(boolean value);

	/**
	 * Returns the value of the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Value</em>' attribute.
	 * @see #setDefaultValue(String)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_DefaultValue()
	 * @model 
	 * @generated
	 */
	String getDefaultValue();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getDefaultValue <em>Default Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Value</em>' attribute.
	 * @see #getDefaultValue()
	 * @generated
	 */
	void setDefaultValue(String value);

	/**
	 * Returns the value of the '<em><b>Scope Check</b></em>' attribute.
	 * The default value is <code>"NO_ACTION"</code>.
	 * The literals are from the enumeration {@link org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Scope Check</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scope Check</em>' attribute.
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType
	 * @see #setScopeCheck(ReferentialActionType)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_ScopeCheck()
	 * @model default="NO_ACTION"
	 * @generated
	 */
	ReferentialActionType getScopeCheck();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#getScopeCheck <em>Scope Check</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scope Check</em>' attribute.
	 * @see org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType
	 * @see #getScopeCheck()
	 * @generated
	 */
	void setScopeCheck(ReferentialActionType value);

	/**
	 * Returns the value of the '<em><b>Scope Checked</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Scope Checked</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scope Checked</em>' attribute.
	 * @see #setScopeChecked(boolean)
	 * @see org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage#getColumn_ScopeChecked()
	 * @model 
	 * @generated
	 */
	boolean isScopeChecked();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.tables.Column#isScopeChecked <em>Scope Checked</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scope Checked</em>' attribute.
	 * @see #isScopeChecked()
	 * @generated
	 */
	void setScopeChecked(boolean value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model 
	 * @generated
	 */
	boolean isPartOfForeignKey();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model 
	 * @generated
	 */
	boolean isPartOfUniqueConstraint();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model 
	 * @generated
	 */
	boolean isPartOfPrimaryKey();

} // Column
