/*******************************************************************************
* Copyright (c) 2000, 2005 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/

package org.eclipse.wst.rdb.internal.outputview;

import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TabFolder;

/**
 * This interface defines the method that an extension must implement to add
 * a TabItem to the xml view
 */
public interface IXMLTab
{
	/**
     * Initializes interface with the xml text.
     * <p>
     * This method will be called first by the extension-point
     * @param xmlText the XML text to be used to generate the tab item
     */
    public void init(String xmlText);
    
    /**
     * Parses the xml text
     * @return the object resulted from the parse (eg Document)
     */
    public Object parse();
    
    /**
     * Implementation must provide the TabItem which will be added to the TabFolder
     * of the dialog showing XML data.
     * @param parent the parent TabFolder
     * @return one TabItem which will be added to the parent TabFolder
     */
    public TabItem getXMLTab(TabFolder parent);
}