/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsd.ui.internal.refactor.IReferenceUpdating;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;

public class RenameInputWizardPage
extends UserInputWizardPage {
    private String fInitialValue;
    private Text fTextField;
    private Button fUpdateReferences;
    static /* synthetic */ Class class$0;

    public RenameInputWizardPage(String description, boolean isLastUserPage) {
        this(description, isLastUserPage, "");
    }

    public RenameInputWizardPage(String description, boolean isLastUserPage, String initialValue) {
        super("RenameInputWizardPage");
        Assert.isNotNull((Object)initialValue);
        this.setDescription(description);
        this.fInitialValue = initialValue;
    }

    protected boolean isInitialInputValid() {
        return false;
    }

    protected boolean isEmptyInputValid() {
        return false;
    }

    protected String getText() {
        if (this.fTextField == null) {
            return null;
        }
        return this.fTextField.getText();
    }

    protected void setText(String text) {
        if (this.fTextField == null) {
            return;
        }
        this.fTextField.setText(text);
    }

    protected RefactoringStatus validateTextField(String text) {
        return null;
    }

    protected Text createTextInputField(Composite parent) {
        return this.createTextInputField(parent, 2048);
    }

    protected Text createTextInputField(Composite parent, int style) {
        this.fTextField = new Text(parent, style);
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameInputWizardPage.this.textModified(RenameInputWizardPage.this.getText());
            }
        });
        this.fTextField.setText(this.fInitialValue);
        return this.fTextField;
    }

    protected void textModified(String text) {
        if (!this.isEmptyInputValid() && text.equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        if (!this.isInitialInputValid() && text.equals(this.fInitialValue)) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            this.restoreMessage();
            return;
        }
        this.setPageComplete(this.validateTextField(text));
        this.getRefactoringWizard().setForcePreviewReview(false);
        this.getContainer().updateButtons();
    }

    protected void restoreMessage() {
        this.setMessage(null);
    }

    public void dispose() {
        this.fTextField = null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.textModified(this.getText());
        }
        super.setVisible(visible);
        if (visible && this.fTextField != null) {
            this.fTextField.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        this.addOptionalUpdateReferencesCheckbox(superComposite);
        gd = new GridData(768);
        text.setLayoutData((Object)gd);
        this.getRefactoringWizard().setForcePreviewReview(false);
        Dialog.applyDialogFont((Control)superComposite);
    }

    private static Button createCheckbox(Composite parent, String title, boolean value) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        return checkBox;
    }

    private void addOptionalUpdateReferencesCheckbox(Composite result) {
        IReferenceUpdating ref;
        Refactoring refactoring = this.getRefactoring();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.refactor.IReferenceUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = (IReferenceUpdating)refactoring.getAdapter((Class)clazz)) == null || !ref.canEnableUpdateReferences()) {
            return;
        }
        String title = RefactoringMessages.getString("RenameInputWizardPage.update_references");
        boolean defaultValue = true;
        this.fUpdateReferences = RenameInputWizardPage.createCheckbox(result, title, defaultValue);
        ref.setUpdateReferences(this.fUpdateReferences.getSelection());
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(RenameInputWizardPage.this.fUpdateReferences.getSelection());
            }
        });
        this.fUpdateReferences.setEnabled(true);
    }

    protected String getLabelText() {
        return RefactoringMessages.getString("RenameInputWizardPage.new_name");
    }
}

