/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDComplexTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDSimpleTypeDefinitionCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateTypeReferenceAndManageDirectivesCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateTypeReferenceCommand;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewTypeDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDTypeReferenceEditManager
implements ComponentReferenceEditManager {
    protected IFile currentFile;
    protected XSDSchema[] schemas;
    private static ComponentSpecification[] result;

    public XSDTypeReferenceEditManager(IFile currentFile, XSDSchema[] schemas) {
        this.currentFile = currentFile;
        this.schemas = schemas;
    }

    public void addToHistory(ComponentSpecification component) {
    }

    public IComponentDialog getBrowseDialog() {
        XSDSearchListDialogDelegate dialogDelegate = new XSDSearchListDialogDelegate(XSDSearchListDialogDelegate.TYPE_META_NAME, this.currentFile, this.schemas);
        return dialogDelegate;
    }

    public IComponentDescriptionProvider getComponentDescriptionProvider() {
        return null;
    }

    public ComponentSpecification[] getHistory() {
        ArrayList list = new ArrayList();
        ComponentSpecification[] result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public IComponentDialog getNewDialog() {
        if (this.schemas.length > 0) {
            return new NewTypeDialog(this.schemas[0]);
        }
        return new NewTypeDialog();
    }

    public ComponentSpecification[] getQuickPicks() {
        if (result != null) {
            return result;
        }
        ArrayList<ComponentSpecification> list = new ArrayList<ComponentSpecification>();
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "boolean", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "date", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "dateTime", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "double", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "float", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "hexBinary", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "int", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "string", null));
        list.add(new ComponentSpecification("http://www.w3.org/2001/XMLSchema", "time", null));
        result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        XSDConcreteComponent concreteComponent = null;
        if (referencingObject instanceof Adapter) {
            Adapter adpater = (Adapter)referencingObject;
            if (adpater.getTarget() instanceof XSDConcreteComponent) {
                concreteComponent = (XSDConcreteComponent)adpater.getTarget();
            }
        } else if (referencingObject instanceof XSDConcreteComponent) {
            concreteComponent = (XSDConcreteComponent)referencingObject;
        }
        if (concreteComponent != null) {
            if (component.isNew()) {
                Command command;
                XSDComplexTypeDefinition td = null;
                if (component.getMetaName() == IXSDSearchConstants.COMPLEX_TYPE_META_NAME) {
                    command = new AddXSDComplexTypeDefinitionCommand(Messages._UI_ACTION_ADD_COMPLEX_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    command.setNameToAdd(component.getName());
                    command.execute();
                    td = command.getCreatedComplexType();
                } else {
                    command = new AddXSDSimpleTypeDefinitionCommand(Messages._UI_ACTION_ADD_SIMPLE_TYPE, (XSDConcreteComponent)concreteComponent.getSchema());
                    command.setNameToAdd(component.getName());
                    command.execute();
                    td = command.getCreatedSimpleType();
                }
                if (td != null) {
                    command = new UpdateTypeReferenceCommand(concreteComponent, (XSDTypeDefinition)td);
                    command.execute();
                }
            } else {
                UpdateTypeReferenceAndManageDirectivesCommand command = new UpdateTypeReferenceAndManageDirectivesCommand(concreteComponent, component.getName(), component.getQualifier(), component.getFile());
                command.execute();
            }
        }
    }
}

