/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.MultiplicitySection;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDWildcard;

public class XSDAnyElementContentsSection
extends MultiplicitySection {
    CCombo namespaceCombo;
    CCombo processContentsCombo;
    private String[] namespaceComboValues = new String[]{"", "##any", "##other", "##targetNamespace", "##local"};

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridData data = new GridData();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(this.composite, "namespace");
        namespaceLabel.setLayoutData((Object)data);
        this.namespaceCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.namespaceCombo.setLayoutData((Object)data);
        this.namespaceCombo.setItems(this.namespaceComboValues);
        this.namespaceCombo.addSelectionListener((SelectionListener)this);
        CLabel processContentsLabel = this.getWidgetFactory().createCLabel(this.composite, "processContents");
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        processContentsLabel.setLayoutData((Object)data);
        this.processContentsCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.processContentsCombo.setLayoutData((Object)data);
        Iterator list = XSDProcessContents.VALUES.iterator();
        this.processContentsCombo.add("");
        while (list.hasNext()) {
            this.processContentsCombo.add(((XSDProcessContents)list.next()).getName());
        }
        this.processContentsCombo.addSelectionListener((SelectionListener)this);
        this.getWidgetFactory().createCLabel(this.composite, Messages.UI_LABEL_MINOCCURS);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.minCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.minCombo.setLayoutData((Object)data);
        this.minCombo.add("0");
        this.minCombo.add("1");
        this.applyAllListeners((Control)this.minCombo);
        this.minCombo.addSelectionListener((SelectionListener)this);
        this.getWidgetFactory().createCLabel(this.composite, Messages.UI_LABEL_MAXOCCURS);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.maxCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        this.maxCombo.setLayoutData((Object)data);
        this.maxCombo.add("0");
        this.maxCombo.add("1");
        this.maxCombo.add("unbounded");
        this.applyAllListeners((Control)this.maxCombo);
        this.maxCombo.addSelectionListener((SelectionListener)this);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        this.namespaceCombo.setText("");
        this.processContentsCombo.setText("");
        if (this.input != null && this.input instanceof XSDWildcard) {
            XSDWildcard wildcard = (XSDWildcard)this.input;
            if (wildcard.isSetLexicalNamespaceConstraint()) {
                this.namespaceCombo.setText(wildcard.getStringLexicalNamespaceConstraint());
            } else {
                this.namespaceCombo.setText("");
            }
            if (wildcard.isSetProcessContents()) {
                XSDProcessContents pc = wildcard.getProcessContents();
                this.processContentsCombo.setText(pc.getName());
            }
            if (wildcard.eContainer() instanceof XSDParticle) {
                this.minCombo.setEnabled(!this.isReadOnly);
                this.maxCombo.setEnabled(!this.isReadOnly);
            } else {
                this.minCombo.setEnabled(false);
                this.maxCombo.setEnabled(false);
            }
        }
        this.refreshMinMax();
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doWidgetSelected(SelectionEvent e) {
        XSDConcreteComponent concreteComponent = (XSDConcreteComponent)this.input;
        if (concreteComponent instanceof XSDWildcard) {
            XSDWildcard wildcard = (XSDWildcard)concreteComponent;
            if (e.widget == this.namespaceCombo) {
                String newValue = this.namespaceCombo.getText();
                boolean removeAttribute = false;
                if (newValue.length() == 0) {
                    removeAttribute = true;
                }
                if (removeAttribute) {
                    wildcard.unsetLexicalNamespaceConstraint();
                } else {
                    wildcard.setStringLexicalNamespaceConstraint(newValue);
                }
            } else if (e.widget == this.processContentsCombo) {
                String newValue = this.processContentsCombo.getText();
                boolean removeAttribute = false;
                if (newValue.length() == 0) {
                    removeAttribute = true;
                }
                if (removeAttribute) {
                    wildcard.unsetProcessContents();
                } else {
                    wildcard.setProcessContents(XSDProcessContents.get((String)this.processContentsCombo.getItem(this.processContentsCombo.getSelectionIndex())));
                }
            }
        }
        super.doWidgetSelected(e);
    }

    public void dispose() {
        if (this.minCombo != null && !this.minCombo.isDisposed()) {
            this.minCombo.removeSelectionListener((SelectionListener)this);
        }
        if (this.maxCombo != null && !this.maxCombo.isDisposed()) {
            this.maxCombo.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }
}

