/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.directedit;

import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;

public class ADTComboBoxCellEditor
extends CellEditor {
    private String[] items;
    int selection;
    CCombo comboBox;
    private boolean continueApply;
    private Object selectedValue;
    private ComponentReferenceEditManager componentReferenceEditManager;
    private static final int defaultStyle = 0;

    public ADTComboBoxCellEditor(Composite parent, String[] items, ComponentReferenceEditManager editManager) {
        super(parent, 0);
        this.setItems(items);
        this.componentReferenceEditManager = editManager;
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle() | 8);
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ADTComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ADTComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                Object newValue = null;
                ADTComboBoxCellEditor.this.continueApply = true;
                ADTComboBoxCellEditor.this.selection = ADTComboBoxCellEditor.this.comboBox.getSelectionIndex();
                String stringSelection = ADTComboBoxCellEditor.this.items[ADTComboBoxCellEditor.this.selection];
                if (stringSelection.equals(Messages._UI_ACTION_BROWSE)) {
                    newValue = ADTComboBoxCellEditor.this.invokeDialog(ADTComboBoxCellEditor.this.componentReferenceEditManager.getBrowseDialog());
                } else if (stringSelection.equals(Messages._UI_ACTION_NEW)) {
                    newValue = ADTComboBoxCellEditor.this.invokeDialog(ADTComboBoxCellEditor.this.componentReferenceEditManager.getNewDialog());
                }
                if (ADTComboBoxCellEditor.this.continueApply) {
                    if (newValue == null) {
                        int index = ADTComboBoxCellEditor.this.comboBox.getSelectionIndex();
                        if (index != -1) {
                            ADTComboBoxCellEditor.this.selectedValue = ADTComboBoxCellEditor.this.comboBox.getItem(index);
                        }
                    } else {
                        ADTComboBoxCellEditor.this.selectedValue = newValue;
                    }
                    ADTComboBoxCellEditor.this.applyEditorValueAndDeactivate();
                }
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ADTComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    private Object invokeDialog(IComponentDialog dialog) {
        ComponentSpecification newValue = null;
        if (dialog == null) {
            return null;
        }
        if (dialog.createAndOpen() == 0) {
            newValue = dialog.getSelectedComponent();
        } else {
            this.continueApply = false;
        }
        return newValue;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && value instanceof Integer ? 1 : 0) != 0);
        this.selection = (Integer)value;
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }
}

