/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.provider;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IContainerManagedEntityBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IEnterpriseBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IMessageDrivenBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.ISessionBean;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IAnnotationProvider;
import org.eclipse.jst.j2ee.ejb.annotation.internal.provider.IEJBGenerator;
import org.eclipse.jst.j2ee.ejb.annotations.internal.classgen.EjbBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.EmitterUtilities;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.EntityEjbEmitter;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.MessageDrivenEjbEmitter;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.SessionEjbEmitter;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletBuildUtility;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletExtensionUtil;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class XDocletAnnotationProvider
implements IAnnotationProvider,
IEJBGenerator {
    private static final String END_XDOCLET_DEFINITION = " * <!-- end-xdoclet-definition -->";

    public boolean isEjbAnnotationProvider() {
        return true;
    }

    public boolean isServletAnnotationProvider() {
        return true;
    }

    public boolean isWebServiceAnnotationProvider() {
        return false;
    }

    public boolean isValid() {
        XDocletPreferenceStore store = XDocletPreferenceStore.forProject(null);
        XDocletRuntime runtime = XDocletExtensionUtil.getRuntime(store.getProperty("XDOCLETVERSION"));
        runtime.setHome(store.getProperty("XDOCLETHOME"));
        return runtime.isValid();
    }

    public String getName() {
        return "XDocletAnnotionProvider";
    }

    public void generateSession(ISessionBean delegate, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IDataModel dataModel = delegate.getDataModel();
        String comment = "";
        String stub = "";
        String method = "";
        IConfigurationElement preferredAnnotation = EmitterUtilities.findEmitter((String)"XDoclet");
        try {
            SessionEjbEmitter ejbEmitter = new SessionEjbEmitter(preferredAnnotation);
            ejbEmitter.setMonitor(monitor);
            comment = ejbEmitter.emitTypeComment((IEnterpriseBean)delegate);
            comment = this.applyRuntimeAnnotations((IEnterpriseBean)delegate, comment);
            stub = ejbEmitter.emitTypeStub((IEnterpriseBean)delegate);
            method = ejbEmitter.emitInterfaceMethods((IEnterpriseBean)delegate);
            ejbEmitter.deleteProject();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee.ejb.annotation.model", 0, "Session EJB Emitters Failed", (Throwable)e));
        }
        EjbBuilder ejbBuilder = new EjbBuilder();
        ejbBuilder.setConfigurationElement(preferredAnnotation);
        ejbBuilder.setMonitor(monitor);
        ejbBuilder.setPackageFragmentRoot((IPackageFragmentRoot)dataModel.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT"));
        ejbBuilder.setEnterpriseBeanDelegate((IEnterpriseBean)delegate);
        ejbBuilder.setTypeName(dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        ejbBuilder.setPackageName(dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"));
        ejbBuilder.setTypeComment(comment);
        ejbBuilder.setTypeStub(stub);
        ejbBuilder.setMethodStub(method);
        ejbBuilder.setFields("");
        ejbBuilder.createType();
        IType bean = ejbBuilder.getCreatedType();
        IResource javaFile = bean.getCorrespondingResource();
        IProject project = (IProject)dataModel.getProperty("NewJavaClassDataModel.PROJECT");
        this.initializeBuilder(monitor, preferredAnnotation, javaFile, project);
        XDocletBuildUtility.runNecessaryBuilders(monitor, project);
    }

    public void generateCMP(IContainerManagedEntityBean delegate, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IDataModel dataModel = delegate.getDataModel();
        String comment = "";
        String stub = "";
        String method = "";
        String fields = "";
        IConfigurationElement preferredAnnotation = EmitterUtilities.findEmitter((String)"XDoclet");
        try {
            EntityEjbEmitter ejbEmitter = new EntityEjbEmitter(preferredAnnotation);
            ejbEmitter.setMonitor(monitor);
            comment = ejbEmitter.emitTypeComment((IEnterpriseBean)delegate);
            comment = this.applyRuntimeAnnotations((IEnterpriseBean)delegate, comment);
            stub = ejbEmitter.emitTypeStub((IEnterpriseBean)delegate);
            method = ejbEmitter.emitInterfaceMethods((IEnterpriseBean)delegate);
            fields = ejbEmitter.emitFields((IEnterpriseBean)delegate);
            ejbEmitter.deleteProject();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee.ejb.annotation.model", 0, "CMP EJB Emitters Failed", (Throwable)e));
        }
        EjbBuilder ejbBuilder = new EjbBuilder();
        ejbBuilder.setConfigurationElement(preferredAnnotation);
        ejbBuilder.setMonitor(monitor);
        ejbBuilder.setPackageFragmentRoot((IPackageFragmentRoot)dataModel.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT"));
        ejbBuilder.setEnterpriseBeanDelegate((IEnterpriseBean)delegate);
        ejbBuilder.setTypeName(dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        ejbBuilder.setPackageName(dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"));
        ejbBuilder.setTypeComment(comment);
        ejbBuilder.setTypeStub(stub);
        ejbBuilder.setMethodStub(method);
        ejbBuilder.setFields(fields);
        ejbBuilder.createType();
        IType bean = ejbBuilder.getCreatedType();
        IResource javaFile = bean.getCorrespondingResource();
        IProject project = (IProject)dataModel.getProperty("NewJavaClassDataModel.PROJECT");
        this.initializeBuilder(monitor, preferredAnnotation, javaFile, project);
        XDocletBuildUtility.runNecessaryBuilders(monitor, project);
    }

    private String applyRuntimeAnnotations(IEnterpriseBean delegate, String comment) {
        String commentRuntime = XDocletExtensionUtil.getRuntimeTypeAnnotations(delegate);
        int i = comment.indexOf(END_XDOCLET_DEFINITION);
        if (commentRuntime == null || i < 0) {
            return comment;
        }
        comment = String.valueOf(comment.substring(0, i)) + commentRuntime + comment.substring(i);
        return comment;
    }

    public void generateMessageDriven(IMessageDrivenBean delegate, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IDataModel dataModel = delegate.getDataModel();
        String comment = "";
        String stub = "";
        String method = "";
        String fields = "";
        IConfigurationElement emitterConfiguration = EmitterUtilities.findEmitter((String)"XDoclet");
        try {
            MessageDrivenEjbEmitter ejbEmitter = new MessageDrivenEjbEmitter(emitterConfiguration);
            ejbEmitter.setMonitor(monitor);
            fields = ejbEmitter.emitFields((IEnterpriseBean)delegate);
            comment = ejbEmitter.emitTypeComment((IEnterpriseBean)delegate);
            comment = this.applyRuntimeAnnotations((IEnterpriseBean)delegate, comment);
            stub = ejbEmitter.emitTypeStub((IEnterpriseBean)delegate);
            method = ejbEmitter.emitInterfaceMethods((IEnterpriseBean)delegate);
            ejbEmitter.deleteProject();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.j2ee.ejb.annotation.model", 0, "MessageDriven EJB Emitters Failed", (Throwable)e));
        }
        EjbBuilder ejbBuilder = new EjbBuilder();
        ejbBuilder.setConfigurationElement(emitterConfiguration);
        ejbBuilder.setMonitor(monitor);
        ejbBuilder.setPackageFragmentRoot((IPackageFragmentRoot)dataModel.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT"));
        ejbBuilder.setEnterpriseBeanDelegate((IEnterpriseBean)delegate);
        ejbBuilder.setTypeName(dataModel.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
        ejbBuilder.setPackageName(dataModel.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE"));
        ejbBuilder.setTypeComment(comment);
        ejbBuilder.setTypeStub(stub);
        ejbBuilder.setMethodStub(method);
        ejbBuilder.setFields(fields);
        ejbBuilder.createType();
        IType bean = ejbBuilder.getCreatedType();
        IResource javaFile = bean.getCorrespondingResource();
        IProject project = (IProject)dataModel.getProperty("NewJavaClassDataModel.PROJECT");
        this.initializeBuilder(monitor, emitterConfiguration, javaFile, project);
        XDocletBuildUtility.runNecessaryBuilders(monitor, project);
    }

    protected void initializeBuilder(IProgressMonitor monitor, IConfigurationElement emitterConfiguration, IResource javaFile, IProject project) throws CoreException {
        this.addXDocletFacet(project, monitor);
    }

    private void addXDocletFacet(IProject project, IProgressMonitor monitor) {
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            this.installXDocletFacets(project, monitor, "jst.web.xdoclet");
        } else if (J2EEProjectUtilities.isEJBProject((IProject)project)) {
            this.installXDocletFacets(project, monitor, "jst.ejb.xdoclet");
        }
    }

    private void installXDocletFacets(IProject project, IProgressMonitor monitor, String docletType) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Set facets = facetedProject.getProjectFacets();
            Set fixedFacets = facetedProject.getFixedProjectFacets();
            boolean shouldInstallFacet = true;
            Iterator iter = facets.iterator();
            while (iter.hasNext()) {
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                String facetID = facetVersion.getProjectFacet().getId();
                if (!docletType.equals(facetID)) continue;
                shouldInstallFacet = false;
            }
            if (!shouldInstallFacet) {
                return;
            }
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_ID", (Object)docletType);
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
            dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.2.3");
            IDataModel fdm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            fdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)fdm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            map.add(dm);
            fdm.getDefaultOperation().execute(monitor, null);
            facetedProject.setFixedProjectFacets(fixedFacets);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }
}

