/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;

public class StartServerCommand
extends AbstractDataModelOperation {
    private ILog log = EnvironmentService.getEclipseLog();
    private boolean doAsyncPublish_ = true;
    private String serverInstanceId;

    public StartServerCommand() {
    }

    public StartServerCommand(boolean doAsyncPublish) {
        this();
        this.doAsyncPublish_ = doAsyncPublish;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        IServer server = ServerCore.findServer((String)this.serverInstanceId);
        if (server == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_INSTANCE_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return status;
        }
        int serverState = server.getServerState();
        if (((Server)server).shouldPublish() && server.canPublish().getSeverity() == 0 && (status = this.publish(server, 1, monitor)).getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
            return status;
        }
        switch (serverState) {
            case 4: {
                if (server.canStart("run").getSeverity() != 0 || (status = this.start(server, monitor)).getSeverity() != 4) break;
                env.getStatusHandler().reportError(status);
                return status;
            }
            case 2: {
                boolean shouldRestart = ((Server)server).shouldRestart();
                if (!shouldRestart || server.canRestart("run").getSeverity() != 0 || (status = this.restart(server, monitor)).getSeverity() != 4) break;
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        return status;
    }

    private IStatus publish(final IServer server, final int kind, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        final IStatus[] istatus = new IStatus[1];
        monitor.subTask(ConsumptionMessages.PROGRESS_INFO_PUBLISHING_SERVER);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                istatus[0] = server.publish(kind, shellMonitor);
            }
        };
        try {
            if (this.doAsyncPublish_) {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            } else {
                runnable.run(monitor);
            }
        }
        catch (InvocationTargetException ite) {
            istatus[0] = new Status(4, "id", 0, ite.getMessage(), (Throwable)ite);
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            istatus[0] = new Status(4, "id", 0, ie.getMessage(), (Throwable)ie);
            ie.printStackTrace();
        }
        if (istatus[0].getSeverity() != 0) {
            status = istatus[0];
            return status;
        }
        this.log.log(1, 5051, (Object)this, "publishProject", (Object)("IServer=" + server + ", Publish command completed"));
        return status;
    }

    private IStatus restart(IServer server, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            monitor.subTask(ConsumptionMessages.PROGRESS_INFO_STARTING_SERVER);
            server.synchronousRestart("run", monitor);
            this.log.log(1, 5052, (Object)this, "execute", (Object)("IServer=" + server + ", Restart command completed"));
            return status;
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SERVER, (Throwable)e);
            return status;
        }
    }

    private IStatus start(IServer server, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            monitor.subTask(ConsumptionMessages.PROGRESS_INFO_STARTING_SERVER);
            server.synchronousStart("run", monitor);
            this.log.log(1, 5053, (Object)this, "execute", (Object)("IServer=" + server + ", Start command completed"));
            return status;
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_SERVER, (Throwable)e);
            return status;
        }
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

