/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddBindingCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddInterfaceCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLAdapterFactoryHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewComponentDialog;

public class W11NewComponentDialog
implements IComponentDialog {
    protected NewComponentDialog dialog;
    protected QualifiedName qualifiedName;
    protected IFile iFile;
    protected W11Description description;
    protected IASDObject newObject;
    static /* synthetic */ Class class$0;

    public W11NewComponentDialog(QualifiedName qualifiedName, IFile iFile, W11Description description) {
        this.qualifiedName = qualifiedName;
        this.iFile = iFile;
        this.description = description;
        Shell shell = Display.getCurrent().getActiveShell();
        if (qualifiedName == IWSDLSearchConstants.BINDING_META_NAME) {
            String dialogTitle = Messages.getString("_UI_LABEL_NEW_BINDING");
            String baseName = NameUtil.buildUniqueBindingName(this.getDefinition(), "NewBinding");
            List usedNames = NameUtil.getUsedBindingNames(this.getDefinition());
            this.dialog = new NewComponentDialog(shell, dialogTitle, baseName, usedNames);
        } else if (qualifiedName == IWSDLSearchConstants.PORT_TYPE_META_NAME) {
            String dialogTitle = Messages.getString("_UI_LABEL_NEW_PORTTYPE");
            String baseName = NameUtil.buildUniquePortTypeName(this.getDefinition(), "NewPortType");
            List usedNames = NameUtil.getUsedPortTypeNames(this.getDefinition());
            this.dialog = new NewComponentDialog(shell, dialogTitle, baseName, usedNames);
        } else if (qualifiedName == IWSDLSearchConstants.MESSAGE_META_NAME) {
            String dialogTitle = Messages.getString("_UI_LABEL_NEW_MESSAGE");
            String baseName = NameUtil.buildUniqueMessageName(this.getDefinition(), "NewMessage");
            List usedNames = NameUtil.getUsedMessageNames(this.getDefinition());
            this.dialog = new NewComponentDialog(shell, dialogTitle, baseName, usedNames);
        }
    }

    private Definition getDefinition() {
        return (Definition)this.description.getTarget();
    }

    public void setInitialSelection(ComponentSpecification componentSpecification) {
    }

    public ComponentSpecification getSelectedComponent() {
        String qualifier = this.getDefinition().getPrefix(this.getDefinition().getTargetNamespace());
        String name = this.dialog.getName();
        ComponentSpecification spec = new ComponentSpecification(qualifier, name, this.iFile);
        spec.setObject((Object)this.newObject);
        return spec;
    }

    public int createAndOpen() {
        int rValue = this.dialog.createAndOpen();
        if (rValue == 0) {
            if (this.qualifiedName == IWSDLSearchConstants.BINDING_META_NAME) {
                W11AddBindingCommand command = (W11AddBindingCommand)this.description.getAddBindingCommand();
                command.setNewBindingName(this.dialog.getName());
                this.execute(command);
                Binding newWSDLObject = command.getNewBinding();
                this.newObject = (IASDObject)WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)newWSDLObject);
            } else if (this.qualifiedName == IWSDLSearchConstants.PORT_TYPE_META_NAME) {
                W11AddInterfaceCommand command = (W11AddInterfaceCommand)this.description.getAddInterfaceCommand();
                command.setNewPortTypeName(this.dialog.getName());
                this.execute(command);
                PortType newWSDLObject = command.getNewPortType();
                this.newObject = (IASDObject)WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)newWSDLObject);
            } else if (this.qualifiedName == IWSDLSearchConstants.MESSAGE_META_NAME) {
                W11AddMessageCommand command = (W11AddMessageCommand)this.description.getAddMessageCommand();
                command.setNewMessageName(this.dialog.getName());
                this.execute(command);
                Message newWSDLObject = command.getNewMessage();
                this.newObject = (IASDObject)WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)newWSDLObject);
            }
        }
        return rValue;
    }

    private void execute(Command command) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = page.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (iEditorPart.getAdapter((Class)clazz) != null) {
            IEditorPart iEditorPart2 = page.getActiveEditor();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CommandStack stack = (CommandStack)iEditorPart2.getAdapter((Class)clazz2);
            stack.execute(command);
        } else {
            command.execute();
        }
    }
}

