/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class PublishInfo {
    protected static PublishInfo instance;
    protected static final String PUBLISH_DIR = "publish";
    protected Map serverIdToPath = new HashMap();
    protected Map serverIdToPublishInfo = new HashMap();

    private PublishInfo() {
        this.load();
    }

    public static PublishInfo getInstance() {
        if (instance == null) {
            instance = new PublishInfo();
        }
        return instance;
    }

    public ServerPublishInfo getServerPublishInfo(IServer server) {
        String serverId = server.getId();
        if (this.serverIdToPath.containsKey(serverId)) {
            if (!this.serverIdToPublishInfo.containsKey(serverId)) {
                String partialPath = (String)this.serverIdToPath.get(serverId);
                IPath path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR).append(partialPath);
                ServerPublishInfo spi = new ServerPublishInfo(path);
                this.serverIdToPublishInfo.put(serverId, spi);
                return spi;
            }
            return (ServerPublishInfo)this.serverIdToPublishInfo.get(serverId);
        }
        IPath path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.mkdir();
        }
        file = null;
        int i = 0;
        String partialPath = null;
        while (file == null || file.exists()) {
            partialPath = PUBLISH_DIR + i + ".xml";
            path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR).append(partialPath);
            if (this.serverIdToPath.get(partialPath) == null) {
                file = new File(path.toOSString());
            }
            ++i;
        }
        ServerPublishInfo spi = new ServerPublishInfo(path);
        this.serverIdToPath.put(serverId, partialPath);
        this.serverIdToPublishInfo.put(serverId, spi);
        this.save();
        return spi;
    }

    protected void load() {
        Trace.trace(Trace.FINEST, "Loading publish info");
        String filename = ServerPlugin.getInstance().getStateLocation().append("publish.xml").toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] serverChild = memento.getChildren("server");
            int size = serverChild.length;
            this.serverIdToPath = new HashMap(size + 2);
            int i = 0;
            while (i < size) {
                String id = serverChild[i].getString("id");
                String partialPath = serverChild[i].getString("path");
                this.serverIdToPath.put(id, partialPath);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load global publish info: " + e.getMessage());
        }
    }

    protected void save() {
        String filename = ServerPlugin.getInstance().getStateLocation().append("publish.xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("publish-info");
            Iterator iterator = this.serverIdToPath.keySet().iterator();
            while (iterator.hasNext()) {
                String serverId = (String)iterator.next();
                String partialPath = (String)this.serverIdToPath.get(serverId);
                IMemento server = memento.createChild("server");
                server.putString("id", serverId);
                server.putString("path", partialPath);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save global publish info", e);
        }
    }
}

