/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeLabelProvider;

public class RuntimeTreeLabelProvider
extends AbstractTreeLabelProvider
implements ITableLabelProvider {
    protected Image getImageImpl(Object element) {
        IRuntime runtime = (IRuntime)element;
        if (runtime.getRuntimeType() != null) {
            return ImageResource.getImage(runtime.getRuntimeType().getId());
        }
        return null;
    }

    protected String getTextImpl(Object element) {
        IRuntime runtime = (IRuntime)element;
        return this.notNull(runtime.getName());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof AbstractTreeContentProvider.TreeElement) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                return sharedImages.getImage("IMG_OBJ_FOLDER");
            }
            return this.getImageImpl(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AbstractTreeContentProvider.TreeElement) {
            if (columnIndex == 0) {
                return ((AbstractTreeContentProvider.TreeElement)element).text;
            }
            return "";
        }
        IRuntime runtime = (IRuntime)element;
        if (columnIndex == 0) {
            return runtime.getName();
        }
        if (columnIndex == 1) {
            if (runtime.getRuntimeType() != null) {
                return this.notNull(runtime.getRuntimeType().getName());
            }
            return "";
        }
        return "X";
    }
}

