/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;

public class ServersViewDropAdapter
extends ViewerDropAdapter {
    protected ServersViewDropAdapter(Viewer viewer) {
        super(viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public boolean performDrop(Object data) {
        Object target = this.getCurrentTarget();
        IServer server = null;
        if (target instanceof IServer) {
            server = (IServer)target;
        }
        if (server == null) {
            return false;
        }
        final IServer finalServer = server;
        RunOnServerActionDelegate ros = new RunOnServerActionDelegate(){

            public IServer getServer(IModule module, String launchMode, IProgressMonitor monitor) {
                return finalServer;
            }
        };
        Action action = new Action(){};
        if (data instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)data;
            data = sel.getFirstElement();
        }
        ros.selectionChanged((IAction)action, (ISelection)new StructuredSelection(data));
        ros.run((IAction)action);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target == null) {
            return false;
        }
        System.out.println("Target: " + target + " " + operation + " " + transferType);
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        if (ResourceTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return LocalSelectionTransfer.getInstance().isSupportedType(transferType);
    }
}

