/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Trace;

public class ServerLabelProvider
implements ILabelProvider {
    protected Image getModuleImage(String typeId) {
        if (typeId == null) {
            return null;
        }
        Image image = ImageResource.getImage(typeId);
        int ind = typeId.indexOf(".");
        while (image == null && ind >= 0) {
            typeId = typeId.substring(0, ind);
            image = ImageResource.getImage(typeId);
        }
        return image;
    }

    protected ImageDescriptor getModuleImageDescriptor(String typeId) {
        if (typeId == null) {
            return null;
        }
        ImageDescriptor image = ImageResource.getImageDescriptor(typeId);
        int ind = typeId.indexOf(".");
        while (image == null && ind >= 0) {
            typeId = typeId.substring(0, ind);
            image = ImageResource.getImageDescriptor(typeId);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        try {
            if (element instanceof IRuntimeType) {
                IRuntimeType runtimeType = (IRuntimeType)element;
                return ImageResource.getImageDescriptor(runtimeType.getId());
            }
            if (element instanceof IRuntime) {
                IRuntime runtime = (IRuntime)element;
                return ImageResource.getImageDescriptor(runtime.getRuntimeType().getId());
            }
            if (element instanceof IServerType) {
                IServerType serverType = (IServerType)element;
                return ImageResource.getImageDescriptor(serverType.getId());
            }
            if (element instanceof IServer) {
                IServer server = (IServer)element;
                return ImageResource.getImageDescriptor(server.getServerType().getId());
            }
            if (element instanceof IModule) {
                IModule module = (IModule)element;
                IModuleType mt = module.getModuleType();
                return this.getModuleImageDescriptor(mt.getId());
            }
            if (element instanceof IModule[]) {
                IModule[] modules = (IModule[])element;
                IModule module = modules[modules.length - 1];
                IModuleType mt = module.getModuleType();
                return this.getModuleImageDescriptor(mt.getId());
            }
            if (element instanceof IWorkbenchAdapter) {
                return ((IWorkbenchAdapter)element).getImageDescriptor(null);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get image descriptor", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image getImage(Object element) {
        try {
            if (element instanceof IRuntimeType) {
                IRuntimeType runtimeType = (IRuntimeType)element;
                return ImageResource.getImage(runtimeType.getId());
            }
            if (element instanceof IRuntime) {
                IRuntime runtime = (IRuntime)element;
                return ImageResource.getImage(runtime.getRuntimeType().getId());
            }
            if (element instanceof IServerType) {
                IServerType serverType = (IServerType)element;
                return ImageResource.getImage(serverType.getId());
            }
            if (element instanceof IServer) {
                IServer server = (IServer)element;
                if (server.getServerType() != null) return ImageResource.getImage(server.getServerType().getId());
                return null;
            }
            if (element instanceof IModule) {
                IModule module = (IModule)element;
                IModuleType mt = module.getModuleType();
                if (mt != null) return this.getModuleImage(mt.getId());
                return null;
            }
            if (!(element instanceof IModule[])) return null;
            IModule[] modules = (IModule[])element;
            IModule module = modules[modules.length - 1];
            IModuleType mt = module.getModuleType();
            if (mt != null) return this.getModuleImage(mt.getId());
            return null;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get image descriptor", e);
        }
        return null;
    }

    protected String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof IRuntime) {
            return this.getString(((IRuntime)element).getName());
        }
        if (element instanceof IServer) {
            return this.getString(((IServer)element).getName());
        }
        if (element instanceof IRuntimeType) {
            return ((IRuntimeType)element).getName();
        }
        if (element instanceof IServerType) {
            return ((IServerType)element).getName();
        }
        if (element instanceof IClient) {
            return ((IClient)element).getName();
        }
        if (element instanceof IModule) {
            return ((IModule)element).getName();
        }
        if (element instanceof IModule[]) {
            IModule[] modules = (IModule[])element;
            return modules[modules.length - 1].getName();
        }
        if (element instanceof IWorkbenchAdapter) {
            return ((IWorkbenchAdapter)element).getLabel(null);
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

