/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFactory;
import org.eclipse.wst.rdb.internal.core.connection.GenericConnectionFactory;

public class ConnectionFactoryRegistry {
    public static final ConnectionFactoryRegistry INSTANCE = new ConnectionFactoryRegistry();
    private Hashtable connectionFactories = new Hashtable();

    private ConnectionFactoryRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core", "connectionFactory");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("factory")) {
                    String driverClassName = configElements[j].getAttribute("driverClassName");
                    try {
                        ConnectionFactory driverLoader = (ConnectionFactory)configElements[j].createExecutableExtension("class");
                        this.connectionFactories.put(driverClassName, driverLoader);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the connection factory for " + driverClassName, (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public ConnectionFactory getConnectionFactory(String driverClassName) {
        ConnectionFactory factory = (ConnectionFactory)this.connectionFactories.get(driverClassName);
        if (factory == null) {
            return new GenericConnectionFactory();
        }
        return factory;
    }
}

