/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPluginIcons;
import org.eclipse.jst.j2ee.internal.wizard.AvailableUtilityJarsProvider;
import org.eclipse.jst.j2ee.internal.wizard.J2EEImportPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class J2EEUtilityJarImportPageNew
extends J2EEImportPage {
    private static final String STORE_LABEL = "J2EE_UTILITY_JAR_LIST_IMPORT_";
    private Button deselectAllButton;
    private Button selectAllButton;
    protected Button browseButton;
    protected Button useAlternateRootBtn;
    private Button overwriteProjectCheckbox;
    protected CheckboxTableViewer availableJARsViewer;
    protected boolean utilJarSelectionChanged = false;
    private Combo availableJarsCombo;
    protected Button linkedPathCheckbox;

    public J2EEUtilityJarImportPageNew(IDataModel model, String pageName) {
        super(model, pageName);
        this.setTitle(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_0"));
        this.setDescription(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_1"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor(J2EEUIPluginIcons.EAR_IMPORT_WIZARD_BANNER));
        this.setInfopopID("org.eclipse.jst.j2ee.ui.IMPORT_UTILITY_JAR_WIZARD_PAGE1");
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createUtilityJarFileNameComposite(composite);
        this.createLinkedPathVariable(composite);
        this.createJARsComposite(composite);
        this.createOverwriteCheckbox(composite);
        this.restoreWidgetValues();
        return composite;
    }

    protected void createUtilityJarFileNameComposite(Composite parent) {
        Group fileNameGroup = new Group(parent, 0);
        fileNameGroup.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_2"));
        GridLayout layout = new GridLayout(3, false);
        fileNameGroup.setLayout((Layout)layout);
        fileNameGroup.setLayoutData((Object)new GridData(768));
        Label fileLabel = new Label((Composite)fileNameGroup, 0);
        fileLabel.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_3"));
        fileLabel.setLayoutData((Object)new GridData(32));
        this.availableJarsCombo = new Combo((Composite)fileNameGroup, 2052);
        this.availableJarsCombo.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button((Composite)fileNameGroup, 8);
        this.browseButton.setText(defBrowseButtonLabel);
        this.browseButton.setLayoutData((Object)new GridData(128));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEUtilityJarImportPageNew.this.handleBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(true);
        this.synchHelper.synchCombo(this.availableJarsCombo, "J2EEUtilityJarListImportDataModel.AVAILABLE_JARS_DIRECTORY", new Control[]{fileLabel, this.browseButton});
    }

    protected void createLinkedPathVariable(Composite parent) {
        Group linkedPathGroup = new Group(parent, 0);
        linkedPathGroup.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_4"));
        GridLayout layout = new GridLayout(1, true);
        linkedPathGroup.setLayout((Layout)layout);
        linkedPathGroup.setLayoutData((Object)new GridData(768));
        Composite checkboxGroup = new Composite((Composite)linkedPathGroup, 0);
        GridLayout checkboxLayout = new GridLayout(2, false);
        checkboxGroup.setLayout((Layout)checkboxLayout);
        checkboxGroup.setLayoutData((Object)new GridData(1808));
        this.linkedPathCheckbox = new Button(checkboxGroup, 32);
        this.linkedPathCheckbox.setText(" ");
        Text linkedPathText = new Text(checkboxGroup, 578);
        linkedPathText.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_5"));
        GridData textGridData = new GridData(1808);
        textGridData.heightHint = 50;
        textGridData.widthHint = 350;
        linkedPathText.setLayoutData((Object)textGridData);
        linkedPathText.setBackground(checkboxGroup.getBackground());
        Combo availableLinkedPathsCombo = new Combo((Composite)linkedPathGroup, 2052);
        availableLinkedPathsCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(availableLinkedPathsCombo, "J2EEUtilityJarListImportDataModel.LINKED_PATH_VARIABLE", new Control[]{availableLinkedPathsCombo});
        this.synchHelper.synchCheckbox(this.linkedPathCheckbox, "J2EEUtilityJarListImportDataModel.CREATE_LINKED_PATH", new Control[]{availableLinkedPathsCombo});
    }

    protected void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.browseButton.getShell());
        dialog.setMessage(J2EEUIMessages.getResourceString("57"));
        String dirName = this.getBrowseStartLocation();
        if (!this.isNullOrEmpty(dirName) && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.availableJarsCombo.setText(selectedDirectory);
        }
    }

    protected String getBrowseStartLocation() {
        if (this.availableJarsCombo.getText() != null && this.availableJarsCombo.getText().length() > 0) {
            return this.availableJarsCombo.getText();
        }
        return null;
    }

    protected boolean isNullOrEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    protected void updateButtonEnablements() {
        this.utilJarSelectionChanged = true;
    }

    protected void createAvailableJarsList(Composite listGroup) {
        this.availableJARsViewer = CheckboxTableViewer.newCheckList((Composite)listGroup, (int)2816);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.availableJARsViewer.getControl().setLayoutData((Object)gData);
        AvailableUtilityJarsProvider availableUtilJARsProvider = new AvailableUtilityJarsProvider();
        this.availableJARsViewer.setContentProvider((IContentProvider)availableUtilJARsProvider);
        this.availableJARsViewer.setLabelProvider((IBaseLabelProvider)availableUtilJARsProvider);
        this.availableJARsViewer.getTable().setHeaderVisible(false);
        this.availableJARsViewer.getTable().setLinesVisible(false);
        this.availableJARsViewer.setInput((Object)this.model);
        this.synchHelper.synchCheckBoxTableViewer(this.availableJARsViewer, "J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST", null);
        this.model.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("J2EEUtilityJarListImportDataModel.AVAILABLE_JARS_DIRECTORY".equals(event.getPropertyName())) {
                    J2EEUtilityJarImportPageNew.this.availableJARsViewer.setInput((Object)J2EEUtilityJarImportPageNew.this.model);
                }
            }
        });
    }

    private void handleDeselectAllButtonPressed() {
        this.model.setProperty("J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST", (Object)new Object[0]);
    }

    private void handleSelectAllButtonPressed() {
        Object[] selection = new Object[this.availableJARsViewer.getTable().getItemCount()];
        int i = 0;
        while (i < selection.length) {
            selection[i] = this.availableJARsViewer.getElementAt(i);
            ++i;
        }
        this.model.setProperty("J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST", (Object)selection);
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1808));
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(J2EEUIMessages.getResourceString("47"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 1;
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.selectAllButton.setLayoutData((Object)gd);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEUtilityJarImportPageNew.this.handleSelectAllButtonPressed();
            }
        });
        this.deselectAllButton = new Button(buttonGroup, 8);
        this.deselectAllButton.setText(J2EEUIMessages.getResourceString("48"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = 22;
        gd.widthHint = 120;
        this.deselectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEUtilityJarImportPageNew.this.handleDeselectAllButtonPressed();
            }
        });
    }

    protected void createJARsComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(J2EEUIMessages.getResourceString("49"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        Label description = new Label((Composite)group, 0);
        description.setText(J2EEUIMessages.getResourceString("97"));
        GridData gd2 = new GridData(256);
        gd2.horizontalSpan = 2;
        description.setLayoutData((Object)gd2);
        this.createAvailableJarsList((Composite)group);
        this.createButtonsGroup((Composite)group);
    }

    protected void createOverwriteCheckbox(Composite parent) {
        this.overwriteProjectCheckbox = new Button(parent, 32);
        this.overwriteProjectCheckbox.setText(J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_6"));
        this.synchHelper.synchCheckbox(this.overwriteProjectCheckbox, "J2EEUtilityJarListImportDataModel.OVERWRITE_IF_NECESSARY", null);
    }

    protected void setJARsCompositeEnabled(boolean enabled) {
        this.availableJARsViewer.getTable().setEnabled(enabled);
        this.availableJARsViewer.setAllChecked(false);
        this.availableJARsViewer.setAllGrayed(!enabled);
        this.selectAllButton.setEnabled(enabled);
        this.deselectAllButton.setEnabled(enabled);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"J2EEUtilityJarListImportDataModel.UTILITY_JAR_LIST", "J2EEUtilityJarListImportDataModel.OVERWRITE_IF_NECESSARY", "J2EEUtilityJarListImportDataModel.LINKED_PATH_VARIABLE"};
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (sourceNames[i] == null) {
                    sourceNames[i] = "";
                }
                ++i;
            }
            this.availableJarsCombo.setItems(sourceNames);
        }
    }

    public void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            String newName = this.availableJarsCombo.getText();
            ArrayList<String> newNames = new ArrayList<String>();
            int i = 0;
            while (i < sourceNames.length && i < 5) {
                if (sourceNames[i].trim().length() > 0 && !newName.equals(sourceNames[i])) {
                    newNames.add(sourceNames[i]);
                }
                ++i;
            }
            newNames.add(0, this.availableJarsCombo.getText());
            sourceNames = new String[newNames.size()];
            newNames.toArray(sourceNames);
            settings.put(STORE_LABEL + this.getFileNamesStoreID(), sourceNames);
        }
    }

    protected String getFileNamesStoreID() {
        return "UTIL";
    }

    protected String getFileImportLabel() {
        return J2EEUIMessages.getResourceString("J2EEUtilityJarImportPage_UI_7");
    }
}

