/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.report.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.report.Entry;
import org.eclipse.wst.wsi.internal.core.report.EntryContainer;
import org.eclipse.wst.wsi.internal.core.report.impl.EntryResultImpl;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;

public class EntryImpl
extends EntryResultImpl
implements Entry {
    protected EntryType entryType = null;
    protected String artifactName = null;
    protected String referenceID = null;
    protected String parentElementName = null;
    protected Object entryDetail = null;
    protected EntryContainer entryContainer = null;

    public EntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntryType entryType) {
        this.entryType = entryType;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public String getReferenceID() {
        return this.referenceID;
    }

    public void setReferenceID(String referenceID) {
        this.referenceID = referenceID;
    }

    public String getParentElementName() {
        return this.parentElementName;
    }

    public void setParentElementName(String parentElementName) {
        this.parentElementName = parentElementName;
    }

    public Object getEntryDetail() {
        return this.entryDetail;
    }

    public void setEntryDetail(Object entryDetail) {
        this.entryDetail = entryDetail;
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public void setEntryContainer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public void addAssertionResult(AssertionResult assertionResult) {
        super.addAssertionResult(assertionResult);
        if (this.entryContainer != null) {
            this.entryContainer.addAssertionResult(assertionResult);
        }
    }

    public String getStartXMLString(String namespaceName, boolean showLogEntry, boolean envelopeArtifactType) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.print("    <" + nsName + "entry" + " ");
        if (this.entryType != null) {
            if (envelopeArtifactType) {
                pw.print("type=\"" + this.getCorrespondingEnvelopeEntryTypeName(this.entryType.getTypeName()) + "\" ");
            } else {
                pw.print("type=\"" + this.entryType.getTypeName() + "\" ");
            }
        } else if (this.artifactName != null) {
            pw.print("type=\"[" + this.artifactName + "]\" ");
        }
        if (this.referenceID != null) {
            pw.print("referenceID=\"" + XMLUtils.xmlEscapedString(this.referenceID) + "\"");
        }
        pw.println(">");
        if (this.entryType != null && this.entryType.getArtifactType().isMessages() && showLogEntry) {
            MessageEntry logEntry = (MessageEntry)this.entryDetail;
            pw.println(logEntry.toXMLString("wsi-log"));
        }
        return sw.toString();
    }

    public String getStartXMLString(String namespaceName, boolean showLogEntry) {
        return this.getStartXMLString(namespaceName, showLogEntry, false);
    }

    public String getEndXMLString(String namespaceName) {
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        return "    </" + nsName + "entry" + ">";
    }

    public String toXMLString(String namespaceName) {
        return String.valueOf(this.getStartXMLString("", false)) + this.getEndXMLString("");
    }

    public String getCorrespondingEnvelopeEntryTypeName(String messageEntryTypeName) {
        String envelopeEntryTypeName = messageEntryTypeName;
        if (messageEntryTypeName != null) {
            if (messageEntryTypeName.equals("anyMessage")) {
                envelopeEntryTypeName = "anyEnvelope";
            } else if (messageEntryTypeName.equals("requestMessage")) {
                envelopeEntryTypeName = "requestEnvelope";
            } else if (messageEntryTypeName.equals("responseMessage")) {
                envelopeEntryTypeName = "responseEnvelope";
            }
        }
        return envelopeEntryTypeName;
    }
}

