/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

class CMNamedNodeMapImpl
implements CMNamedNodeMap {
    private Hashtable items = new Hashtable();

    public int getLength() {
        return this.items.size();
    }

    public CMNode getNamedItem(String name) {
        String cookedName = this.makeCanonicalForm(name);
        if (!this.items.containsKey(cookedName)) {
            return null;
        }
        return (CMNode)this.items.get(cookedName);
    }

    public CMNode item(int index) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            CMNode node = (CMNode)iter.next();
            if (--index >= 0) continue;
            return node;
        }
        return null;
    }

    public Iterator iterator() {
        return this.items.values().iterator();
    }

    private String makeCanonicalForm(String rawForm) {
        return rawForm.toUpperCase();
    }

    void putNamedItem(String name, CMNode item) {
        String cookedName = this.makeCanonicalForm(name);
        if (this.items.containsKey(cookedName)) {
            return;
        }
        this.items.put(cookedName, item);
    }
}

