/*
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *
 * $Id: ParameterSetOperations.java,v 1.4 2006/01/05 22:43:26 khussey Exp $
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;

import org.eclipse.uml2.uml.ParameterSet;

import org.eclipse.uml2.uml.util.UMLValidator;

/**
 * <!-- begin-user-doc -->
 * A static utility class that provides operations related to '<em><b>Parameter Set</b></em>' model objects.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following operations are supported:
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.ParameterSet#validateSameParameterizedEntity(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Validate Same Parameterized Entity</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.ParameterSet#validateInput(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Validate Input</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.ParameterSet#validateTwoParameterSets(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Validate Two Parameter Sets</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ParameterSetOperations
		extends NamedElementOperations {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterSetOperations() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The parameters in a parameter set must all be inputs or all be outputs of the same parameterized entity, and the parameter set is owned by that entity.
	 * true
	 * <!-- end-model-doc -->
	 * @generated
	 */
	public static boolean validateSameParameterizedEntity(
			ParameterSet parameterSet, DiagnosticChain diagnostics, Map context) {
		// TODO: implement this method
		// -> specify the condition that violates the invariant
		// -> verify the details of the diagnostic, including severity and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics
					.add(new BasicDiagnostic(
						Diagnostic.ERROR,
						UMLValidator.DIAGNOSTIC_SOURCE,
						UMLValidator.PARAMETER_SET__SAME_PARAMETERIZED_ENTITY,
						org.eclipse.emf.ecore.plugin.EcorePlugin.INSTANCE
							.getString(
								"_UI_GenericInvariant_diagnostic", new Object[]{"validateSameParameterizedEntity", org.eclipse.emf.ecore.util.EObjectValidator.getObjectLabel(parameterSet, context)}), //$NON-NLS-1$ //$NON-NLS-2$
						new Object[]{parameterSet}));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If a behavior has input parameters that are in a parameter set, then any inputs that are not in a parameter set must be streaming. Same for output parameters.
	 * true
	 * <!-- end-model-doc -->
	 * @generated
	 */
	public static boolean validateInput(ParameterSet parameterSet,
			DiagnosticChain diagnostics, Map context) {
		// TODO: implement this method
		// -> specify the condition that violates the invariant
		// -> verify the details of the diagnostic, including severity and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics
					.add(new BasicDiagnostic(
						Diagnostic.ERROR,
						UMLValidator.DIAGNOSTIC_SOURCE,
						UMLValidator.PARAMETER_SET__INPUT,
						org.eclipse.emf.ecore.plugin.EcorePlugin.INSTANCE
							.getString(
								"_UI_GenericInvariant_diagnostic", new Object[]{"validateInput", org.eclipse.emf.ecore.util.EObjectValidator.getObjectLabel(parameterSet, context)}), //$NON-NLS-1$ //$NON-NLS-2$
						new Object[]{parameterSet}));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Two parameter sets cannot have exactly the same set of parameters.
	 * true
	 * <!-- end-model-doc -->
	 * @generated
	 */
	public static boolean validateTwoParameterSets(ParameterSet parameterSet,
			DiagnosticChain diagnostics, Map context) {
		// TODO: implement this method
		// -> specify the condition that violates the invariant
		// -> verify the details of the diagnostic, including severity and message
		// Ensure that you remove @generated or mark it @generated NOT
		if (false) {
			if (diagnostics != null) {
				diagnostics
					.add(new BasicDiagnostic(
						Diagnostic.ERROR,
						UMLValidator.DIAGNOSTIC_SOURCE,
						UMLValidator.PARAMETER_SET__TWO_PARAMETER_SETS,
						org.eclipse.emf.ecore.plugin.EcorePlugin.INSTANCE
							.getString(
								"_UI_GenericInvariant_diagnostic", new Object[]{"validateTwoParameterSets", org.eclipse.emf.ecore.util.EObjectValidator.getObjectLabel(parameterSet, context)}), //$NON-NLS-1$ //$NON-NLS-2$
						new Object[]{parameterSet}));
			}
			return false;
		}
		return true;
	}

} // ParameterSetOperations