/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class GenPackageGeneratorAdapter
extends GenBaseGeneratorAdapter {
    protected static final int PACKAGE_CLASS_ID = 0;
    protected static final int FACTORY_CLASS_ID = 1;
    protected static final int XML_PROCESSOR_CLASS_ID = 2;
    protected static final int VALIDATOR_CLASS_ID = 3;
    protected static final int SWITCH_CLASS_ID = 4;
    protected static final int ADAPTER_FACTORY_CLASS_ID = 5;
    protected static final int RESOURCE_FACTORY_CLASS_ID = 6;
    protected static final int RESOURCE_CLASS_ID = 7;
    protected static final int ITEM_PROVIDER_ADAPTER_FACTORY_ID = 8;
    protected static final int EDITOR_ID = 9;
    protected static final int MODEL_WIZARD_ID = 10;
    protected static final int ACTION_BAR_CONTRIBUTOR_ID = 11;
    protected static final int PACKAGE_TEST_SUITE_ID = 12;
    protected static final int PACKAGE_EXAMPLE_ID = 13;
    private static final AbstractGeneratorAdapter.JETEmitterDescriptor[] JET_EMITTER_DESCRIPTORS = new AbstractGeneratorAdapter.JETEmitterDescriptor[]{new AbstractGeneratorAdapter.JETEmitterDescriptor("model/PackageClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.PackageClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/FactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.FactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/XMLProcessorClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.XMLProcessorClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ValidatorClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ValidatorClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/SwitchClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.SwitchClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/AdapterFactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.AdapterFactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ResourceFactoryClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ResourceFactoryClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model/ResourceClass.javajet", "org.eclipse.emf.codegen.ecore.templates.model.ResourceClass"), new AbstractGeneratorAdapter.JETEmitterDescriptor("edit/ItemProviderAdapterFactory.javajet", "org.eclipse.emf.codegen.ecore.templates.edit.ItemProviderAdapterFactory"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/Editor.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.Editor"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/ModelWizard.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.ModelWizard"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/ActionBarContributor.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.ActionBarContributor"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model.tests/PackageTestSuite.javajet", "org.eclipse.emf.codegen.ecore.templates.model.tests.PackageTestSuite"), new AbstractGeneratorAdapter.JETEmitterDescriptor("model.tests/PackageExample.javajet", "org.eclipse.emf.codegen.ecore.templates.model.tests.PackageExample")};
    protected static final int MODEL_ICON_ID = 0;
    protected static final int MODEL_WIZARD_ICON_ID = 1;
    private static final String[] INPUT_PATH_NAMES = new String[]{"editor/ModelFile.gif", "editor/NewModel.gif"};

    protected AbstractGeneratorAdapter.JETEmitterDescriptor[] getJETEmitterDescriptors() {
        return JET_EMITTER_DESCRIPTORS;
    }

    protected String[] getInputPathNames() {
        return INPUT_PATH_NAMES;
    }

    public GenPackageGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
        super(generatorAdapterFactory);
    }

    protected Collection getGenerateModelChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList result = new ArrayList(genPackage.getGenClasses());
        result.addAll(genPackage.getGenEnums());
        result.addAll(genPackage.getNestedGenPackages());
        return result;
    }

    protected Collection getGenerateEditChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList result = new ArrayList(genPackage.getGenClasses());
        result.addAll(genPackage.getNestedGenPackages());
        return result;
    }

    protected Collection getGenerateEditorChildren(Object object) {
        return new ArrayList(((GenPackage)object).getNestedGenPackages());
    }

    protected Collection getGenerateTestsChildren(Object object) {
        GenPackage genPackage = (GenPackage)object;
        ArrayList result = new ArrayList(genPackage.getGenClasses());
        result.addAll(genPackage.getNestedGenPackages());
        return result;
    }

    public Object getGenerateParent(Object object, Object projectType) {
        return this.getParent(object);
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject".equals(projectType)) {
            ((GenPackage)object).prepareCache();
            return Diagnostic.OK_INSTANCE;
        }
        return super.doPreGenerate(object, projectType);
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        if ("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject".equals(projectType)) {
            ((GenPackage)object).clearCache();
            return Diagnostic.OK_INSTANCE;
        }
        return super.doPreGenerate(object, projectType);
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        monitor.beginTask("", 13);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingPackage_message", new Object[]{genPackage.getPackageInterfaceName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getModelDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateSchema(genPackage, monitor);
        this.generatePackageSerialization(genPackage, monitor);
        this.generatePackageInterface(genPackage, monitor);
        this.generatePackageClass(genPackage, monitor);
        this.generateFactoryInterface(genPackage, monitor);
        this.generateFactoryClass(genPackage, monitor);
        this.generateXMLProcessorClass(genPackage, monitor);
        this.generateValidatorClass(genPackage, monitor);
        this.generateSwitchClass(genPackage, monitor);
        this.generateAdapterFactoryClass(genPackage, monitor);
        this.generateResourceFactoryClass(genPackage, monitor);
        this.generateResourceClass(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateSchema(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.getGenModel().isGenerateSchema()) {
            genPackage.generateSchema();
        }
        monitor.worked(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generatePackageSerialization(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isLoadingInitialization()) {
            monitor = this.createMonitor(monitor, 1);
            try {
                EList contents;
                Resource resource;
                monitor.beginTask("", 2);
                GenModel genModel = genPackage.getGenModel();
                String targetPathName = String.valueOf(genModel.getModelDirectory()) + "/" + genPackage.getClassPackageName().replace('.', '/') + "/" + genPackage.getSerializedPackageFilename();
                this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingPackageSerialization_message", new Object[]{targetPathName});
                monitor.subTask(this.message);
                URI targetFile = this.toURI(targetPathName);
                this.ensureContainerExists(targetFile.trimSegments(1), this.createMonitor(monitor, 1));
                Resource outputResource = genPackage.getEcorePackage().eResource();
                ResourceSet set = outputResource.getResourceSet();
                URI targetURI = this.toPlatformResourceURI(targetFile);
                HashMap<Resource, URI> oldURIs = new HashMap<Resource, URI>();
                Iterator i = set.getResources().iterator();
                while (true) {
                    if (!i.hasNext()) {
                        try {
                            outputResource.save(null);
                        }
                        catch (IOException exception) {
                            CodeGenEcorePlugin.INSTANCE.log(exception);
                        }
                        break;
                    }
                    resource = (Resource)i.next();
                    contents = resource.getContents();
                    if (contents.isEmpty() || !(contents.get(0) instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)contents.get(0);
                    oldURIs.put(resource, resource.getURI());
                    resource.setURI(resource == outputResource ? targetURI : URI.createURI((String)ePackage.getNsURI()));
                }
                i = set.getResources().iterator();
                while (i.hasNext()) {
                    resource = (Resource)i.next();
                    contents = resource.getContents();
                    if (contents.isEmpty() || !(contents.get(0) instanceof EPackage)) continue;
                    resource.setURI((URI)oldURIs.get(resource));
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var14_17 = null;
                monitor.done();
                return;
            }
        }
        monitor.worked(1);
    }

    protected void generatePackageInterface(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers() && !genModel.isSuppressEMFMetaData() && !genModel.isSuppressInterfaces()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{genPackage.getQualifiedPackageInterfaceName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionPackageName(), genPackage.getPackageInterfaceName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genPackage, Boolean.TRUE, Boolean.FALSE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generatePackageClass(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedPackageClassName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionClassPackageName(), genPackage.getPackageClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 0), new Object[]{new Object[]{genPackage, genModel.isSuppressEMFMetaData() || genModel.isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateFactoryInterface(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers() && !genModel.isSuppressInterfaces()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{genPackage.getQualifiedFactoryInterfaceName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionPackageName(), genPackage.getFactoryInterfaceName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 1), new Object[]{new Object[]{genPackage, Boolean.TRUE, Boolean.FALSE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateFactoryClass(GenPackage genPackage, Monitor monitor) {
        GenModel genModel = genPackage.getGenModel();
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genModel.getModelDirectory(), genPackage.getReflectionClassPackageName(), genPackage.getFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 1), new Object[]{new Object[]{genPackage, genModel.isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}}, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateXMLProcessorClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.getResource().getValue() == 3) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedXMLProcessorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getXMLProcessorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 2), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateValidatorClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.hasConstraints()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedValidatorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getValidatorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 3), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateSwitchClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isAdapterFactory() && !genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedSwitchClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getSwitchClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 4), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateAdapterFactoryClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isAdapterFactory() && !genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedAdapterFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getAdapterFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 5), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateResourceFactoryClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.getResource() != GenResourceKind.NONE_LITERAL) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedResourceFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getResourceFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 6), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateResourceClass(GenPackage genPackage, Monitor monitor) {
        if (genPackage.getResource() != GenResourceKind.NONE_LITERAL) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedResourceClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getModelDirectory(), genPackage.getUtilitiesPackageName(), genPackage.getResourceClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 7), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected Diagnostic generateEdit(Object object, Monitor monitor) {
        monitor.beginTask("", 2);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemProvidersForPackage_message", new Object[]{genPackage.getPackageInterfaceName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getEditDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateItemProviderAdapterFactory(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateItemProviderAdapterFactory(GenPackage genPackage, Monitor monitor) {
        if (!genPackage.getGenClasses().isEmpty()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedItemProviderAdapterFactoryClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditDirectory(), genPackage.getProviderPackageName(), genPackage.getItemProviderAdapterFactoryClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 8), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected Diagnostic generateEditor(Object object, Monitor monitor) {
        monitor.beginTask("", 6);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingEditorForPackage_message", new Object[]{genPackage.getPackageInterfaceName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getEditorDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generateEditor(genPackage, monitor);
        this.generateModelWizard(genPackage, monitor);
        this.generateActionBarContributor(genPackage, monitor);
        this.generateModelIcon(genPackage, monitor);
        this.generateModelWizardIcon(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generateEditor(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedEditorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getEditorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 9), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelWizard(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedModelWizardClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getModelWizardClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 10), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateActionBarContributor(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedActionBarContributorClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), genPackage.getActionBarContributorClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 11), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelIcon(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingModelIcon_message", new Object[]{genPackage.getModelIconFileName()});
            monitor.subTask(this.message);
            this.generateGIF(genPackage.getModelIconFileName(), this.getGIFEmitter(this.getInputPathNames(), 0), genPackage.getPrefix(), null, false, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generateModelWizardIcon(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasConcreteClasses()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingModelWizardIcon_message", new Object[]{genPackage.getModelWizardIconFileName()});
            monitor.subTask(this.message);
            this.generateGIF(genPackage.getModelWizardIconFileName(), this.getGIFEmitter(this.getInputPathNames(), 1), genPackage.getPrefix(), null, false, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected Diagnostic generateTests(Object object, Monitor monitor) {
        monitor.beginTask("", 3);
        GenPackage genPackage = (GenPackage)object;
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingTestsForPackage_message", new Object[]{genPackage.getPackageInterfaceName()});
        monitor.subTask(this.message);
        GenModel genModel = genPackage.getGenModel();
        this.ensureProjectExists(genModel.getTestsDirectory(), genPackage, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
        this.generatePackageTestSuite(genPackage, monitor);
        this.generatePackageExample(genPackage, monitor);
        return Diagnostic.OK_INSTANCE;
    }

    protected void generatePackageTestSuite(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedTestSuiteClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getTestsDirectory(), genPackage.getTestsPackageName(), genPackage.getTestSuiteClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 12), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    protected void generatePackageExample(GenPackage genPackage, Monitor monitor) {
        if (genPackage.hasClassifiers() && genPackage.isGenerateExampleClass()) {
            this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{genPackage.getQualifiedExampleClassName()});
            monitor.subTask(this.message);
            this.generateJava(genPackage.getGenModel().getTestsDirectory(), genPackage.getTestsPackageName(), genPackage.getExampleClassName(), this.getJETEmitter(this.getJETEmitterDescriptors(), 13), null, this.createMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }
}

