require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MVME88K_BUS_H_)) {
    eval 'sub _MVME88K_BUS_H_ () {1;}' unless defined(&_MVME88K_BUS_H_);
    require 'machine/asm_macro.ph';
    eval 'sub BUS_SPACE_BARRIER_READ () {0;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {1;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub bus_space_map {
        my($t,$a,$s,$f,$r) = @_;
	    eval q((($t)-> &bs_map($a,$s,$f,$r)));
    }' unless defined(&bus_space_map);
    eval 'sub bus_space_unmap {
        my($t,$h,$s) = @_;
	    eval q((($t)-> &bs_unmap($h,$s)));
    }' unless defined(&bus_space_unmap);
    eval 'sub bus_space_subregion {
        my($t,$h,$o,$s,$r) = @_;
	    eval q((($t)-> &bs_subregion($h,$o,$s,$r)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_vaddr {
        my($t,$h) = @_;
	    eval q((($t)-> &bs_vaddr($h)));
    }' unless defined(&bus_space_vaddr);
    eval 'sub bus_space_read_1 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($tag, $handle, $offset) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int16_t *)(($handle) + ($offset))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_write_1 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int8_t *)(($handle) + ($offset)) = ($value)));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($tag, $handle, $offset, $value) = @_;
	    eval q((( &void)($tag), *( &volatile  &u_int16_t *)(($handle) + ($offset)) = ($value)));
    }' unless defined(&bus_space_write_2);
    unless(defined(&__BUS_SPACE_RESTRICT_D16__)) {
	eval 'sub bus_space_read_4 {
	    my($tag, $handle, $offset) = @_;
    	    eval q((( &void)($tag), *( &volatile  &u_int32_t *)(($handle) + ($offset))));
	}' unless defined(&bus_space_read_4);
	eval 'sub bus_space_write_4 {
	    my($tag, $handle, $offset, $value) = @_;
    	    eval q((( &void)($tag), *( &volatile  &u_int32_t *)(($handle) + ($offset)) = ($value)));
	}' unless defined(&bus_space_write_4);
    } else {
	eval 'sub bus_space_read_4 {
	    my($tag, $handle, $offset) = @_;
    	    eval q((( &void)($tag),  &d16_read_4(($handle) + ($offset))));
	}' unless defined(&bus_space_read_4);
	eval 'sub bus_space_write_4 {
	    my($tag, $handle, $offset, $value) = @_;
    	    eval q((( &void)($tag),  &d16_write_4(($handle) + ($offset), ($value))));
	}' unless defined(&bus_space_write_4);
    }
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMAMEM_NOSYNC () {0x8;}' unless defined(&BUS_DMAMEM_NOSYNC);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_READ () {0x100;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x200;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_STREAMING () {0x400;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
}
1;
