require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MAC68K_INTR_H_)) {
    eval 'sub _MAC68K_INTR_H_ () {1;}' unless defined(&_MAC68K_INTR_H_);
    require 'machine/psl.ph';
    if(defined(&_KERNEL)) {
	eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
	eval 'sub IPL_SOFTNET () {1;}' unless defined(&IPL_SOFTNET);
	eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
	eval 'sub IPL_BIO () { &PSLTOIPL( &mac68k_bioipl);}' unless defined(&IPL_BIO);
	eval 'sub IPL_NET () { &PSLTOIPL( &mac68k_netipl);}' unless defined(&IPL_NET);
	eval 'sub IPL_TTY () { &PSLTOIPL( &mac68k_ttyipl);}' unless defined(&IPL_TTY);
	eval 'sub IPL_CLOCK () { &PSLTOIPL( &mac68k_clockipl);}' unless defined(&IPL_CLOCK);
	eval 'sub IPL_STATCLOCK () { &PSLTOIPL( &mac68k_statclockipl);}' unless defined(&IPL_STATCLOCK);
	eval 'sub IPL_HIGH () {7;}' unless defined(&IPL_HIGH);
	eval 'sub splsoft () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL1));
	}' unless defined(&splsoft);
	eval 'sub splsoftclock () {
	    eval q( &splsoft());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splsoft());
	}' unless defined(&splsoftnet);
	eval 'sub spltty () {
	    eval q( &_splraise( &mac68k_ttyipl));
	}' unless defined(&spltty);
	eval 'sub splbio () {
	    eval q( &_splraise( &mac68k_bioipl));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &_splraise( &mac68k_netipl));
	}' unless defined(&splnet);
	eval 'sub splvm () {
	    eval q( &_splraise( &mac68k_vmipl));
	}' unless defined(&splvm);
	eval 'sub splaudio () {
	    eval q( &_splraise( &mac68k_audioipl));
	}' unless defined(&splaudio);
	eval 'sub splclock () {
	    eval q( &_splraise( &mac68k_clockipl));
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &_splraise( &mac68k_statclockipl));
	}' unless defined(&splstatclock);
	eval 'sub splserial () {
	    eval q( &_splraise( &PSL_S |  &PSL_IPL4));
	}' unless defined(&splserial);
	eval 'sub splhigh () {
	    eval q( &_spl( &PSL_S |  &PSL_IPL7));
	}' unless defined(&splhigh);
	eval 'sub spladb () {
	    eval q( &splhigh());
	}' unless defined(&spladb);
	eval 'sub splzs () {
	    eval q( &splserial());
	}' unless defined(&splzs);
	eval 'sub splx {
	    my($s) = @_;
    	    eval q((($s) &  &PSL_IPL ?  &_spl($s) :  &spl0()));
	}' unless defined(&splx);
	eval 'sub SIR_NET () {0x1;}' unless defined(&SIR_NET);
	eval 'sub SIR_CLOCK () {0x2;}' unless defined(&SIR_CLOCK);
	eval 'sub SIR_SERIAL () {0x4;}' unless defined(&SIR_SERIAL);
	eval 'sub SIR_ADB () {0x8;}' unless defined(&SIR_ADB);
	eval 'sub siron {
	    my($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"orb %1,%0\\" : \\"=m\\" ( &ssir) : \\"i\\" ($mask)));
	}' unless defined(&siron);
	eval 'sub siroff {
	    my($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"andb %1,%0\\" : \\"=m\\" ( &ssir) : \\"ir\\" (~($mask))));
	}' unless defined(&siroff);
	eval 'sub setsoftnet () {
	    eval q( &siron( &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q( &siron( &SIR_CLOCK));
	}' unless defined(&setsoftclock);
	eval 'sub setsoftserial () {
	    eval q( &siron( &SIR_SERIAL));
	}' unless defined(&setsoftserial);
	eval 'sub setsoftadb () {
	    eval q( &siron( &SIR_ADB));
	}' unless defined(&setsoftadb);
	require 'sys/evcount.ph';
    }
}
1;
