require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARM32_BUS_H_)) {
    eval 'sub _ARM32_BUS_H_ () {1;}' unless defined(&_ARM32_BUS_H_);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
    }
    eval 'sub __bs_c {
        my($a,$b) = @_;
	    eval q( &__CONCAT($a,$b));
    }' unless defined(&__bs_c);
    eval 'sub __bs_opname {
        my($op,$size) = @_;
	    eval q( &__bs_c( &__bs_c( &__bs_c( &bs_,$op), &_),$size));
    }' unless defined(&__bs_opname);
    eval 'sub __bs_rs {
        my($sz, $t, $h, $o) = @_;
	    eval q((*($t)-> &__bs_opname( &r,$sz))(($t)-> &bs_cookie, $h, $o));
    }' unless defined(&__bs_rs);
    eval 'sub __bs_ws {
        my($sz, $t, $h, $o, $v) = @_;
	    eval q((*($t)-> &__bs_opname( &w,$sz))(($t)-> &bs_cookie, $h, $o, $v));
    }' unless defined(&__bs_ws);
    eval 'sub __bs_nonsingle {
        my($type, $sz, $t, $h, $o, $a, $c) = @_;
	    eval q((*($t)-> &__bs_opname($type,$sz))(($t)-> &bs_cookie, $h, $o, $a, $c));
    }' unless defined(&__bs_nonsingle);
    eval 'sub __bs_set {
        my($type, $sz, $t, $h, $o, $v, $c) = @_;
	    eval q((*($t)-> &__bs_opname($type,$sz))(($t)-> &bs_cookie, $h, $o, $v, $c));
    }' unless defined(&__bs_set);
    eval 'sub __bs_copy {
        my($sz, $t, $h1, $o1, $h2, $o2, $cnt) = @_;
	    eval q((*($t)-> &__bs_opname( &c,$sz))(($t)-> &bs_cookie, $h1, $o1, $h2, $o2, $cnt));
    }' unless defined(&__bs_copy);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub __bs_opname_s {
	    my($op,$size) = @_;
    	    eval q( &__bs_c( &__bs_c( &__bs_c( &__bs_c( &bs_,$op), &_),$size), &_s));
	}' unless defined(&__bs_opname_s);
	eval 'sub __bs_rs_s {
	    my($sz, $t, $h, $o) = @_;
    	    eval q((*($t)-> &__bs_opname_s( &r,$sz))(($t)-> &bs_cookie, $h, $o));
	}' unless defined(&__bs_rs_s);
	eval 'sub __bs_ws_s {
	    my($sz, $t, $h, $o, $v) = @_;
    	    eval q((*($t)-> &__bs_opname_s( &w,$sz))(($t)-> &bs_cookie, $h, $o, $v));
	}' unless defined(&__bs_ws_s);
	eval 'sub __bs_nonsingle_s {
	    my($type, $sz, $t, $h, $o, $a, $c) = @_;
    	    eval q((*($t)-> &__bs_opname_s($type,$sz))(($t)-> &bs_cookie, $h, $o, $a, $c));
	}' unless defined(&__bs_nonsingle_s);
	eval 'sub __bs_set_s {
	    my($type, $sz, $t, $h, $o, $v, $c) = @_;
    	    eval q((*($t)-> &__bs_opname_s($type,$sz))(($t)-> &bs_cookie, $h, $o, $v, $c));
	}' unless defined(&__bs_set_s);
	eval 'sub __bs_copy_s {
	    my($sz, $t, $h1, $o1, $h2, $o2, $cnt) = @_;
    	    eval q((*($t)-> &__bs_opname_s( &c,$sz))(($t)-> &bs_cookie, $h1, $o1, $h2, $o2, $cnt));
	}' unless defined(&__bs_copy_s);
    }
    eval 'sub bus_space_map {
        my($t, $a, $s, $c, $hp) = @_;
	    eval q((*($t)-> &bs_map)(($t)-> &bs_cookie, ($a), ($s), ($c), ($hp)));
    }' unless defined(&bus_space_map);
    eval 'sub bus_space_unmap {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &bs_unmap)(($t)-> &bs_cookie, ($h), ($s)));
    }' unless defined(&bus_space_unmap);
    eval 'sub bus_space_subregion {
        my($t, $h, $o, $s, $hp) = @_;
	    eval q((*($t)-> &bs_subregion)(($t)-> &bs_cookie, ($h), ($o), ($s), ($hp)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_alloc {
        my($t, $rs, $re, $s, $a, $b, $c, $ap, $hp) = @_;
	    eval q((*($t)-> &bs_alloc)(($t)-> &bs_cookie, ($rs), ($re), ($s), ($a), ($b), ($c), ($ap), ($hp)));
    }' unless defined(&bus_space_alloc);
    eval 'sub bus_space_free {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &bs_free)(($t)-> &bs_cookie, ($h), ($s)));
    }' unless defined(&bus_space_free);
    eval 'sub bus_space_vaddr {
        my($t, $h) = @_;
	    eval q((*($t)-> &bs_vaddr)(($t)-> &bs_cookie, ($h)));
    }' unless defined(&bus_space_vaddr);
    eval 'sub bus_space_mmap {
        my($t, $a, $o, $p, $f) = @_;
	    eval q((*($t)-> &bs_mmap)(($t)-> &bs_cookie, ($a), ($o), ($p), ($f)));
    }' unless defined(&bus_space_mmap);
    eval 'sub bus_space_barrier {
        my($t, $h, $o, $l, $f) = @_;
	    eval q((*($t)-> &bs_barrier)(($t)-> &bs_cookie, ($h), ($o), ($l), ($f)));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub bus_space_read_1 {
        my($t, $h, $o) = @_;
	    eval q( &__bs_rs(1,($t),($h),($o)));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($t, $h, $o) = @_;
	    eval q( &__bs_rs(2,($t),($h),($o)));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($t, $h, $o) = @_;
	    eval q( &__bs_rs(4,($t),($h),($o)));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_read_8 {
        my($t, $h, $o) = @_;
	    eval q( &__bs_rs(8,($t),($h),($o)));
    }' unless defined(&bus_space_read_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_read_stream_1 {
	    my($t, $h, $o) = @_;
    	    eval q( &__bs_rs_s(1,($t),($h),($o)));
	}' unless defined(&bus_space_read_stream_1);
	eval 'sub bus_space_read_stream_2 {
	    my($t, $h, $o) = @_;
    	    eval q( &__bs_rs_s(2,($t),($h),($o)));
	}' unless defined(&bus_space_read_stream_2);
	eval 'sub bus_space_read_stream_4 {
	    my($t, $h, $o) = @_;
    	    eval q( &__bs_rs_s(4,($t),($h),($o)));
	}' unless defined(&bus_space_read_stream_4);
	eval 'sub bus_space_read_stream_8 {
	    my($t, $h, $o) = @_;
    	    eval q( &__bs_rs_s(8,($t),($h),($o)));
	}' unless defined(&bus_space_read_stream_8);
    }
    eval 'sub bus_space_read_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rm,1,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rm,2,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rm,4,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_multi_4);
    eval 'sub bus_space_read_multi_8 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rm,8,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_multi_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_read_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rm,1,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_multi_stream_1);
	eval 'sub bus_space_read_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rm,2,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_multi_stream_2);
	eval 'sub bus_space_read_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rm,4,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_multi_stream_4);
	eval 'sub bus_space_read_multi_stream_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rm,8,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_multi_stream_8);
    }
    eval 'sub bus_space_read_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rr,1,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rr,2,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rr,4,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_region_4);
    eval 'sub bus_space_read_region_8 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &rr,8,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_read_region_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_read_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rr,1,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_region_stream_1);
	eval 'sub bus_space_read_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rr,2,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_region_stream_2);
	eval 'sub bus_space_read_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rr,4,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_region_stream_4);
	eval 'sub bus_space_read_region_stream_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &rr,8,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_read_region_stream_8);
    }
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q( &__bs_ws(1,($t),($h),($o),($v)));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q( &__bs_ws(2,($t),($h),($o),($v)));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q( &__bs_ws(4,($t),($h),($o),($v)));
    }' unless defined(&bus_space_write_4);
    eval 'sub bus_space_write_8 {
        my($t, $h, $o, $v) = @_;
	    eval q( &__bs_ws(8,($t),($h),($o),($v)));
    }' unless defined(&bus_space_write_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_write_stream_1 {
	    my($t, $h, $o, $v) = @_;
    	    eval q( &__bs_ws_s(1,($t),($h),($o),($v)));
	}' unless defined(&bus_space_write_stream_1);
	eval 'sub bus_space_write_stream_2 {
	    my($t, $h, $o, $v) = @_;
    	    eval q( &__bs_ws_s(2,($t),($h),($o),($v)));
	}' unless defined(&bus_space_write_stream_2);
	eval 'sub bus_space_write_stream_4 {
	    my($t, $h, $o, $v) = @_;
    	    eval q( &__bs_ws_s(4,($t),($h),($o),($v)));
	}' unless defined(&bus_space_write_stream_4);
	eval 'sub bus_space_write_stream_8 {
	    my($t, $h, $o, $v) = @_;
    	    eval q( &__bs_ws_s(8,($t),($h),($o),($v)));
	}' unless defined(&bus_space_write_stream_8);
    }
    eval 'sub bus_space_write_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wm,1,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wm,2,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wm,4,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_multi_4);
    eval 'sub bus_space_write_multi_8 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wm,8,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_multi_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_write_multi_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wm,1,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_multi_stream_1);
	eval 'sub bus_space_write_multi_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wm,2,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_multi_stream_2);
	eval 'sub bus_space_write_multi_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wm,4,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_multi_stream_4);
	eval 'sub bus_space_write_multi_stream_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wm,8,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_multi_stream_8);
    }
    eval 'sub bus_space_write_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wr,1,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wr,2,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wr,4,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_region_4);
    eval 'sub bus_space_write_region_8 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &__bs_nonsingle( &wr,8,($t),($h),($o),($a),($c)));
    }' unless defined(&bus_space_write_region_8);
    if(defined(&__BUS_SPACE_HAS_STREAM_METHODS)) {
	eval 'sub bus_space_write_region_stream_1 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wr,1,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_region_stream_1);
	eval 'sub bus_space_write_region_stream_2 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wr,2,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_region_stream_2);
	eval 'sub bus_space_write_region_stream_4 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wr,4,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_region_stream_4);
	eval 'sub bus_space_write_region_stream_8 {
	    my($t, $h, $o, $a, $c) = @_;
    	    eval q( &__bs_nonsingle_s( &wr,8,($t),($h),($o),($a),($c)));
	}' unless defined(&bus_space_write_region_stream_8);
    }
    eval 'sub bus_space_set_multi_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sm,1,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sm,2,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sm,4,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_multi_4);
    eval 'sub bus_space_set_multi_8 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sm,8,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_multi_8);
    eval 'sub bus_space_set_region_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sr,1,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sr,2,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sr,4,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_region_4);
    eval 'sub bus_space_set_region_8 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &__bs_set( &sr,8,($t),($h),($o),($v),($c)));
    }' unless defined(&bus_space_set_region_8);
    eval 'sub bus_space_copy_region_1 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &__bs_copy(1, $t, $h1, $o1, $h2, $o2, $c));
    }' unless defined(&bus_space_copy_region_1);
    eval 'sub bus_space_copy_region_2 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &__bs_copy(2, $t, $h1, $o1, $h2, $o2, $c));
    }' unless defined(&bus_space_copy_region_2);
    eval 'sub bus_space_copy_region_4 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &__bs_copy(4, $t, $h1, $o1, $h2, $o2, $c));
    }' unless defined(&bus_space_copy_region_4);
    eval 'sub bus_space_copy_region_8 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &__bs_copy(8, $t, $h1, $o1, $h2, $o2, $c));
    }' unless defined(&bus_space_copy_region_8);
    eval 'sub bus_space_copy_8 () {!!!  &bus_space_write_raw_multi_8  &not  &implemented !!!;}' unless defined(&bus_space_copy_8);
    eval 'sub bs_map_proto {
        my($f) = @_;
	    eval q(\'int\'  &__bs_c($f, &_bs_map) ( &void * &t,  &bus_addr_t  &addr,  &bus_size_t  &size, \'int\'  &cacheable,  &bus_space_handle_t * &bshp););
    }' unless defined(&bs_map_proto);
    eval 'sub bs_unmap_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_unmap) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &size););
    }' unless defined(&bs_unmap_proto);
    eval 'sub bs_subregion_proto {
        my($f) = @_;
	    eval q(\'int\'  &__bs_c($f, &_bs_subregion) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &bus_size_t  &size,  &bus_space_handle_t * &nbshp););
    }' unless defined(&bs_subregion_proto);
    eval 'sub bs_alloc_proto {
        my($f) = @_;
	    eval q(\'int\'  &__bs_c($f, &_bs_alloc) ( &void * &t,  &bus_addr_t  &rstart,  &bus_addr_t  &rend,  &bus_size_t  &size,  &bus_size_t  &align,  &bus_size_t  &boundary, \'int\'  &cacheable,  &bus_addr_t * &addrp,  &bus_space_handle_t * &bshp););
    }' unless defined(&bs_alloc_proto);
    eval 'sub bs_free_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_free) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &size););
    }' unless defined(&bs_free_proto);
    eval 'sub bs_vaddr_proto {
        my($f) = @_;
	    eval q( &void *  &__bs_c($f, &_bs_vaddr) ( &void * &t,  &bus_space_handle_t  &bsh););
    }' unless defined(&bs_vaddr_proto);
    eval 'sub bs_mmap_proto {
        my($f) = @_;
	    eval q( &paddr_t  &__bs_c($f, &_bs_mmap) ( &void *,  &bus_addr_t,  &off_t, \'int\', \'int\'););
    }' unless defined(&bs_mmap_proto);
    eval 'sub bs_barrier_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_barrier) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &bus_size_t  &len, \'int\'  &flags););
    }' unless defined(&bs_barrier_proto);
    eval 'sub bs_r_1_proto {
        my($f) = @_;
	    eval q( &u_int8_t  &__bs_c($f, &_bs_r_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset););
    }' unless defined(&bs_r_1_proto);
    eval 'sub bs_r_2_proto {
        my($f) = @_;
	    eval q( &u_int16_t  &__bs_c($f, &_bs_r_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset););
    }' unless defined(&bs_r_2_proto);
    eval 'sub bs_r_4_proto {
        my($f) = @_;
	    eval q( &u_int32_t  &__bs_c($f, &_bs_r_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset););
    }' unless defined(&bs_r_4_proto);
    eval 'sub bs_r_8_proto {
        my($f) = @_;
	    eval q( &u_int64_t  &__bs_c($f, &_bs_r_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset););
    }' unless defined(&bs_r_8_proto);
    eval 'sub bs_w_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_w_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int8_t  &value););
    }' unless defined(&bs_w_1_proto);
    eval 'sub bs_w_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_w_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int16_t  &value););
    }' unless defined(&bs_w_2_proto);
    eval 'sub bs_w_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_w_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int32_t  &value););
    }' unless defined(&bs_w_4_proto);
    eval 'sub bs_w_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_w_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int64_t  &value););
    }' unless defined(&bs_w_8_proto);
    eval 'sub bs_rm_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_rm_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int8_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rm_1_proto);
    eval 'sub bs_rm_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_rm_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int16_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rm_2_proto);
    eval 'sub bs_rm_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_rm_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int32_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rm_4_proto);
    eval 'sub bs_rm_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_rm_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int64_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rm_8_proto);
    eval 'sub bs_wm_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_wm_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int8_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wm_1_proto);
    eval 'sub bs_wm_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_wm_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int16_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wm_2_proto);
    eval 'sub bs_wm_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_wm_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int32_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wm_4_proto);
    eval 'sub bs_wm_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_wm_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int64_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wm_8_proto);
    eval 'sub bs_rr_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_rr_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int8_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rr_1_proto);
    eval 'sub bs_rr_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_rr_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int16_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rr_2_proto);
    eval 'sub bs_rr_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_rr_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int32_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rr_4_proto);
    eval 'sub bs_rr_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_rr_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int64_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_rr_8_proto);
    eval 'sub bs_wr_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_wr_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int8_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wr_1_proto);
    eval 'sub bs_wr_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_wr_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int16_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wr_2_proto);
    eval 'sub bs_wr_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_wr_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int32_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wr_4_proto);
    eval 'sub bs_wr_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f,  &_bs_wr_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &const  &u_int64_t * &addr,  &bus_size_t  &count););
    }' unless defined(&bs_wr_8_proto);
    eval 'sub bs_sm_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sm_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int8_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sm_1_proto);
    eval 'sub bs_sm_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sm_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int16_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sm_2_proto);
    eval 'sub bs_sm_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sm_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int32_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sm_4_proto);
    eval 'sub bs_sm_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sm_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int64_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sm_8_proto);
    eval 'sub bs_sr_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sr_1) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int8_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sr_1_proto);
    eval 'sub bs_sr_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sr_2) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int16_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sr_2_proto);
    eval 'sub bs_sr_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sr_4) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int32_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sr_4_proto);
    eval 'sub bs_sr_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_sr_8) ( &void * &t,  &bus_space_handle_t  &bsh,  &bus_size_t  &offset,  &u_int64_t  &value,  &bus_size_t  &count););
    }' unless defined(&bs_sr_8_proto);
    eval 'sub bs_c_1_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_c_1) ( &void * &t,  &bus_space_handle_t  &bsh1,  &bus_size_t  &offset1,  &bus_space_handle_t  &bsh2,  &bus_size_t  &offset2,  &bus_size_t  &count););
    }' unless defined(&bs_c_1_proto);
    eval 'sub bs_c_2_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_c_2) ( &void * &t,  &bus_space_handle_t  &bsh1,  &bus_size_t  &offset1,  &bus_space_handle_t  &bsh2,  &bus_size_t  &offset2,  &bus_size_t  &count););
    }' unless defined(&bs_c_2_proto);
    eval 'sub bs_c_4_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_c_4) ( &void * &t,  &bus_space_handle_t  &bsh1,  &bus_size_t  &offset1,  &bus_space_handle_t  &bsh2,  &bus_size_t  &offset2,  &bus_size_t  &count););
    }' unless defined(&bs_c_4_proto);
    eval 'sub bs_c_8_proto {
        my($f) = @_;
	    eval q( &void  &__bs_c($f, &_bs_c_8) ( &void * &t,  &bus_space_handle_t  &bsh1,  &bus_size_t  &offset1,  &bus_space_handle_t  &bsh2,  &bus_size_t  &offset2,  &bus_size_t  &count););
    }' unless defined(&bs_c_8_proto);
    eval 'sub bs_protos {
        my($f) = @_;
	    eval q( &bs_map_proto($f);  &bs_unmap_proto($f);  &bs_subregion_proto($f);  &bs_alloc_proto($f);  &bs_free_proto($f);  &bs_vaddr_proto($f);  &bs_mmap_proto($f);  &bs_barrier_proto($f);  &bs_r_1_proto($f);  &bs_r_2_proto($f);  &bs_r_4_proto($f);  &bs_r_8_proto($f);  &bs_w_1_proto($f);  &bs_w_2_proto($f);  &bs_w_4_proto($f);  &bs_w_8_proto($f);  &bs_rm_1_proto($f);  &bs_rm_2_proto($f);  &bs_rm_4_proto($f);  &bs_rm_8_proto($f);  &bs_wm_1_proto($f);  &bs_wm_2_proto($f);  &bs_wm_4_proto($f);  &bs_wm_8_proto($f);  &bs_rr_1_proto($f);  &bs_rr_2_proto($f);  &bs_rr_4_proto($f);  &bs_rr_8_proto($f);  &bs_wr_1_proto($f);  &bs_wr_2_proto($f);  &bs_wr_4_proto($f);  &bs_wr_8_proto($f);  &bs_sm_1_proto($f);  &bs_sm_2_proto($f);  &bs_sm_4_proto($f);  &bs_sm_8_proto($f);  &bs_sr_1_proto($f);  &bs_sr_2_proto($f);  &bs_sr_4_proto($f);  &bs_sr_8_proto($f);  &bs_c_1_proto($f);  &bs_c_2_proto($f);  &bs_c_4_proto($f);  &bs_c_8_proto($f););
    }' unless defined(&bs_protos);
    eval 'sub BUS_SPACE_ALIGNED_POINTER {
        my($p, $t) = @_;
	    eval q( &ALIGNED_POINTER($p, $t));
    }' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_STREAMING () {0x8;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_READ () {0x100;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x200;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_NOCACHE () {0x400;}' unless defined(&BUS_DMA_NOCACHE);
    eval 'sub ARM32_DMAMAP_COHERENT () {0x10000;}' unless defined(&ARM32_DMAMAP_COHERENT);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub BUS_DMA_TAG_VALID {
        my($t) = @_;
	    eval q((($t) != ( &bus_dma_tag_t)0));
    }' unless defined(&BUS_DMA_TAG_VALID);
    eval 'sub bus_dmamap_create {
        my($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        my($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        my($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        my($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        my($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        my($t, $p, $o, $l, $ops) = @_;
	    eval q(( &void)(($t)-> &_dmamap_sync ? (*($t)-> &_dmamap_sync)(($t), ($p), ($o), ($l), ($ops)) : ( &void)0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        my($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        my($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        my($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        my($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        my($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    if(defined(&_ARM32_BUS_DMA_PRIVATE)) {
	eval 'sub ARM32_BUFTYPE_INVALID () {0;}' unless defined(&ARM32_BUFTYPE_INVALID);
	eval 'sub ARM32_BUFTYPE_LINEAR () {1;}' unless defined(&ARM32_BUFTYPE_LINEAR);
	eval 'sub ARM32_BUFTYPE_MBUF () {2;}' unless defined(&ARM32_BUFTYPE_MBUF);
	eval 'sub ARM32_BUFTYPE_UIO () {3;}' unless defined(&ARM32_BUFTYPE_UIO);
	eval 'sub ARM32_BUFTYPE_RAW () {4;}' unless defined(&ARM32_BUFTYPE_RAW);
    }
    eval 'sub bus_space_read_raw_multi_8 () {!!!  &bus_space_read_raw_multi_8  &not  &implemented !!!;}' unless defined(&bus_space_read_raw_multi_8);
    eval 'sub bus_space_write_raw_multi_8 () {!!!  &bus_space_write_raw_multi_8  &not  &implemented !!!;}' unless defined(&bus_space_write_raw_multi_8);
    eval 'sub bus_space_read_raw_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_2(($t), ($h), ($o), ( &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_read_raw_region_2);
    eval 'sub bus_space_read_raw_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_region_4(($t), ($h), ($o), ( &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_read_raw_region_4);
    if(0) {
	eval 'sub bus_space_read_raw_region_8 () {!!!  &bus_space_read_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_read_raw_region_8);
    }
    eval 'sub bus_space_write_raw_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_2(($t), ($h), ($o), ( &const  &u_int16_t *)($a), ($c) >> 1));
    }' unless defined(&bus_space_write_raw_region_2);
    eval 'sub bus_space_write_raw_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_region_4(($t), ($h), ($o), ( &const  &u_int32_t *)($a), ($c) >> 2));
    }' unless defined(&bus_space_write_raw_region_4);
    if(0) {
	eval 'sub bus_space_write_raw_region_8 () {!!!  &bus_space_write_raw_region_8  &unimplemented !!!;}' unless defined(&bus_space_write_raw_region_8);
    }
}
1;
