require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&XGE_PIF_BAR)) {
    sub XGE_PIF_BAR () {	0x10;}
}
unless(defined(&XGE_TXP_BAR)) {
    sub XGE_TXP_BAR () {	0x18;}
}
unless(defined(&DCSRB)) {
    sub DCSRB {
	my($x) = @_;
	eval q((0x+($x)));
    }
}
unless(defined(&PCIXB)) {
    sub PCIXB {
	my($x) = @_;
	eval q((0x800+($x)));
    }
}
unless(defined(&TDMAB)) {
    sub TDMAB {
	my($x) = @_;
	eval q((0x1000+($x)));
    }
}
unless(defined(&RDMAB)) {
    sub RDMAB {
	my($x) = @_;
	eval q((0x1800+($x)));
    }
}
unless(defined(&MACRB)) {
    sub MACRB {
	my($x) = @_;
	eval q((0x2000+($x)));
    }
}
unless(defined(&RLDRB)) {
    sub RLDRB {
	my($x) = @_;
	eval q((0x2800+($x)));
    }
}
unless(defined(&XGXSB)) {
    sub XGXSB {
	my($x) = @_;
	eval q((0x3000+($x)));
    }
}
unless(defined(&GENERAL_INT_STATUS)) {
    sub GENERAL_INT_STATUS () {	 &DCSRB(0x);}
}
unless(defined(&GENERAL_INT_MASK)) {
    sub GENERAL_INT_MASK () {	 &DCSRB(0x8);}
}
unless(defined(&SW_RESET)) {
    sub SW_RESET () {	 &DCSRB(0x100);}
}
unless(defined(&XGXS_RESET)) {
    sub XGXS_RESET {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&ADAPTER_STATUS)) {
    sub ADAPTER_STATUS () {	 &DCSRB(0x108);}
}
unless(defined(&TDMA_READY)) {
    sub TDMA_READY () {	(1<<63);}
}
unless(defined(&RDMA_READY)) {
    sub RDMA_READY () {	(1<<62);}
}
unless(defined(&PFC_READY)) {
    sub PFC_READY () {	(1<<61);}
}
unless(defined(&TMAC_BUF_EMPTY)) {
    sub TMAC_BUF_EMPTY () {	(1<<60);}
}
unless(defined(&PIC_QUIESCENT)) {
    sub PIC_QUIESCENT () {	(1<<58);}
}
unless(defined(&RMAC_REMOTE_FAULT)) {
    sub RMAC_REMOTE_FAULT () {	(1<<57);}
}
unless(defined(&RMAC_LOCAL_FAULT)) {
    sub RMAC_LOCAL_FAULT () {	(1<<56);}
}
unless(defined(&MC_DRAM_READY)) {
    sub MC_DRAM_READY () {	(1<<39);}
}
unless(defined(&MC_QUEUES_READY)) {
    sub MC_QUEUES_READY () {	(1<<38);}
}
unless(defined(&M_PLL_LOCK)) {
    sub M_PLL_LOCK () {	(1<<33);}
}
unless(defined(&P_PLL_LOCK)) {
    sub P_PLL_LOCK () {	(1<<32);}
}
unless(defined(&ADAPTER_CONTROL)) {
    sub ADAPTER_CONTROL () {	 &DCSRB(0x110);}
}
unless(defined(&ADAPTER_EN)) {
    sub ADAPTER_EN () {	(1<<56);}
}
unless(defined(&EOI_TX_ON)) {
    sub EOI_TX_ON () {	(1<<48);}
}
unless(defined(&LED_ON)) {
    sub LED_ON () {	(1<<40);}
}
unless(defined(&WAIT_INT_EN)) {
    sub WAIT_INT_EN () {	(1<<15);}
}
unless(defined(&ECC_ENABLE_N)) {
    sub ECC_ENABLE_N () {	(1<<8);}
}
unless(defined(&QUIESCENT)) {
    sub QUIESCENT () {	( &TDMA_READY| &RDMA_READY| &PFC_READY| &TMAC_BUF_EMPTY|  &PIC_QUIESCENT| &MC_DRAM_READY| &MC_QUEUES_READY| &M_PLL_LOCK| &P_PLL_LOCK);}
}
unless(defined(&QUIESCENT_BMSK)) {
    sub QUIESCENT_BMSK () {	"\177\20b\x3fTDMA_READY\0b\x3eRDMA_READY\0b\x3dPFC_READY\0" "b\x3cTMAC_BUF_EMPTY\0b\x3aPIC_QUIESCENT\0\x39RMAC_REMOTE_FAULT\0" "b\x38RMAC_LOCAL_FAULT\0b\x27MC_DRAM_READY\0b\x26MC_QUEUES_READY\0" "b\x21M_PLL_LOCK\0b\x20P_PLL_LOCK";}
}
unless(defined(&PIC_INT_STATUS)) {
    sub PIC_INT_STATUS () {	 &PCIXB(0);}
}
unless(defined(&PIC_INT_MASK)) {
    sub PIC_INT_MASK () {	 &PCIXB(0x8);}
}
unless(defined(&TXPIC_INT_MASK)) {
    sub TXPIC_INT_MASK () {	 &PCIXB(0x18);}
}
unless(defined(&RXPIC_INT_MASK)) {
    sub RXPIC_INT_MASK () {	 &PCIXB(0x30);}
}
unless(defined(&FLASH_INT_MASK)) {
    sub FLASH_INT_MASK () {	 &PCIXB(0x48);}
}
unless(defined(&MDIO_INT_MASK)) {
    sub MDIO_INT_MASK () {	 &PCIXB(0x60);}
}
unless(defined(&IIC_INT_MASK)) {
    sub IIC_INT_MASK () {	 &PCIXB(0x78);}
}
unless(defined(&GPIO_INT_MASK)) {
    sub GPIO_INT_MASK () {	 &PCIXB(0x98);}
}
unless(defined(&TX_TRAFFIC_INT)) {
    sub TX_TRAFFIC_INT () {	 &PCIXB(0xe0);}
}
unless(defined(&TX_TRAFFIC_MASK)) {
    sub TX_TRAFFIC_MASK () {	 &PCIXB(0xe8);}
}
unless(defined(&RX_TRAFFIC_INT)) {
    sub RX_TRAFFIC_INT () {	 &PCIXB(0xf0);}
}
unless(defined(&RX_TRAFFIC_MASK)) {
    sub RX_TRAFFIC_MASK () {	 &PCIXB(0xf8);}
}
unless(defined(&PIC_CONTROL)) {
    sub PIC_CONTROL () {	 &PCIXB(0x100);}
}
unless(defined(&SWAPPER_CTRL)) {
    sub SWAPPER_CTRL () {	 &PCIXB(0x108);}
}
unless(defined(&PIF_R_FE)) {
    sub PIF_R_FE () {	(1<<63);}
}
unless(defined(&PIF_R_SE)) {
    sub PIF_R_SE () {	(1<<62);}
}
unless(defined(&PIF_W_FE)) {
    sub PIF_W_FE () {	(1<<55);}
}
unless(defined(&PIF_W_SE)) {
    sub PIF_W_SE () {	(1<<54);}
}
unless(defined(&TxP_FE)) {
    sub TxP_FE () {	(1<<47);}
}
unless(defined(&TxP_SE)) {
    sub TxP_SE () {	(1<<46);}
}
unless(defined(&TxD_R_FE)) {
    sub TxD_R_FE () {	(1<<45);}
}
unless(defined(&TxD_R_SE)) {
    sub TxD_R_SE () {	(1<<44);}
}
unless(defined(&TxD_W_FE)) {
    sub TxD_W_FE () {	(1<<43);}
}
unless(defined(&TxD_W_SE)) {
    sub TxD_W_SE () {	(1<<42);}
}
unless(defined(&TxF_R_FE)) {
    sub TxF_R_FE () {	(1<<41);}
}
unless(defined(&TxF_R_SE)) {
    sub TxF_R_SE () {	(1<<40);}
}
unless(defined(&RxD_R_FE)) {
    sub RxD_R_FE () {	(1<<31);}
}
unless(defined(&RxD_R_SE)) {
    sub RxD_R_SE () {	(1<<30);}
}
unless(defined(&RxD_W_FE)) {
    sub RxD_W_FE () {	(1<<29);}
}
unless(defined(&RxD_W_SE)) {
    sub RxD_W_SE () {	(1<<28);}
}
unless(defined(&RxF_W_FE)) {
    sub RxF_W_FE () {	(1<<27);}
}
unless(defined(&RxF_W_SE)) {
    sub RxF_W_SE () {	(1<<26);}
}
unless(defined(&XMSI_FE)) {
    sub XMSI_FE () {	(1<<23);}
}
unless(defined(&XMSI_SE)) {
    sub XMSI_SE () {	(1<<22);}
}
unless(defined(&STATS_FE)) {
    sub STATS_FE () {	(1<<15);}
}
unless(defined(&STATS_SE)) {
    sub STATS_SE () {	(1<<14);}
}
unless(defined(&PIF_RD_SWAPPER_Fb)) {
    sub PIF_RD_SWAPPER_Fb () {	 &PCIXB(0x110);}
}
unless(defined(&SWAPPER_MAGIC)) {
    sub SWAPPER_MAGIC () {	8.19855292164869e+16;}
}
unless(defined(&STAT_CFG)) {
    sub STAT_CFG () {	 &PCIXB(0x1d0);}
}
unless(defined(&STAT_ADDR)) {
    sub STAT_ADDR () {	 &PCIXB(0x1d8);}
}
unless(defined(&MDIO_CONTROL)) {
    sub MDIO_CONTROL () {	 &PCIXB(0x1e0);}
}
unless(defined(&DTX_CONTROL)) {
    sub DTX_CONTROL () {	 &PCIXB(0x1e8);}
}
unless(defined(&I2C_CONTROL)) {
    sub I2C_CONTROL () {	 &PCIXB(0x1f0);}
}
unless(defined(&GPIO_CONTROL)) {
    sub GPIO_CONTROL () {	 &PCIXB(0x1f8);}
}
unless(defined(&TXDMA_INT_MASK)) {
    sub TXDMA_INT_MASK () {	 &TDMAB(0x8);}
}
unless(defined(&PFC_ERR_MASK)) {
    sub PFC_ERR_MASK () {	 &TDMAB(0x18);}
}
unless(defined(&TDA_ERR_MASK)) {
    sub TDA_ERR_MASK () {	 &TDMAB(0x30);}
}
unless(defined(&PCC_ERR_MASK)) {
    sub PCC_ERR_MASK () {	 &TDMAB(0x48);}
}
unless(defined(&TTI_ERR_MASK)) {
    sub TTI_ERR_MASK () {	 &TDMAB(0x60);}
}
unless(defined(&LSO_ERR_MASK)) {
    sub LSO_ERR_MASK () {	 &TDMAB(0x78);}
}
unless(defined(&TPA_ERR_MASK)) {
    sub TPA_ERR_MASK () {	 &TDMAB(0x90);}
}
unless(defined(&SM_ERR_MASK)) {
    sub SM_ERR_MASK () {	 &TDMAB(0xa8);}
}
unless(defined(&TX_FIFO_P0)) {
    sub TX_FIFO_P0 () {	 &TDMAB(0x108);}
}
unless(defined(&TX_FIFO_P1)) {
    sub TX_FIFO_P1 () {	 &TDMAB(0x110);}
}
unless(defined(&TX_FIFO_P2)) {
    sub TX_FIFO_P2 () {	 &TDMAB(0x118);}
}
unless(defined(&TX_FIFO_P3)) {
    sub TX_FIFO_P3 () {	 &TDMAB(0x120);}
}
unless(defined(&TX_FIFO_ENABLE)) {
    sub TX_FIFO_ENABLE () {	(1<<63);}
}
unless(defined(&TX_FIFO_NUM0)) {
    sub TX_FIFO_NUM0 {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 56));
    }
}
unless(defined(&TX_FIFO_LEN0)) {
    sub TX_FIFO_LEN0 {
	my($x) = @_;
	eval q((( &uint64_t)(($x)-1) << 32));
    }
}
unless(defined(&TX_FIFO_NUM1)) {
    sub TX_FIFO_NUM1 {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 24));
    }
}
unless(defined(&TX_FIFO_LEN1)) {
    sub TX_FIFO_LEN1 {
	my($x) = @_;
	eval q((( &uint64_t)(($x)-1) << 0));
    }
}
unless(defined(&TTI_COMMAND_MEM)) {
    sub TTI_COMMAND_MEM () {	 &TDMAB(0x150);}
}
unless(defined(&TTI_CMD_MEM_WE)) {
    sub TTI_CMD_MEM_WE () {	(1<<56);}
}
unless(defined(&TTI_CMD_MEM_STROBE)) {
    sub TTI_CMD_MEM_STROBE () {	(1<<48);}
}
unless(defined(&TTI_DATA1_MEM)) {
    sub TTI_DATA1_MEM () {	 &TDMAB(0x158);}
}
unless(defined(&TX_TIMER_VAL)) {
    sub TX_TIMER_VAL {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&TX_TIMER_AC)) {
    sub TX_TIMER_AC () {	(1<<25);}
}
unless(defined(&TX_TIMER_CI)) {
    sub TX_TIMER_CI () {	(1<<24);}
}
unless(defined(&TX_URNG_A)) {
    sub TX_URNG_A {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 16));
    }
}
unless(defined(&TX_URNG_B)) {
    sub TX_URNG_B {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 8));
    }
}
unless(defined(&TX_URNG_C)) {
    sub TX_URNG_C {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 0));
    }
}
unless(defined(&TTI_DATA2_MEM)) {
    sub TTI_DATA2_MEM () {	 &TDMAB(0x160);}
}
unless(defined(&TX_UFC_A)) {
    sub TX_UFC_A {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 48));
    }
}
unless(defined(&TX_UFC_B)) {
    sub TX_UFC_B {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&TX_UFC_C)) {
    sub TX_UFC_C {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 16));
    }
}
unless(defined(&TX_UFC_D)) {
    sub TX_UFC_D {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 0));
    }
}
unless(defined(&TX_PA_CFG)) {
    sub TX_PA_CFG () {	 &TDMAB(0x168);}
}
unless(defined(&TX_PA_CFG_IFR)) {
    sub TX_PA_CFG_IFR () {	(1<<62);}
}
unless(defined(&TX_PA_CFG_ISO)) {
    sub TX_PA_CFG_ISO () {	(1<<61);}
}
unless(defined(&TX_PA_CFG_ILC)) {
    sub TX_PA_CFG_ILC () {	(1<<60);}
}
unless(defined(&TX_PA_CFG_ILE)) {
    sub TX_PA_CFG_ILE () {	(1<<57);}
}
if(defined(&notdef)) {
}
unless(defined(&TXDLOFF1)) {
    sub TXDLOFF1 {
	my($x) = @_;
	eval q((16*($x)));
    }
}
unless(defined(&TXDLOFF2)) {
    sub TXDLOFF2 {
	my($x) = @_;
	eval q((16*($x)+8));
    }
}
unless(defined(&TXDL_NUMTXD)) {
    sub TXDL_NUMTXD {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 56));
    }
}
unless(defined(&TXDL_LGC_FIRST)) {
    sub TXDL_LGC_FIRST () {	(1 << 49);}
}
unless(defined(&TXDL_LGC_LAST)) {
    sub TXDL_LGC_LAST () {	(1 << 48);}
}
unless(defined(&TXDL_SFF)) {
    sub TXDL_SFF () {	(1 << 40);}
}
unless(defined(&TXDL_PAR)) {
    sub TXDL_PAR () {	0;}
}
unless(defined(&TXDL_LCR)) {
    sub TXDL_LCR () {	8;}
}
unless(defined(&TXD_CTL1_OWN)) {
    sub TXD_CTL1_OWN () {	(1 << 56);}
}
unless(defined(&TXD_CTL1_GCF)) {
    sub TXD_CTL1_GCF () {	(1 << 41);}
}
unless(defined(&TXD_CTL1_GCL)) {
    sub TXD_CTL1_GCL () {	(1 << 40);}
}
unless(defined(&TXD_CTL1_LSO)) {
    sub TXD_CTL1_LSO () {	(1 << 33);}
}
unless(defined(&TXD_CTL1_COF)) {
    sub TXD_CTL1_COF () {	(1 << 32);}
}
unless(defined(&TXD_CTL1_MSS)) {
    sub TXD_CTL1_MSS {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 16));
    }
}
unless(defined(&TXD_CTL2_INTLST)) {
    sub TXD_CTL2_INTLST () {	(1 << 16);}
}
unless(defined(&TXD_CTL2_UTIL)) {
    sub TXD_CTL2_UTIL () {	(1 << 17);}
}
unless(defined(&TXD_CTL2_CIPv4)) {
    sub TXD_CTL2_CIPv4 () {	(1 << 58);}
}
unless(defined(&TXD_CTL2_CTCP)) {
    sub TXD_CTL2_CTCP () {	(1 << 57);}
}
unless(defined(&TXD_CTL2_CUDP)) {
    sub TXD_CTL2_CUDP () {	(1 << 56);}
}
unless(defined(&RXDMA_INT_MASK)) {
    sub RXDMA_INT_MASK () {	 &RDMAB(0x8);}
}
unless(defined(&RDA_ERR_MASK)) {
    sub RDA_ERR_MASK () {	 &RDMAB(0x18);}
}
unless(defined(&RC_ERR_MASK)) {
    sub RC_ERR_MASK () {	 &RDMAB(0x30);}
}
unless(defined(&PRC_PCIX_ERR_MASK)) {
    sub PRC_PCIX_ERR_MASK () {	 &RDMAB(0x48);}
}
unless(defined(&RPA_ERR_MASK)) {
    sub RPA_ERR_MASK () {	 &RDMAB(0x60);}
}
unless(defined(&RTI_ERR_MASK)) {
    sub RTI_ERR_MASK () {	 &RDMAB(0x78);}
}
unless(defined(&RX_QUEUE_PRIORITY)) {
    sub RX_QUEUE_PRIORITY () {	 &RDMAB(0x100);}
}
unless(defined(&RX_W_ROUND_ROBIN_0)) {
    sub RX_W_ROUND_ROBIN_0 () {	 &RDMAB(0x108);}
}
unless(defined(&RX_W_ROUND_ROBIN_1)) {
    sub RX_W_ROUND_ROBIN_1 () {	 &RDMAB(0x110);}
}
unless(defined(&RX_W_ROUND_ROBIN_2)) {
    sub RX_W_ROUND_ROBIN_2 () {	 &RDMAB(0x118);}
}
unless(defined(&RX_W_ROUND_ROBIN_3)) {
    sub RX_W_ROUND_ROBIN_3 () {	 &RDMAB(0x120);}
}
unless(defined(&RX_W_ROUND_ROBIN_4)) {
    sub RX_W_ROUND_ROBIN_4 () {	 &RDMAB(0x128);}
}
unless(defined(&PRC_RXD0_0)) {
    sub PRC_RXD0_0 () {	 &RDMAB(0x130);}
}
unless(defined(&PRC_CTRL_0)) {
    sub PRC_CTRL_0 () {	 &RDMAB(0x170);}
}
unless(defined(&RC_IN_SVC)) {
    sub RC_IN_SVC () {	(1 << 56);}
}
unless(defined(&RING_MODE_1)) {
    sub RING_MODE_1 () {	(0 << 48);}
}
unless(defined(&RING_MODE_3)) {
    sub RING_MODE_3 () {	(1 << 48);}
}
unless(defined(&RING_MODE_5)) {
    sub RING_MODE_5 () {	(2 << 48);}
}
unless(defined(&RC_NO_SNOOP_D)) {
    sub RC_NO_SNOOP_D () {	(1 << 41);}
}
unless(defined(&RC_NO_SNOOP_B)) {
    sub RC_NO_SNOOP_B () {	(1 << 40);}
}
unless(defined(&PRC_ALARM_ACTION)) {
    sub PRC_ALARM_ACTION () {	 &RDMAB(0x1b0);}
}
unless(defined(&RTI_COMMAND_MEM)) {
    sub RTI_COMMAND_MEM () {	 &RDMAB(0x1b8);}
}
unless(defined(&RTI_CMD_MEM_WE)) {
    sub RTI_CMD_MEM_WE () {	(1 << 56);}
}
unless(defined(&RTI_CMD_MEM_STROBE)) {
    sub RTI_CMD_MEM_STROBE () {	(1 << 48);}
}
unless(defined(&RTI_DATA1_MEM)) {
    sub RTI_DATA1_MEM () {	 &RDMAB(0x1c0);}
}
unless(defined(&RX_TIMER_VAL)) {
    sub RX_TIMER_VAL {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&RX_TIMER_AC)) {
    sub RX_TIMER_AC () {	(1 << 25);}
}
unless(defined(&RX_URNG_A)) {
    sub RX_URNG_A {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 16));
    }
}
unless(defined(&RX_URNG_B)) {
    sub RX_URNG_B {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 8));
    }
}
unless(defined(&RX_URNG_C)) {
    sub RX_URNG_C {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 0));
    }
}
unless(defined(&RTI_DATA2_MEM)) {
    sub RTI_DATA2_MEM () {	 &RDMAB(0x1c8);}
}
unless(defined(&RX_UFC_A)) {
    sub RX_UFC_A {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 48));
    }
}
unless(defined(&RX_UFC_B)) {
    sub RX_UFC_B {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&RX_UFC_C)) {
    sub RX_UFC_C {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 16));
    }
}
unless(defined(&RX_UFC_D)) {
    sub RX_UFC_D {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 0));
    }
}
unless(defined(&RX_PA_CFG)) {
    sub RX_PA_CFG () {	 &RDMAB(0x1d0);}
}
unless(defined(&RX_MODE_1)) {
    sub RX_MODE_1 () {	1;}
}
unless(defined(&RX_MODE_3)) {
    sub RX_MODE_3 () {	3;}
}
unless(defined(&RX_MODE_5)) {
    sub RX_MODE_5 () {	5;}
}
unless(defined(&NDESC_1BUFMODE)) {
    sub NDESC_1BUFMODE () {	127;}
}
unless(defined(&NDESC_5BUFMODE)) {
    sub NDESC_5BUFMODE () {	63;}
}
unless(defined(&XGE_PAGE)) {
    sub XGE_PAGE () {	4096;}
}
unless(defined(&RXD_MKCTL3)) {
    sub RXD_MKCTL3 {
	my($h,$bs3,$bs4) = @_;
	eval q(((( &uint64_t)($h) << 32) | (( &uint64_t)($bs3) << 16) | ( &uint64_t)($bs4)));
    }
}
unless(defined(&RXD_MKCTL2)) {
    sub RXD_MKCTL2 {
	my($bs0,$bs1,$bs2) = @_;
	eval q(((( &uint64_t)($bs0) << 48) | (( &uint64_t)($bs1) << 32) | (( &uint64_t)($bs2) << 16)));
    }
}
unless(defined(&RXD_CTL2_BUF0SIZ)) {
    sub RXD_CTL2_BUF0SIZ {
	my($x) = @_;
	eval q(((($x) >> 48) & 0xffff));
    }
}
unless(defined(&RXD_CTL2_BUF1SIZ)) {
    sub RXD_CTL2_BUF1SIZ {
	my($x) = @_;
	eval q(((($x) >> 32) & 0xffff));
    }
}
unless(defined(&RXD_CTL2_BUF2SIZ)) {
    sub RXD_CTL2_BUF2SIZ {
	my($x) = @_;
	eval q(((($x) >> 16) & 0xffff));
    }
}
unless(defined(&RXD_CTL3_BUF3SIZ)) {
    sub RXD_CTL3_BUF3SIZ {
	my($x) = @_;
	eval q(((($x) >> 16) & 0xffff));
    }
}
unless(defined(&RXD_CTL3_BUF4SIZ)) {
    sub RXD_CTL3_BUF4SIZ {
	my($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&RXD_CTL1_OWN)) {
    sub RXD_CTL1_OWN () {	(1 << 56);}
}
unless(defined(&RXD_CTL1_XCODE)) {
    sub RXD_CTL1_XCODE {
	my($x) = @_;
	eval q(((($x) >> 48) & 0xf));
    }
}
unless(defined(&RXD_CTL1_X_OK)) {
    sub RXD_CTL1_X_OK () {	0;}
}
unless(defined(&RXD_CTL1_X_PERR)) {
    sub RXD_CTL1_X_PERR () {	1;}
}
unless(defined(&RXD_CTL1_X_ABORT)) {
    sub RXD_CTL1_X_ABORT () {	2;}
}
unless(defined(&RXD_CTL1_X_PA)) {
    sub RXD_CTL1_X_PA () {	3;}
}
unless(defined(&RXD_CTL1_X_RDA)) {
    sub RXD_CTL1_X_RDA () {	4;}
}
unless(defined(&RXD_CTL1_X_UP)) {
    sub RXD_CTL1_X_UP () {	5;}
}
unless(defined(&RXD_CTL1_X_FI)) {
    sub RXD_CTL1_X_FI () {	6;}
}
unless(defined(&RXD_CTL1_X_BSZ)) {
    sub RXD_CTL1_X_BSZ () {	7;}
}
unless(defined(&RXD_CTL1_X_ECC)) {
    sub RXD_CTL1_X_ECC () {	8;}
}
unless(defined(&RXD_CTL1_X_UNK)) {
    sub RXD_CTL1_X_UNK () {	15;}
}
unless(defined(&RXD_CTL1_PROTOS)) {
    sub RXD_CTL1_PROTOS {
	my($x) = @_;
	eval q(((($x) >> 32) & 0xff));
    }
}
unless(defined(&RXD_CTL1_P_VLAN)) {
    sub RXD_CTL1_P_VLAN () {	0x80;}
}
unless(defined(&RXD_CTL1_P_MSK)) {
    sub RXD_CTL1_P_MSK () {	0x60;}
}
unless(defined(&RXD_CTL1_P_DIX)) {
    sub RXD_CTL1_P_DIX () {	0x;}
}
unless(defined(&RXD_CTL1_P_LLC)) {
    sub RXD_CTL1_P_LLC () {	0x20;}
}
unless(defined(&RXD_CTL1_P_SNAP)) {
    sub RXD_CTL1_P_SNAP () {	0x40;}
}
unless(defined(&RXD_CTL1_P_IPX)) {
    sub RXD_CTL1_P_IPX () {	0x60;}
}
unless(defined(&RXD_CTL1_P_IPv4)) {
    sub RXD_CTL1_P_IPv4 () {	0x10;}
}
unless(defined(&RXD_CTL1_P_IPv6)) {
    sub RXD_CTL1_P_IPv6 () {	0x8;}
}
unless(defined(&RXD_CTL1_P_IPFRAG)) {
    sub RXD_CTL1_P_IPFRAG () {	0x4;}
}
unless(defined(&RXD_CTL1_P_TCP)) {
    sub RXD_CTL1_P_TCP () {	0x2;}
}
unless(defined(&RXD_CTL1_P_UDP)) {
    sub RXD_CTL1_P_UDP () {	0x1;}
}
unless(defined(&RXD_CTL1_L3CSUM)) {
    sub RXD_CTL1_L3CSUM {
	my($x) = @_;
	eval q(((($x) >> 16) & 0xffff));
    }
}
unless(defined(&RXD_CTL1_L4CSUM)) {
    sub RXD_CTL1_L4CSUM {
	my($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&RXD_CTL2_VLANTAG)) {
    sub RXD_CTL2_VLANTAG {
	my($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&MAC_INT_STATUS)) {
    sub MAC_INT_STATUS () {	 &MACRB(0x);}
}
unless(defined(&MAC_TMAC_INT)) {
    sub MAC_TMAC_INT () {	(1<<63);}
}
unless(defined(&MAC_RMAC_INT)) {
    sub MAC_RMAC_INT () {	(1<<62);}
}
unless(defined(&MAC_INT_MASK)) {
    sub MAC_INT_MASK () {	 &MACRB(0x8);}
}
unless(defined(&MAC_TMAC_ERR_MASK)) {
    sub MAC_TMAC_ERR_MASK () {	 &MACRB(0x18);}
}
unless(defined(&MAC_RMAC_ERR_REG)) {
    sub MAC_RMAC_ERR_REG () {	 &MACRB(0x28);}
}
unless(defined(&RMAC_LINK_STATE_CHANGE_INT)) {
    sub RMAC_LINK_STATE_CHANGE_INT () {	(1<<32);}
}
unless(defined(&MAC_RMAC_ERR_MASK)) {
    sub MAC_RMAC_ERR_MASK () {	 &MACRB(0x30);}
}
unless(defined(&MAC_CFG)) {
    sub MAC_CFG () {	 &MACRB(0x100);}
}
unless(defined(&TMAC_EN)) {
    sub TMAC_EN () {	(1<<63);}
}
unless(defined(&RMAC_EN)) {
    sub RMAC_EN () {	(1<<62);}
}
unless(defined(&UTILZATION_CALC_SEL)) {
    sub UTILZATION_CALC_SEL () {	(1<<61);}
}
unless(defined(&TMAC_LOOPBACK)) {
    sub TMAC_LOOPBACK () {	(1<<60);}
}
unless(defined(&TMAC_APPEND_PAD)) {
    sub TMAC_APPEND_PAD () {	(1<<59);}
}
unless(defined(&RMAC_STRIP_FCS)) {
    sub RMAC_STRIP_FCS () {	(1<<58);}
}
unless(defined(&RMAC_STRIP_PAD)) {
    sub RMAC_STRIP_PAD () {	(1<<57);}
}
unless(defined(&RMAC_PROM_EN)) {
    sub RMAC_PROM_EN () {	(1<<56);}
}
unless(defined(&RMAC_DISCARD_PFRM)) {
    sub RMAC_DISCARD_PFRM () {	(1<<55);}
}
unless(defined(&RMAC_BCAST_EN)) {
    sub RMAC_BCAST_EN () {	(1<<54);}
}
unless(defined(&RMAC_ALL_ADDR_EN)) {
    sub RMAC_ALL_ADDR_EN () {	(1<<53);}
}
unless(defined(&RMAC_MAX_PYLD_LEN)) {
    sub RMAC_MAX_PYLD_LEN () {	 &MACRB(0x110);}
}
unless(defined(&RMAC_PYLD_LEN)) {
    sub RMAC_PYLD_LEN {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 48));
    }
}
unless(defined(&RMAC_CFG_KEY)) {
    sub RMAC_CFG_KEY () {	 &MACRB(0x120);}
}
unless(defined(&RMAC_KEY_VALUE)) {
    sub RMAC_KEY_VALUE () {	(0x4c0d<<48);}
}
unless(defined(&RMAC_ADDR_CMD_MEM)) {
    sub RMAC_ADDR_CMD_MEM () {	 &MACRB(0x128);}
}
unless(defined(&RMAC_ADDR_CMD_MEM_WE)) {
    sub RMAC_ADDR_CMD_MEM_WE () {	(1<<56);}
}
unless(defined(&RMAC_ADDR_CMD_MEM_STR)) {
    sub RMAC_ADDR_CMD_MEM_STR () {	(1<<48);}
}
unless(defined(&RMAC_ADDR_CMD_MEM_OFF)) {
    sub RMAC_ADDR_CMD_MEM_OFF {
	my($x) = @_;
	eval q((( &uint64_t)($x) << 32));
    }
}
unless(defined(&MAX_MCAST_ADDR)) {
    sub MAX_MCAST_ADDR () {	64;}
}
unless(defined(&RMAC_ADDR_DATA0_MEM)) {
    sub RMAC_ADDR_DATA0_MEM () {	 &MACRB(0x130);}
}
unless(defined(&RMAC_ADDR_DATA1_MEM)) {
    sub RMAC_ADDR_DATA1_MEM () {	 &MACRB(0x138);}
}
unless(defined(&RMAC_PAUSE_CFG)) {
    sub RMAC_PAUSE_CFG () {	 &MACRB(0x150);}
}
unless(defined(&RMAC_PAUSE_GEN_EN)) {
    sub RMAC_PAUSE_GEN_EN () {	(1<<63);}
}
unless(defined(&RMAC_PAUSE_RCV_EN)) {
    sub RMAC_PAUSE_RCV_EN () {	(1<<62);}
}
unless(defined(&MC_INT_MASK)) {
    sub MC_INT_MASK () {	 &RLDRB(0x8);}
}
unless(defined(&MC_ERR_MASK)) {
    sub MC_ERR_MASK () {	 &RLDRB(0x18);}
}
unless(defined(&RX_QUEUE_CFG)) {
    sub RX_QUEUE_CFG () {	 &RLDRB(0x100);}
}
unless(defined(&MC_QUEUE)) {
    sub MC_QUEUE {
	my($q,$s) = @_;
	eval q((( &uint64_t)($s)<<(56-($q*8))));
    }
}
unless(defined(&MC_RLDRAM_MRS)) {
    sub MC_RLDRAM_MRS () {	 &RLDRB(0x108);}
}
unless(defined(&MC_QUEUE_SIZE_ENABLE)) {
    sub MC_QUEUE_SIZE_ENABLE () {	(1<<24);}
}
unless(defined(&MC_RLDRAM_MRS_ENABLE)) {
    sub MC_RLDRAM_MRS_ENABLE () {	(1<<16);}
}
unless(defined(&XGXS_INT_MASK)) {
    sub XGXS_INT_MASK () {	 &XGXSB(0x8);}
}
unless(defined(&XGXS_TXGXS_ERR_MASK)) {
    sub XGXS_TXGXS_ERR_MASK () {	 &XGXSB(0x18);}
}
unless(defined(&XGXS_RXGXS_ERR_MASK)) {
    sub XGXS_RXGXS_ERR_MASK () {	 &XGXSB(0x30);}
}
unless(defined(&XGXS_CFG)) {
    sub XGXS_CFG () {	 &XGXSB(0x100);}
}
1;
