require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_EM_OPENBSD_OS_H_)) {
    eval 'sub _EM_OPENBSD_OS_H_ () {1;}' unless defined(&_EM_OPENBSD_OS_H_);
    eval 'sub usec_delay {
        my($x) = @_;
	    eval q( &DELAY($x));
    }' unless defined(&usec_delay);
    eval 'sub msec_delay {
        my($x) = @_;
	    eval q( &DELAY(1000*($x)));
    }' unless defined(&msec_delay);
    eval 'sub msec_delay_irq {
        my($x) = @_;
	    eval q( &DELAY(1000*($x)));
    }' unless defined(&msec_delay_irq);
    eval 'sub MSGOUT {
        my($S, $A, $B) = @_;
	    eval q( &printf($S \\"\\\\n\\", $A, $B));
    }' unless defined(&MSGOUT);
    eval 'sub DEBUGFUNC {
        my($F) = @_;
	    eval q( &DEBUGOUT($F););
    }' unless defined(&DEBUGFUNC);
    if((defined(&DBG) ? &DBG : 0)) {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q( &printf($S \\"\\\\n\\"));
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A));
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B));
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C));
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q( &printf($S \\"\\\\n\\",$A,$B,$C,$D,$E,$F,$G));
	}' unless defined(&DEBUGOUT7);
    } else {
	eval 'sub DEBUGOUT {
	    my($S) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT);
	eval 'sub DEBUGOUT1 {
	    my($S,$A) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT1);
	eval 'sub DEBUGOUT2 {
	    my($S,$A,$B) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT2);
	eval 'sub DEBUGOUT3 {
	    my($S,$A,$B,$C) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT3);
	eval 'sub DEBUGOUT7 {
	    my($S,$A,$B,$C,$D,$E,$F,$G) = @_;
    	    eval q();
	}' unless defined(&DEBUGOUT7);
    }
    eval 'sub CMD_MEM_WRT_INVALIDATE () {0x10;}' unless defined(&CMD_MEM_WRT_INVALIDATE);
    eval 'sub E1000_WRITE_FLUSH {
        my($hw) = @_;
	    eval q( &E1000_READ_REG($hw,  &STATUS));
    }' unless defined(&E1000_WRITE_FLUSH);
    eval 'sub E1000_READ_OFFSET {
        my($hw, $offset) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, $offset));
    }' unless defined(&E1000_READ_OFFSET);
    eval 'sub E1000_WRITE_OFFSET {
        my($hw, $offset, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, $offset, $value));
    }' unless defined(&E1000_WRITE_OFFSET);
    eval 'sub E1000_REG_OFFSET {
        my($hw, $reg) = @_;
	    eval q((($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg));
    }' unless defined(&E1000_REG_OFFSET);
    eval 'sub E1000_READ_REG {
        my($hw, $reg) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg)));
    }' unless defined(&E1000_READ_REG);
    eval 'sub E1000_WRITE_REG {
        my($hw, $reg, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg), $value));
    }' unless defined(&E1000_WRITE_REG);
    eval 'sub E1000_READ_REG_ARRAY {
        my($hw, $reg, $index) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg) + (($index) << 2)));
    }' unless defined(&E1000_READ_REG_ARRAY);
    eval 'sub E1000_WRITE_REG_ARRAY {
        my($hw, $reg, $index, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg) + (($index) << 2), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY);
    eval 'sub E1000_READ_REG_ARRAY_DWORD () { &E1000_READ_REG_ARRAY;}' unless defined(&E1000_READ_REG_ARRAY_DWORD);
    eval 'sub E1000_WRITE_REG_ARRAY_DWORD () { &E1000_WRITE_REG_ARRAY;}' unless defined(&E1000_WRITE_REG_ARRAY_DWORD);
    eval 'sub E1000_WRITE_REG_ARRAY_BYTE {
        my($hw, $reg, $index, $value) = @_;
	    eval q( &bus_space_write_1((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg + $index), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY_BYTE);
    eval 'sub E1000_WRITE_REG_ARRAY_WORD {
        my($hw, $reg, $index, $value) = @_;
	    eval q( &bus_space_write_2((($hw)-> &back)-> &mem_bus_space_tag, (($hw)-> &back)-> &mem_bus_space_handle, (($hw)-> &mac_type >=  &em_82543 ?  &E1000_$reg :  &E1000_82542_$reg + ($index << 1)), $value));
    }' unless defined(&E1000_WRITE_REG_ARRAY_WORD);
    eval 'sub E1000_READ_ICH8_REG {
        my($hw, $reg) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &flash_bus_space_tag, (($hw)-> &back)-> &flash_bus_space_handle, $reg));
    }' unless defined(&E1000_READ_ICH8_REG);
    eval 'sub E1000_READ_ICH8_REG16 {
        my($hw, $reg) = @_;
	    eval q( &bus_space_read_2((($hw)-> &back)-> &flash_bus_space_tag, (($hw)-> &back)-> &flash_bus_space_handle, $reg));
    }' unless defined(&E1000_READ_ICH8_REG16);
    eval 'sub E1000_WRITE_ICH8_REG {
        my($hw, $reg, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &flash_bus_space_tag, (($hw)-> &back)-> &flash_bus_space_handle, $reg, $value));
    }' unless defined(&E1000_WRITE_ICH8_REG);
    eval 'sub E1000_WRITE_ICH8_REG16 {
        my($hw, $reg, $value) = @_;
	    eval q( &bus_space_write_2((($hw)-> &back)-> &flash_bus_space_tag, (($hw)-> &back)-> &flash_bus_space_handle, $reg, $value));
    }' unless defined(&E1000_WRITE_ICH8_REG16);
    eval 'sub em_io_read {
        my($hw, $port) = @_;
	    eval q( &bus_space_read_4((($hw)-> &back)-> &io_bus_space_tag, (($hw)-> &back)-> &io_bus_space_handle, ($port)));
    }' unless defined(&em_io_read);
    eval 'sub em_io_write {
        my($hw, $port, $value) = @_;
	    eval q( &bus_space_write_4((($hw)-> &back)-> &io_bus_space_tag, (($hw)-> &back)-> &io_bus_space_handle, ($port), ($value)));
    }' unless defined(&em_io_write);
    if(defined(&DEBUG)) {
	eval 'sub EM_KASSERT {
	    my($exp,$msg) = @_;
    	    eval q( &do {  &if (!($exp))  &panic $msg; }  &while (0));
	}' unless defined(&EM_KASSERT);
    } else {
	eval 'sub EM_KASSERT {
	    my($exp,$msg) = @_;
    	    eval q();
	}' unless defined(&EM_KASSERT);
    }
}
1;
