require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AMD64_CPU_H_)) {
    eval 'sub _AMD64_CPU_H_ () {1;}' unless defined(&_AMD64_CPU_H_);
    require 'machine/frame.ph';
    require 'machine/segments.ph';
    require 'machine/tss.ph';
    require 'machine/intrdefs.ph';
    require 'machine/cacheinfo.ph';
    require 'sys/device.ph';
    require 'sys/lock.ph';
    require 'sys/sched.ph';
    eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
    eval 'sub CI_DDB_SHOULDSTOP () {1;}' unless defined(&CI_DDB_SHOULDSTOP);
    eval 'sub CI_DDB_STOPPED () {2;}' unless defined(&CI_DDB_STOPPED);
    eval 'sub CI_DDB_ENTERDDB () {3;}' unless defined(&CI_DDB_ENTERDDB);
    eval 'sub CI_DDB_INDDB () {4;}' unless defined(&CI_DDB_INDDB);
    eval 'sub CPUF_BSP () {0x1;}' unless defined(&CPUF_BSP);
    eval 'sub CPUF_AP () {0x2;}' unless defined(&CPUF_AP);
    eval 'sub CPUF_SP () {0x4;}' unless defined(&CPUF_SP);
    eval 'sub CPUF_PRIMARY () {0x8;}' unless defined(&CPUF_PRIMARY);
    eval 'sub CPUF_PRESENT () {0x1000;}' unless defined(&CPUF_PRESENT);
    eval 'sub CPUF_RUNNING () {0x2000;}' unless defined(&CPUF_RUNNING);
    eval 'sub CPUF_PAUSE () {0x4000;}' unless defined(&CPUF_PAUSE);
    eval 'sub CPUF_GO () {0x8000;}' unless defined(&CPUF_GO);
    eval 'sub PROC_PC {
        my($p) = @_;
	    eval q((($p)-> ($p_md->{md_regs}->{tf_rip})));
    }' unless defined(&PROC_PC);
    eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
    eval 'sub CPU_INFO_FOREACH {
        my($cii, $ci) = @_;
	    eval q( &for ($cii = 0, $ci =  &cpu_info_list; $ci !=  &NULL; $ci =  ($ci->{ci_next})));
    }' unless defined(&CPU_INFO_FOREACH);
    eval 'sub CPU_INFO_UNIT {
        my($ci) = @_;
	    eval q((($ci)-> ($ci_dev->{dv_unit})));
    }' unless defined(&CPU_INFO_UNIT);
    if(defined( &MULTIPROCESSOR)) {
	eval 'sub X86_MAXPROCS () {32;}' unless defined(&X86_MAXPROCS);
	eval 'sub CPU_STARTUP {
	    my($_ci) = @_;
    	    eval q((($_ci)-> ($ci_func->{start})($_ci)));
	}' unless defined(&CPU_STARTUP);
	eval 'sub CPU_STOP {
	    my($_ci) = @_;
    	    eval q((($_ci)-> ($ci_func->{stop})($_ci)));
	}' unless defined(&CPU_STOP);
	eval 'sub CPU_START_CLEANUP {
	    my($_ci) = @_;
    	    eval q((($_ci)-> ($ci_func->{cleanup})($_ci)));
	}' unless defined(&CPU_START_CLEANUP);
	eval 'sub curcpu () {
	    eval q(({\'struct cpu_info\' * &__ci;  &asm  &volatile(\\"movq %%gs:8,%0\\" : \\"=r\\" ( &__ci));  &__ci;}));
	}' unless defined(&curcpu);
	eval 'sub cpu_number () {
	    eval q(( &curcpu()-> &ci_cpuid));
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	}' unless defined(&CPU_IS_PRIMARY);
    } else {
	eval 'sub X86_MAXPROCS () {1;}' unless defined(&X86_MAXPROCS);
	if(defined(&_KERNEL)) {
	    eval 'sub curcpu () {
	        eval q(( &cpu_info_primary));
	    }' unless defined(&curcpu);
	}
	eval 'sub cpu_number () {
	    eval q(0);
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q(1);
	}' unless defined(&CPU_IS_PRIMARY);
    }
    require 'machine/psl.ph';
    if(defined(&MULTIPROCESSOR)) {
	require 'sys/mplock.ph';
    }
    eval 'sub aston {
        my($p) = @_;
	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
    }' unless defined(&aston);
    eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
    eval 'sub curproc () { &curcpu()-> &ci_curproc;}' unless defined(&curproc);
    eval 'sub clockframe () { &intrframe;}' unless defined(&clockframe);
    eval 'sub CLKF_USERMODE {
        my($frame) = @_;
	    eval q( &USERMODE(($frame)-> &if_cs, ($frame)-> &if_rflags));
    }' unless defined(&CLKF_USERMODE);
    eval 'sub CLKF_PC {
        my($frame) = @_;
	    eval q((($frame)-> &if_rip));
    }' unless defined(&CLKF_PC);
    eval 'sub CLKF_INTR {
        my($frame) = @_;
	    eval q(( &curcpu()-> &ci_idepth > 1));
    }' unless defined(&CLKF_INTR);
    eval 'sub need_proftick {
        my($p) = @_;
	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &aston($p)));
    }' unless defined(&need_proftick);
    eval 'sub signotify {
        my($p) = @_;
	    eval q( &aston($p));
    }' unless defined(&signotify);
    eval 'sub DELAY {
        my($x) = @_;
	    eval q((* &delay_func)($x));
    }' unless defined(&DELAY);
    eval 'sub delay {
        my($x) = @_;
	    eval q((* &delay_func)($x));
    }' unless defined(&delay);
    eval 'sub microtime {
        my($tv) = @_;
	    eval q((* &microtime_func)($tv));
    }' unless defined(&microtime);
    if(defined(&_KERNEL)) {
    }
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_BIOS () {2;}' unless defined(&CPU_BIOS);
    eval 'sub CPU_BLK2CHR () {3;}' unless defined(&CPU_BLK2CHR);
    eval 'sub CPU_CHR2BLK () {4;}' unless defined(&CPU_CHR2BLK);
    eval 'sub CPU_ALLOWAPERTURE () {5;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_CPUVENDOR () {6;}' unless defined(&CPU_CPUVENDOR);
    eval 'sub CPU_CPUID () {7;}' unless defined(&CPU_CPUID);
    eval 'sub CPU_CPUFEATURE () {8;}' unless defined(&CPU_CPUFEATURE);
    eval 'sub CPU_APMWARN () {9;}' unless defined(&CPU_APMWARN);
    eval 'sub CPU_KBDRESET () {10;}' unless defined(&CPU_KBDRESET);
    eval 'sub CPU_APMHALT () {11;}' unless defined(&CPU_APMHALT);
    eval 'sub CPU_USERLDT () {12;}' unless defined(&CPU_USERLDT);
    eval 'sub CPU_MAXID () {13;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "bios",  &CTLTYPE_INT }, { "blk2chr",  &CTLTYPE_STRUCT }, { "chr2blk",  &CTLTYPE_STRUCT }, { "allowaperture",  &CTLTYPE_INT }, { "cpuvendor",  &CTLTYPE_STRING }, { "cpuid",  &CTLTYPE_INT }, { "cpufeature",  &CTLTYPE_INT }, { "apmwarn",  &CTLTYPE_INT }, { "kbdreset",  &CTLTYPE_INT }, { "apmhalt",  &CTLTYPE_INT }, { "userldt",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    eval 'sub CR4_DEFAULT () {( &CR4_PAE| &CR4_PGE| &CR4_PSE| &CR4_OSFXSR| &CR4_OSXMMEXCPT);}' unless defined(&CR4_DEFAULT);
}
1;
