.\" $Header: /cvs/XF4/xc/programs/fc-cache/fc-cache.man,v 1.1 2005/12/31 13:09:01 matthieu Exp $
.\"
.\"	transcript compatibility for postscript use.
.\"
.\"	synopsis:  .P! <file.ps>
.\"
.de P!
.fl
\!!1 setgray
.fl
\\&.\"
.fl
\!!0 setgray
.fl			\" force out current output buffer
\!!save /psv exch def currentpoint translate 0 0 moveto
\!!/showpage{}def
.fl			\" prolog
.sy sed -e 's/^/!/' \\$1\" bring in postscript file
\!!psv restore
.
.de pF
.ie     \\*(f1 .ds f1 \\n(.f
.el .ie \\*(f2 .ds f2 \\n(.f
.el .ie \\*(f3 .ds f3 \\n(.f
.el .ie \\*(f4 .ds f4 \\n(.f
.el .tm ? font overflow
.ft \\$1
..
.de fP
.ie     !\\*(f4 \{\
.	ft \\*(f4
.	ds f4\"
'	br \}
.el .ie !\\*(f3 \{\
.	ft \\*(f3
.	ds f3\"
'	br \}
.el .ie !\\*(f2 \{\
.	ft \\*(f2
.	ds f2\"
'	br \}
.el .ie !\\*(f1 \{\
.	ft \\*(f1
.	ds f1\"
'	br \}
.el .tm ? font underflow
..
.ds f1\"
.ds f2\"
.ds f3\"
.ds f4\"
'\" t 
.ta 8n 16n 24n 32n 40n 48n 56n 64n 72n  
.TH "fc-cache" "1" 
.SH "NAME" 
fc-cache \(em build font information cache files 
.SH "SYNOPSIS" 
.PP 
\fBfc-cache\fR [\fB-fsvV?\fP]  [\fB--force\fP]  [\fB--system-only\fP]  [\fB--verbose\fP]  [\fB--version\fP]  [\fB--help\fP]  [\fB\fIdirs\fR\fP]  
.SH "DESCRIPTION" 
.PP 
\fBfc-cache\fR scans the font directories on 
the system and builds font information cache files for 
applications using fontconfig for their font handling. 
.PP 
If directory arguments are not given, 
\fBfc-cache\fR uses each directory in the 
current font configuration. Each directory is scanned for 
font files readable by FreeType.  A cache is created which 
contains properties of each font and the associated filename. 
This cache is used to speed up application startup when using 
the fontconfig library. 
.SH "OPTIONS" 
.PP 
This program follows the usual GNU command line syntax, 
with long options starting with two dashes (`-').  A summary of 
options is included below. 
.IP "\fB-f\fP           \fB--force\fP         " 10 
Force re-generation of apparently up-to-date cache files, 
overriding the timestamp checking. 
.IP "\fB-s\fP           \fB--system-only\fP         " 10 
Only scan system-wide directories, omitting the places 
located in the user's home directory. 
.IP "\fB-v\fP           \fB--verbose\fP         " 10 
Display status information while busy. 
.IP "\fB-?\fP           \fB--help\fP         " 10 
Show summary of options. 
.IP "\fB-V\fP           \fB--version\fP         " 10 
Show version of the program and exit. 
.IP "\fB\fIdirs\fR\fP         " 10 
A list of directories to scan for fonts. 
.SH "FILES" 
.IP "\fBfonts.cache-1\fP" 10 
These files are generated by \fBfc-cache\fR             and contain maps from file names to font properties. They are 
read by the fontconfig library at application startup to locate 
appropriate fonts. 
.SH "SEE ALSO" 
.PP 
\fBfc-list\fR (1). 
.PP 
The fontconfig user's guide, in HTML format: 
\fB/usr/share/doc/fontconfig/fontconfig-user.html\fP. 
.SH "AUTHOR" 
.PP 
This manual page was written by Keith Packard 
keithp@keithp.com and Josselin Mouette joss@debian.org. 
.\" created by instant / docbook-to-man, Mon 27 Jun 2005, 16:55 
