require '_h2ph_pre.ph';

no warnings 'redefine';

require 'sys/types.ph';
require 'arm/cpufunc.ph';
if(defined(&_KERNEL)) {
    require 'arm/blockio.ph';
    eval 'sub WriteWord {
        local($a, $b) = @_;
	    eval q(*(( &volatile \'unsigned int\' *)($a)) = ($b));
    }' unless defined(&WriteWord);
    eval 'sub ReadWord {
        local($a) = @_;
	    eval q((*(( &volatile \'unsigned int\' *)($a))));
    }' unless defined(&ReadWord);
    eval 'sub WriteShort {
        local($a, $b) = @_;
	    eval q(*(( &volatile \'unsigned int\' *)($a)) = (($b) | (($b) << 16)));
    }' unless defined(&WriteShort);
    eval 'sub ReadShort {
        local($a) = @_;
	    eval q(((*(( &volatile \'unsigned int\' *)($a))) & 0xffff));
    }' unless defined(&ReadShort);
    eval 'sub WriteByte {
        local($a, $b) = @_;
	    eval q(*(( &volatile \'unsigned char\' *)($a)) = ($b));
    }' unless defined(&WriteByte);
    eval 'sub ReadByte {
        local($a) = @_;
	    eval q((*(( &volatile \'unsigned char\' *)($a))));
    }' unless defined(&ReadByte);
    eval 'sub inb {
        local($port) = @_;
	    eval q( &ReadByte(($port)));
    }' unless defined(&inb);
    eval 'sub outb {
        local($port, $byte) = @_;
	    eval q( &WriteByte(($port), ($byte)));
    }' unless defined(&outb);
    eval 'sub inw {
        local($port) = @_;
	    eval q( &ReadShort(($port)));
    }' unless defined(&inw);
    eval 'sub outw {
        local($port, $word) = @_;
	    eval q( &WriteShort(($port), ($word)));
    }' unless defined(&outw);
    eval 'sub inl {
        local($port) = @_;
	    eval q( &ReadWord(($port)));
    }' unless defined(&inl);
    eval 'sub outl {
        local($port, $lword) = @_;
	    eval q( &WriteWord(($port), ($lword)));
    }' unless defined(&outl);
}
1;
