################################################################################
#
#  mktests.PL -- generate test files for Devel::PPPort
#
################################################################################
#
#  $Revision: 1.1.1.1 $
#  $Author: millert $
#  $Date: 2005/01/15 21:16:45 $
#
################################################################################
#
#  Version 3.x, Copyright (C) 2004, Marcus Holland-Moritz.
#  Version 2.x, Copyright (C) 2001, Paul Marquess.
#  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#
################################################################################

use strict;
$^W = 1;
require "parts/ppptools.pl";

my $template = do { local $/; <DATA> };

my $file;
for $file (glob 'parts/inc/*') {
  my($testfile) = $file =~ /(\w+)$/;
  $testfile = "t/$testfile.t";

  my $spec = parse_partspec($file);
  my $plan = 0;

  if (exists $spec->{tests}) {
    exists $spec->{OPTIONS}{tests} &&
    exists $spec->{OPTIONS}{tests}{plan}
        or die "No plan for tests in $file\n";

    print "generating $testfile\n";

    my $tmpl = $template;
    $tmpl =~ s/__SOURCE__/$file/mg;
    $tmpl =~ s/__PLAN__/$spec->{OPTIONS}{tests}{plan}/mg;
    $tmpl =~ s/^__TESTS__$/$spec->{tests}/mg;
    
    open FH, ">$testfile" or die "$testfile: $!\n";
    print FH $tmpl;
    close FH;
  }
}

exit 0;

__DATA__
################################################################################
#
#            !!!!!   Do NOT edit this file directly!   !!!!!
#
#            Edit mktests.PL and/or __SOURCE__ instead.
#
################################################################################

BEGIN {
  if ($ENV{'PERL_CORE'}) {
    chdir 't' if -d 't';
    @INC = ('../lib', '../ext/Devel/PPPort/t') if -d '../lib' && -d '../ext';
    require Config; import Config;
    use vars '%Config';
    if (" $Config{'extensions'} " !~ m[ Devel/PPPort ]) {
      print "1..0 # Skip -- Perl configured without Devel::PPPort module\n";
      exit 0;
    }
  }
  else {
    unshift @INC, 't';
  }

  eval "use Test";
  if ($@) {
    require 'testutil.pl';
    print "1..__PLAN__\n";
  }
  else {
    plan(tests => __PLAN__);
  }
}

use Devel::PPPort;
use strict;
$^W = 1;

__TESTS__
