require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MIPS_PARAM_H_)) {
    eval 'sub _MIPS_PARAM_H_ () {1;}' unless defined(&_MIPS_PARAM_H_);
    if(defined(&_KERNEL)) {
	if(defined(&_LOCORE)) {
	    require 'machine/psl.ph';
	} else {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub ALIGNBYTES () {7;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p, $t) = @_;
	    eval q((((($p)) & ($sizeof{$t} - 1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub NBPG () {4096;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub NPTEPG () {( &NBPG/4);}' unless defined(&NPTEPG);
    eval 'sub NBSEG () {0x400000;}' unless defined(&NBSEG);
    eval 'sub SEGOFSET () {( &NBSEG-1);}' unless defined(&SEGOFSET);
    eval 'sub SEGSHIFT () {22;}' unless defined(&SEGSHIFT);
    if(defined(&__LP64__)) {
	eval 'sub KERNBASE () {0xffffffff80000000;}' unless defined(&KERNBASE);
    } else {
	eval 'sub KERNBASE () {0x80000000;}' unless defined(&KERNBASE);
    }
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(32* 1024);}' unless defined(&MAXPHYS);
    if(defined(&__LP64__)) {
	eval 'sub UPAGES () {4;}' unless defined(&UPAGES);
    } else {
	eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    }
    eval 'sub USPACE () {( &UPAGES* &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(2* &NBPG);}' unless defined(&USPACE_ALIGN);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    }
    eval 'sub MSGBUFSIZE () {8192;}' unless defined(&MSGBUFSIZE);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((8* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        local($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
    } else {
	eval 'sub DELAY {
	    local($n) = @_;
    	    eval q({ \'int\'  &N = ($n);  &while (-- &N > 0); });
	}' unless defined(&DELAY);
    }
}
1;
