/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.gef.tools;

import org.eclipse.gef.requests.CreationFactory;

/**
 * A connection creation tool that implements DragTracker.  Using this tool, connections 
 * are created by clicking on the source edit part, dragging the mouse to the target edit 
 * part and releasing the mouse.  A {@link org.eclipse.gef.NodeEditPart} might return this
 * drag tracker if the mouse is located over an appropriate anchor.
 */
public class ConnectionDragCreationTool 
	extends AbstractConnectionCreationTool
	implements org.eclipse.gef.DragTracker
{

/**
 * Default constructor.
 */
public ConnectionDragCreationTool() { }

/**
 * Constructs a new ConnectionDragCreationTool with the given factory.
 * @param factory the creation factory
 */
public ConnectionDragCreationTool(CreationFactory factory) {
	setFactory(factory);
}

/**
 * Calls super and sets the current state to {@link AbstractTool#STATE_DRAG}.
 * @see AbstractConnectionCreationTool#handleButtonDown(int)
 */
protected boolean handleButtonDown(int button) {
	super.handleButtonDown(button);
	setState(STATE_DRAG);
	return true;
}

/**
 * If the connection has started, the button up event attempts to complete the connection.
 * @param button the button that was released
 * @return <code>true</code> if this button up event was processed
 */
protected boolean handleButtonUp(int button) {
	if (isInState(STATE_CONNECTION_STARTED))
		handleCreateConnection();
	setState(STATE_TERMINAL);
	return true;
}

/**
 * When the threshold is passed, transition to CONNECTION_STARTED.
 * @return <code>true</code> if the state transition completed successfully
 */
protected boolean handleDragStarted() {
	return stateTransition(STATE_DRAG, STATE_CONNECTION_STARTED);
}

/**
 * Since this is a drag tracker, it's automatically unloaded by the SelectionTool when the
 * interation is complete.  There's no need to try and unload or reload a drag tracker.
 * @see AbstractTool#handleFinished()
 */
protected void handleFinished() {
	//Don't handle finish because this is a DragTracker.
}

}
