/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.Stack;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.internal.graph.GraphVisitor;
import org.eclipse.draw2d.internal.graph.RevertableChange;
import org.eclipse.draw2d.internal.graph.VirtualNodeCreation;

public class PopulateRanks
extends GraphVisitor {
    private Stack changes = new Stack();

    public void visit(DirectedGraph g) {
        Node node;
        g.ranks = new RankList();
        int i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            g.ranks.getRank(node.rank).add(node);
            ++i;
        }
        i = 0;
        while (i < g.nodes.size()) {
            node = g.nodes.getNode(i);
            int j = 0;
            while (j < node.outgoing.size()) {
                Edge e = node.outgoing.getEdge(j);
                if (e.getLength() > 1) {
                    this.changes.push(new VirtualNodeCreation(e, g));
                    continue;
                }
                ++j;
            }
            ++i;
        }
    }

    public void revisit(DirectedGraph g) {
        int i = 0;
        while (i < this.changes.size()) {
            RevertableChange change = (RevertableChange)this.changes.get(i);
            change.revert();
            ++i;
        }
    }
}

