### Name: apropos
### Title: Find Objects by (Partial) Name
### Aliases: apropos find
### Keywords: data documentation environment

### ** Examples

## Not run: apropos("lm")
apropos(ls)
apropos("lq")

cor <- 1:pi
find(cor)        #> ".GlobalEnv"   "package:stats"
find(cor, num=TRUE) # numbers with these names
find(cor, num=TRUE, mode="function")# only the second one
rm(cor)

## Not run: apropos(".", mode="list") # a long list

# need a DOUBLE backslash '\\' (in case you don't see it anymore)
apropos("\\[")

## Not run: # everything 
##D length(apropos("."))
##D 
##D # those starting with 'pr'
##D apropos("^pr")
##D 
##D # the 1-letter things
##D apropos("^.$")
##D # the 1-2-letter things
##D apropos("^..?$")
##D # the 2-to-4 letter things
##D apropos("^.{2,4}$")
##D 
##D # the 8-and-more letter things
##D apropos("^.{8,}$")
##D table(nchar(apropos("^.{8,}$")))
## End(Not run)


