;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define-interface re-low-exports-interface		; User-level stuff
  (export regexp-match?
	  match:start match:end match:substring
	  clean-up-cres))

;;; TOO MUCH STUFF HERE
(define-interface re-low-internals-interface		; For scsh internals
  (export make-regexp-match
	  regexp-match:string set-regexp-match:string
	  regexp-match:start  set-regexp-match:start
	  regexp-match:end    set-regexp-match:end

	  cre? new-cre
	  cre:string          set-cre:string
	  cre:bytes           set-cre:bytes
	  cre:bytes           set-cre:bytes
	  cre:tvec set-cre:tvec

	  cre-search cre-search?))
  
(define-structures ((re-low-exports re-low-exports-interface)
		    (re-low-internals re-low-internals-interface))
  (open scsh
	scsh-utilities
	defrec-package
	let-opt
	define-foreign-syntax
	weak		
	receiving
	scheme)
  (files re-low)
  (optimize auto-integrate))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Do these guys really need to open the scsh package?

(define-interface basic-re-interface
  (export re-dsm? make-re-dsm
	  re-dsm:body
	  re-dsm:pre-dsm 
	  re-dsm:tsm 
	  re-dsm:posix set-re-dsm:posix
	  re-dsm:post-dsm
	  re-dsm open-dsm

	  re-seq? %%make-re-seq %make-re-seq make-re-seq re-seq
	  re-seq:elts
	  re-seq:tsm
	  re-seq:posix set-re-seq:posix

	  re-choice? %%make-re-choice %make-re-choice make-re-choice re-choice
	  re-choice:elts
	  re-choice:tsm
	  re-choice:posix set-re-choice:posix

	  re-repeat? %%make-re-repeat %make-re-repeat make-re-repeat re-repeat
	  re-repeat:from
	  re-repeat:to
	  re-repeat:body
	  re-repeat:tsm
	  re-repeat:posix set-re-repeat:posix

	  re-submatch?
	  %%make-re-submatch %make-re-submatch make-re-submatch re-submatch
	  re-submatch:body
	  re-submatch:pre-dsm
	  re-submatch:tsm
	  re-submatch:posix set-re-submatch:posix
	  re-submatch:post-dsm

	  re-string? make-re-string re-string
	  re-string:chars set-re-string:chars
	  re-string:posix set-re-string:posix

	  re-trivial re-trivial?

	  re-char-set? make-re-char-set re-char-set
	  re-char-set:cset set-re-char-set:cset 
	  re-char-set:posix set-re-char-set:posix

	  ;; Constructors for the Scheme unparser
	  make-re-string/posix
	  %make-re-seq/posix
	  %make-re-choice/posix
	  make-re-char-set/posix
	  %make-re-repeat/posix
	  %make-re-dsm/posix
	  %make-re-submatch/posix

	  re-empty re-empty?
	  re-bos re-bos?	  re-eos re-eos?
	  re-bol re-bol?	  re-eol re-eol?

	  re-any re-any?

	  re-nonl

	  re?
	  re-tsm

	  flush-submatches	; Can be in code produced by RX expander.
	  uncase		; Can be in code produced by RX expander.
	  uncase-char-set	; Can be in code produced by RX expander.
	  uncase-string

	  char-set-empty?
	  char-set-full?))

;;; Stuff that could appear in code produced by (rx ...)
(define-interface rx-lib-interface
  (export coerce-dynamic-regexp
	  coerce-dynamic-charset
	  spec->char-set
	  flush-submatches
	  uncase
	  uncase-char-set
	  uncase-string))

(define-structure rx-lib rx-lib-interface
  (open scsh conditionals re-basics scheme)
  (files rx-lib)
  (optimize auto-integrate))

(define-structures ((re-basics basic-re-interface)
		    (re-simp-package (export simplify-regexp)))
  (open scsh
	re-low-internals	; new-cre
	conditionals
	scsh-utilities
	define-record-types
	defrec-package
	let-opt
	receiving
	scheme)
  (files re simp)
  (optimize auto-integrate))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-interface re-high-interface
  (export regexp-search regexp-search?
	  regexp-substitute regexp-substitute/global))

(define-interface re-high-tools-interface (export compile-regexp))

(define-structures ((re-high-exports re-high-interface)
		    (re-high-tools   re-high-tools-interface))
  (open scsh
	scsh-utilities
	conditionals
	
	;; compile-regexp needs:
	re-low-internals	; new-cre
	re-simp-package		; simplify-regexp
	re-posix-parsers	; regexp->posix-string

	re-basics		; re-tsm

	let-opt
	receiving
	scheme)
  (files re-high)
  (optimize auto-integrate))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	

(define-interface sre-parser-interface
  (export sre->regexp regexp->sre
	  parse-sre parse-sres regexp->scheme
	  char-set->in-pair
	  static-regexp?))

(define-interface posix-re-interface
  (export regexp->posix-string		; posixstr.scm
	  posix-string->regexp		; spencer
	  ))

;;; The Posix-string stuff needs char-set->in-pair from parse.scm
;;; The SRE parser needs the Posix string parser for POSIX-STRING SRE's.

(define-structures ((sre-parser-package sre-parser-interface)
		    (re-posix-parsers posix-re-interface))
  (open scsh
	conditionals
	re-low-internals	; cre:string cre:tvec
	re-basics
	re-simp-package
	sort			; Posix renderer
	scsh-utilities
	receiving
	scheme)
  (files parse			; sre-parser-package
	 posixstr spencer)	; re-posix-parsers
  (optimize auto-integrate))


;;; re-syntax provides 2 structures:
;;;     re-syntax (exports (rx :syntax))
;;;     re-syntax-tools (exports (if-sre-form :syntax) sre-form?)

(define-interface sre-syntax-tools-interface
  (export expand-rx sre-form?))

(define-structure sre-syntax-tools sre-syntax-tools-interface
  (open scheme
	receiving
	conditionals
	re-posix-parsers	; regexp->posix-string
	sre-parser-package	; static-regexp? parse-sres 
	re-high-tools		; compile-regexp
	re-basics		; For the posix-cacher and code-producer
	re-simp-package)
  (files re-syntax)
  (optimize auto-integrate))

(define-structure rx-syntax (export (rx :syntax)
				    (if-sre-form :syntax))
  
  (open re-basics
	rx-lib
	scheme)
  (for-syntax (open sre-syntax-tools scheme))
  (begin (define-syntax rx expand-rx)
	 (define-syntax if-sre-form
	   (lambda (exp r c)
	     (if (sre-form? (cadr exp) r c)
		 (caddr exp)
		 (cadddr exp)))))
  (optimize auto-integrate))
