#ifndef _PFE_DICT_SUB_H
#define _PFE_DICT_SUB_H 1034771913
/* generated 2002-1016-1438 ../../../pfe/../mk/Make-H.pl ../../../pfe/dict-sub.c */

#include <pfe/incl-sub.h>

/** 
 *  Implements dictionary and wordlists.
 *
 *  Copyright (C) Tektronix, Inc. 1998 - 2001. All rights reserved.
 *
 *  @see     GNU LGPL
 *  @author  Tektronix CTE              @(#) %derived_by: guidod %
 *  @version %version: bln_mpt1!5.55 %
 *    (%date_modified: Wed Sep 11 13:17:53 2002 %)
 */

#ifdef __cplusplus
extern "C" {
#endif




/** ((FORGET)) 
 * remove words from dictionary, free dictionary space, this is the
 * runtime helper of => (FORGET)
 */
extern P4_CODE (p4_forget_dp);

extern P4_CODE (p4_destroyer_RT);

/** ONLY ( -- )
 * the only-vocabulary is special. Calling it will erase
 * the search => ORDER of vocabularies and only allows
 * to name some very basic vocabularies. Even => ALSO
 * is not available.
 example:
   ONLY FORTH ALSO EXTENSIONS ALSO DEFINITIONS
 */
extern P4_CODE (p4_only_RT);

/** FORTH ( -- )
 : FORTH FORTH-WORDLIST CONTEXT ! ;
 */
extern P4_CODE (p4_forth_RT);

_extern  int p4_wl_hash (const char *s, int l) /* s string, l length of string, returns hash-code for that name */ ; /*{*/

_extern  p4char ** p4_topmost (p4_Wordl *w) ; /*{*/

_extern  p4char * p4_latest (void) ; /*{*/

/** 
 * create a word list in the dictionary 
 */
_extern  p4_Wordl * p4_make_wordlist (p4char* nfa) ; /*{*/

_extern  p4_Wordl * p4_find_wordlist (const char* nm, int nmlen) ; /*{*/

/** (FORGET)
 * forget anything above address
 */
_extern  void p4_forget (char* above) ; /*{*/

/**
 * create a destroyer word. Upon =>'FORGET' the code will will be
 * run with the given argument. The structure is code/CFA and what/PFA.
 */
_extern  char* p4_forget_word (const char *name, p4cell id, p4code ccode, p4cell what) ; /*{*/

_extern  char * p4_search_wordlist (const char *nm, int l, const p4_Wordl *w) ; /*{*/

_extern  char * p4_find (const char *nm, int l) ; /*{*/

/**
 * tick next word,  and
 * return count byte pointer of name field (to detect immediacy)
 */
_extern  char * p4_tick_nfa (void) ; /*{*/

/**
 * tick next word,  and return xt
 */
_extern  p4xt p4_tick_cfa (void) ; /*{*/

_extern  char * p4_tick (p4xt *xt) ; /*{*/

_extern  char * p4_string_comma (const char *s, int len) ; /*{*/

_extern  void p4_wild_words (const p4_Wordl *wl, const char *pattern, const char *categories) ; /*{*/

_extern  int p4_complete_dictionary (char *in, char *out, int display) ; /*{*/

_extern  void p4_preload_only (void) ; /*{*/

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif
