/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search.federated;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;

public class LocalHelp
implements ISearchEngine {
    private static final int MAX_HITS = 500;

    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) throws CoreException {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.setSearchWord(query);
        WorkingSet[] workingSets = null;
        LocalHelpScope localScope = (LocalHelpScope)scope;
        if (localScope.getWorkingSet() != null) {
            workingSets = new WorkingSet[]{localScope.getWorkingSet()};
        }
        SearchResults localResults = new SearchResults(workingSets, 500, Platform.getNL());
        try {
            Platform.getJobManager().join((Object)"org.eclipse.help.base.indexer", monitor);
        }
        catch (InterruptedException interruptedException) {}
        BaseHelpSystem.getSearchManager().search(searchQuery, localResults, monitor);
        this.postResults(localResults, collector, localScope.getCapabilityFiltered());
    }

    private void postResults(SearchResults results, ISearchEngineResultCollector collector, boolean activityFiltering) {
        ISearchEngineResult[] searchHits = results.getSearchHits();
        if (!activityFiltering) {
            collector.accept(searchHits);
            return;
        }
        ArrayList<ISearchEngineResult> enabledHits = new ArrayList<ISearchEngineResult>();
        int i = 0;
        while (i < searchHits.length) {
            if (HelpBasePlugin.getActivitySupport().isEnabledTopic(((SearchHit)searchHits[i]).getHref(), Platform.getNL())) {
                enabledHits.add(searchHits[i]);
            }
            ++i;
        }
        collector.accept(enabledHits.toArray(new SearchHit[enabledHits.size()]));
    }

    public String toAbsoluteHref(String href, boolean frames) {
        return null;
    }
}

