/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceMappingSelectionArea
extends DialogArea {
    public static final String SELECTED_MAPPING = "SelectedMapping";
    public static final String CHECKED_MAPPINGS = "CheckedMappings";
    private ResourceMapping[] mappings;
    private CheckboxTableViewer viewer;
    private ResourceMapping[] checkedMappings;
    private ResourceMapping selectedMapping;
    private String description;

    public ResourceMappingSelectionArea(ResourceMapping[] mappings) {
        this.mappings = mappings;
    }

    public void createArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        if (this.description != null) {
            this.createWrappingLabel(composite, this.description, 1);
        }
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 300;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceMappingLabelProvider());
        this.viewer.setInput((Object)new AdaptableList((IAdaptable[])this.mappings));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourceMapping[] oldMappings = ResourceMappingSelectionArea.this.checkedMappings;
                ResourceMappingSelectionArea.this.checkedMappings = ResourceMappingSelectionArea.this.internalGetCheckedMappings();
                if (oldMappings != ResourceMappingSelectionArea.this.checkedMappings) {
                    ResourceMappingSelectionArea.this.firePropertyChangeChange(ResourceMappingSelectionArea.CHECKED_MAPPINGS, oldMappings, ResourceMappingSelectionArea.this.checkedMappings);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceMapping oldSelection = ResourceMappingSelectionArea.this.selectedMapping;
                ResourceMappingSelectionArea.this.selectedMapping = ResourceMappingSelectionArea.this.internalGetSelectedMapping();
                if (oldSelection != ResourceMappingSelectionArea.this.selectedMapping) {
                    ResourceMappingSelectionArea.this.firePropertyChangeChange(ResourceMappingSelectionArea.SELECTED_MAPPING, oldSelection, ResourceMappingSelectionArea.this.selectedMapping);
                }
            }
        });
        this.viewer.setCheckedElements((Object[])this.mappings);
        this.checkedMappings = this.mappings;
        Composite buttons = this.createEmbeddedButtonComposite(composite);
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(TeamUIMessages.ResourceMappingSelectionArea_0);
        selectAll.setLayoutData((Object)new GridData(1808));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceMappingSelectionArea.this.viewer.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(TeamUIMessages.ResourceMappingSelectionArea_1);
        deselectAll.setLayoutData((Object)new GridData(1808));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceMappingSelectionArea.this.viewer.setAllChecked(false);
            }
        });
    }

    ResourceMapping[] internalGetCheckedMappings() {
        Object[] checked = this.viewer.getCheckedElements();
        ResourceMapping[] mappings = new ResourceMapping[checked.length];
        int i = 0;
        while (i < checked.length) {
            Object object = checked[i];
            mappings[i] = (ResourceMapping)object;
            ++i;
        }
        return mappings;
    }

    private Composite createEmbeddedButtonComposite(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        GridData data = new GridData(132);
        buttons.setLayoutData((Object)data);
        return buttons;
    }

    ResourceMapping internalGetSelectedMapping() {
        IStructuredSelection ss;
        Object firstElement;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof ResourceMapping) {
            return (ResourceMapping)firstElement;
        }
        return null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceMapping[] getCheckedMappings() {
        return this.checkedMappings;
    }

    public ResourceMapping getSelectedMapping() {
        return this.selectedMapping;
    }

    public class ResourceMappingLabelProvider
    extends LabelProvider {
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        public String getText(Object element) {
            ResourceMapping mapping;
            String text = this.provider.getText(element);
            if (text != null && text.length() > 0) {
                return text;
            }
            if (element instanceof ResourceMapping && (text = this.provider.getText((mapping = (ResourceMapping)element).getModelObject())) != null) {
                return text;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ResourceMapping mapping;
            Image image = this.provider.getImage(element);
            if (image != null) {
                return image;
            }
            if (element instanceof ResourceMapping && (image = this.provider.getImage((mapping = (ResourceMapping)element).getModelObject())) != null) {
                return image;
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.provider.dispose();
            super.dispose();
        }
    }
}

