/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;

public class PromptingDialog {
    private IResource[] resources;
    private Shell shell;
    private String[] buttons;
    private boolean confirmOverwrite = true;
    private IPromptCondition condition;
    private String title;
    private boolean hasMultipleResources;
    private boolean allOrNothing;

    public PromptingDialog(Shell shell, IResource[] resources, IPromptCondition condition, String title) {
        this(shell, resources, condition, title, false);
    }

    public PromptingDialog(Shell shell, IResource[] resources, IPromptCondition condition, String title, boolean allOrNothing) {
        this.condition = condition;
        this.resources = resources;
        this.title = title;
        this.shell = shell;
        this.hasMultipleResources = resources.length > 1;
        this.allOrNothing = allOrNothing;
        this.buttons = this.hasMultipleResources ? (allOrNothing ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}) : new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
    }

    public IResource[] promptForMultiple() throws InterruptedException {
        ArrayList<IResource> targetResources = new ArrayList<IResource>();
        int i = 0;
        while (i < this.resources.length) {
            IResource resource = this.resources[i];
            if (this.condition.needsPrompt(resource) && this.confirmOverwrite) {
                if (this.confirmOverwrite(this.condition.promptMessage(resource))) {
                    targetResources.add(resource);
                }
            } else {
                targetResources.add(resource);
            }
            ++i;
        }
        return targetResources.toArray(new IResource[targetResources.size()]);
    }

    private boolean confirmOverwrite(String msg) throws InterruptedException {
        if (!this.confirmOverwrite) {
            return true;
        }
        final MessageDialog dialog = new MessageDialog(this.shell, this.title, null, msg, 3, this.buttons, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        if (this.hasMultipleResources) {
            switch (dialog.getReturnCode()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.confirmOverwrite = false;
                    return true;
                }
                case 2: {
                    if (this.allOrNothing) {
                        throw new InterruptedException();
                    }
                    return false;
                }
            }
            throw new InterruptedException();
        }
        return dialog.getReturnCode() == 0;
    }
}

