/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class CreateLaunchConfigurationAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_CREATE_ACTION = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".ID_CREATE_ACTION";

    public CreateLaunchConfigurationAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.CreateLaunchConfigurationAction_Ne_w_1, viewer, mode);
    }

    protected void performAction() {
        Object object = this.getStructuredSelection().getFirstElement();
        ILaunchConfigurationType type = null;
        if (object instanceof ILaunchConfiguration) {
            ILaunchConfiguration config = (ILaunchConfiguration)object;
            try {
                type = config.getType();
            }
            catch (CoreException e) {
                this.errorDialog(e);
                return;
            }
        } else {
            type = (ILaunchConfigurationType)object;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(LaunchConfigurationsMessages.CreateLaunchConfigurationAction_New_configuration_2));
            ILaunchConfigurationTabGroup tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup(wc.getType(), this.getMode());
            ILaunchConfigurationDialog dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
            tabGroup.createTabs(dialog, dialog.getMode());
            ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
            int i = 0;
            while (i < tabs.length) {
                ILaunchConfigurationTab tab = tabs[i];
                tab.setLaunchConfigurationDialog(dialog);
                ++i;
            }
            tabGroup.setDefaults(wc);
            tabGroup.dispose();
            wc.doSave();
        }
        catch (CoreException e) {
            this.errorDialog(e);
            return;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1;
    }
}

