/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class AbstractDebugActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IActionDelegate2,
ISelectionListener,
INullSelectionListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection = StructuredSelection.EMPTY;
    private boolean fInitialized = false;
    protected IWorkbenchWindow fWindow;
    private DebugRequestJob fBackgroundJob = null;
    private UpdateEnablementJob fUpdateEnablementJob = new UpdateEnablementJob();
    private IWorkbenchSiteProgressService fProgressService = null;
    static /* synthetic */ Class class$0;

    public void dispose() {
        if (this.getWindow() != null) {
            this.getWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        this.fBackgroundJob = null;
        this.fSelection = null;
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        window.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void run(IAction action) {
        if (action.isEnabled()) {
            IStructuredSelection selection = this.getSelection();
            action.setEnabled(false);
            if (this.isRunInBackground()) {
                this.runInBackground(action, selection);
            } else {
                this.runInForeground(selection);
            }
        }
    }

    private void runInBackground(IAction action, IStructuredSelection selection) {
        if (this.fBackgroundJob == null) {
            this.fBackgroundJob = new DebugRequestJob(DebugUIPlugin.removeAccelerators(action.getText()));
        }
        this.fBackgroundJob.setTargets(selection.toArray());
        this.schedule(this.fBackgroundJob);
    }

    private void runInForeground(final IStructuredSelection selection) {
        final MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, this.getStatusMessage(), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                Iterator selectionIter = selection.iterator();
                while (selectionIter.hasNext()) {
                    Object element = selectionIter.next();
                    try {
                        if (!AbstractDebugActionDelegate.this.isEnabledFor(element)) continue;
                        AbstractDebugActionDelegate.this.doAction(element);
                    }
                    catch (DebugException e) {
                        status.merge(e.getStatus());
                    }
                }
            }
        });
        this.reportErrors(status);
    }

    private void reportErrors(MultiStatus ms) {
        if (!ms.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), ActionMessages.AbstractDebugActionDelegate_0, this.getErrorDialogMessage(), (IStatus)ms);
            } else {
                DebugUIPlugin.log((IStatus)ms);
            }
        }
    }

    protected boolean isRunInBackground() {
        return false;
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean wasInitialized = this.initialize(action, s);
        if (!wasInitialized && this.getView() != null) {
            if (this.isRunInBackground()) {
                this.fUpdateEnablementJob.setTargets(action, s);
                this.schedule(this.fUpdateEnablementJob);
            } else {
                this.update(action, s);
            }
        }
    }

    protected void update(IAction action, ISelection s) {
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            action.setEnabled(this.getEnableStateForSelection(ss));
            this.setSelection(ss);
        } else {
            action.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected abstract void doAction(Object var1) throws DebugException;

    protected String getErrorDialogMessage() {
        return null;
    }

    protected String getStatusMessage() {
        return "";
    }

    public void init(IViewPart view) {
        this.fViewPart = view;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fProgressService = (IWorkbenchSiteProgressService)view.getAdapter((Class)clazz);
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IWorkbenchPage page;
            IWorkbenchWindow window;
            this.setAction(action);
            if (this.getView() == null && (window = this.getWindow()) != null && window.getShell() != null && !window.getShell().isDisposed() && (page = window.getActivePage()) != null) {
                selection = page.getSelection("org.eclipse.debug.ui.DebugView");
            }
            this.update(action, selection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.isRunInBackground()) {
            this.fUpdateEnablementJob.setTargets(this.getAction(), selection);
            this.schedule(this.fUpdateEnablementJob);
        } else {
            this.update(this.getAction(), selection);
        }
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setView(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            if (this.isEnabledFor(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEnabledFor(Object element) {
        return true;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
    }

    private void schedule(Job job) {
        if (this.fProgressService == null) {
            job.schedule();
        } else {
            this.fProgressService.schedule(job);
        }
    }

    class UpdateEnablementJob
    extends Job {
        IAction targetAction = null;
        ISelection targetSelection = null;

        public UpdateEnablementJob() {
            super(ActionMessages.AbstractDebugActionDelegate_1);
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IAction action = null;
            ISelection selection = null;
            UpdateEnablementJob updateEnablementJob = this;
            synchronized (updateEnablementJob) {
                action = this.targetAction;
                selection = this.targetSelection;
            }
            AbstractDebugActionDelegate.this.update(action, selection);
            return Status.OK_STATUS;
        }

        public synchronized void setTargets(IAction action, ISelection selection) {
            this.targetAction = action;
            this.targetSelection = selection;
        }
    }

    class DebugRequestJob
    extends Job {
        private Object[] fElements = null;

        public DebugRequestJob(String name) {
            super(name);
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, AbstractDebugActionDelegate.this.getStatusMessage(), null);
            Object[] targets = null;
            DebugRequestJob debugRequestJob = this;
            synchronized (debugRequestJob) {
                targets = this.fElements;
                this.fElements = null;
            }
            int i = 0;
            while (i < targets.length) {
                Object element = targets[i];
                try {
                    if (AbstractDebugActionDelegate.this.isEnabledFor(element)) {
                        AbstractDebugActionDelegate.this.doAction(element);
                    }
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
                ++i;
            }
            return status;
        }

        public synchronized void setTargets(Object[] elements) {
            this.fElements = elements;
        }
    }
}

