/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionSorter;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchAdapter;

public class CheatSheetCategoryBasedSelectionDialog
extends SelectionDialog
implements ISelectionChangedListener {
    private IDialogSettings settings;
    private CheatSheetCollectionElement cheatsheetCategories;
    private CheatSheetElement currentSelection;
    private TreeViewer treeViewer;
    private Text desc;
    private Button showAllButton;
    private ActivityViewerFilter activityViewerFilter = new ActivityViewerFilter();
    private boolean okButtonState;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_CHEATSHEET_ID = "CheatSheetCategoryBasedSelectionDialog.STORE_SELECTED_CHEATSHEET_ID";

    public CheatSheetCategoryBasedSelectionDialog(Shell shell, CheatSheetCollectionElement cheatsheetCategories) {
        super(shell);
        this.cheatsheetCategories = cheatsheetCategories;
        this.setTitle(Messages.CHEAT_SHEET_SELECTION_DIALOG_TITLE);
        this.setMessage(Messages.CHEAT_SHEET_SELECTION_DIALOG_MSG);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableOKButton(this.okButtonState);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings workbenchSettings = CheatSheetPlugin.getPlugin().getDialogSettings();
        IDialogSettings dialogSettings = workbenchSettings.getSection("CheatSheetCategoryBasedSelectionDialog");
        if (dialogSettings == null) {
            dialogSettings = workbenchSettings.addNewSection("CheatSheetCategoryBasedSelectionDialog");
        }
        this.setDialogSettings(dialogSettings);
        Composite outerContainer = (Composite)super.createDialogArea(parent);
        Layout layout = outerContainer.getLayout();
        if (layout == null || !(layout instanceof GridLayout)) {
            GridLayout gridLayout = new GridLayout();
            outerContainer.setLayout((Layout)gridLayout);
            outerContainer.setLayoutData((Object)new GridData(1808));
        }
        this.createMessageArea(outerContainer);
        Tree tree = new Tree(outerContainer, 2820);
        this.treeViewer = new TreeViewer(tree);
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 300;
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.treeViewer.setContentProvider(this.getCheatSheetProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CheatsheetLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)CheatSheetCollectionSorter.INSTANCE);
        this.treeViewer.addFilter((ViewerFilter)this.activityViewerFilter);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setInput((Object)this.cheatsheetCategories);
        this.desc = new Text(outerContainer, 66);
        this.desc.setEditable(false);
        data = new GridData(768);
        data.widthHint = 100;
        data.heightHint = 48;
        this.desc.setLayoutData((Object)data);
        if (this.activityViewerFilter.getHasEncounteredFilteredItem()) {
            this.createShowAllButton(outerContainer);
        }
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheatSheetCategoryBasedSelectionDialog.this.okPressed();
            }
        });
        this.restoreWidgetValues();
        if (!this.treeViewer.getSelection().isEmpty()) {
            this.treeViewer.getTree().setFocus();
        }
        Dialog.applyDialogFont((Control)outerContainer);
        return outerContainer;
    }

    private void createShowAllButton(Composite parent) {
        this.showAllButton = new Button(parent, 32);
        this.showAllButton.setText(Messages.CheatSheetCategoryBasedSelectionDialog_showAll);
        this.showAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CheatSheetCategoryBasedSelectionDialog.this.showAllButton.getSelection()) {
                    CheatSheetCategoryBasedSelectionDialog.this.treeViewer.resetFilters();
                } else {
                    CheatSheetCategoryBasedSelectionDialog.this.treeViewer.addFilter((ViewerFilter)CheatSheetCategoryBasedSelectionDialog.this.activityViewerFilter);
                }
            }
        });
    }

    private void enableOKButton(boolean value) {
        Button button = this.getButton(0);
        this.okButtonState = value;
        if (button != null) {
            button.setEnabled(value);
        }
    }

    protected CheatSheetCollectionElement expandPreviouslyExpandedCategories() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        ArrayList<CheatSheetCollectionElement> categoriesToExpand = new ArrayList<CheatSheetCollectionElement>(expandedCategoryPaths.length);
        int i = 0;
        while (i < expandedCategoryPaths.length) {
            CheatSheetCollectionElement category = this.cheatsheetCategories.findChildCollection((IPath)new Path(expandedCategoryPaths[i]));
            if (category != null) {
                categoriesToExpand.add(category);
            }
            ++i;
        }
        if (!categoriesToExpand.isEmpty()) {
            this.treeViewer.setExpandedElements(categoriesToExpand.toArray());
        }
        return categoriesToExpand.isEmpty() ? null : (CheatSheetCollectionElement)((Object)categoriesToExpand.get(categoriesToExpand.size() - 1));
    }

    protected IContentProvider getCheatSheetProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                Object[] cheatsheets;
                if (o instanceof CheatSheetCollectionElement && (cheatsheets = ((CheatSheetCollectionElement)((Object)o)).getCheatSheets()).length > 0) {
                    return cheatsheets;
                }
                return super.getChildren(o);
            }
        };
    }

    protected Object getSingleSelection(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        return ssel.size() == 1 ? ssel.getFirstElement() : null;
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        Object obj = this.getSingleSelection(selectionEvent.getSelection());
        if (obj instanceof CheatSheetCollectionElement) {
            this.enableOKButton(false);
            this.desc.setText("");
        } else {
            this.currentSelection = (CheatSheetElement)((Object)obj);
            if (this.currentSelection != null) {
                this.enableOKButton(true);
                this.desc.setText(this.currentSelection.getDescription());
            }
        }
    }

    protected void okPressed() {
        ArrayList<CheatSheetElement> result;
        if (this.currentSelection != null) {
            result = new ArrayList<CheatSheetElement>(1);
            ITriggerPoint triggerPoint = PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.cheatsheetSelectionDialog");
            if (!WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)((Object)this.currentSelection))) {
                return;
            }
        } else {
            return;
        }
        result.add(this.currentSelection);
        this.setResult(result);
        this.saveWidgetValues();
        super.okPressed();
    }

    protected void restoreWidgetValues() {
        String[] expandedCategoryPaths = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (expandedCategoryPaths == null) {
            return;
        }
        CheatSheetCollectionElement category = this.expandPreviouslyExpandedCategories();
        if (category != null) {
            this.selectPreviouslySelectedCheatSheet(category);
        }
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCheatSheet();
    }

    protected void selectPreviouslySelectedCheatSheet(CheatSheetCollectionElement category) {
        String cheatsheetId = this.settings.get(STORE_SELECTED_CHEATSHEET_ID);
        if (cheatsheetId == null) {
            return;
        }
        CheatSheetElement cheatsheet = category.findCheatSheet(cheatsheetId, false);
        if (cheatsheet == null) {
            return;
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)cheatsheet));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeExpandedCategories() {
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        String[] expandedElementPaths = new String[expandedElements.length];
        int i = 0;
        while (i < expandedElements.length) {
            expandedElementPaths[i] = ((CheatSheetCollectionElement)((Object)expandedElements[i])).getPath().toString();
            ++i;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, expandedElementPaths);
    }

    protected void storeSelectedCheatSheet() {
        CheatSheetElement element = null;
        Object el = this.getSingleSelection(this.treeViewer.getSelection());
        if (el == null) {
            return;
        }
        if (!(el instanceof CheatSheetElement)) {
            return;
        }
        element = (CheatSheetElement)((Object)el);
        this.settings.put(STORE_SELECTED_CHEATSHEET_ID, element.getID());
    }

    private static class ActivityViewerFilter
    extends ViewerFilter {
        private boolean hasEncounteredFilteredItem = false;

        ActivityViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (WorkbenchActivityHelper.filterItem((Object)element)) {
                this.setHasEncounteredFilteredItem(true);
                return false;
            }
            return true;
        }

        public boolean getHasEncounteredFilteredItem() {
            return this.hasEncounteredFilteredItem;
        }

        public void setHasEncounteredFilteredItem(boolean hasEncounteredFilteredItem) {
            this.hasEncounteredFilteredItem = hasEncounteredFilteredItem;
        }
    }

    private class CheatsheetLabelProvider
    extends LabelProvider {
        CheatsheetLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof WorkbenchAdapter) {
                return ((WorkbenchAdapter)obj).getLabel(null);
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof CheatSheetElement) {
                return CheatSheetPlugin.getPlugin().getImageRegistry().get("CHEATSHEET_OBJ");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }
}

