/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.refactoring.JUnitRenameParticipant;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class ProjectRenameParticipant
extends JUnitRenameParticipant {
    private IJavaProject fProject;

    private IJavaProject getNewJavaProject() {
        IProject project = this.fProject.getProject().getWorkspace().getRoot().getProject(this.getNewName());
        return this.getJavaProject(project);
    }

    protected IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    protected boolean initialize(Object element) {
        this.fProject = (IJavaProject)element;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void createChangeForConfig(JUnitRenameParticipant.ChangeList changeList, LaunchConfigurationContainer config) throws CoreException {
        void var7_9;
        String newHandle;
        changeList.addAttributeChangeIfNeeded(config, IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProject.getElementName(), this.getNewName());
        IJavaProject newJavaProject = this.getNewJavaProject();
        String container = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", null);
        IJavaElement javaElement = this.getJavaElement(container);
        if (javaElement == null) {
            return;
        }
        IJavaElement potentialMatch = javaElement;
        while (!potentialMatch.getHandleIdentifier().equals(this.fProject.getHandleIdentifier())) {
            if ((potentialMatch = potentialMatch.getParent()) != null) continue;
            return;
        }
        if (javaElement instanceof IPackageFragment) {
            IPackageFragment fragment = (IPackageFragment)javaElement;
            newHandle = newJavaProject.getPackageFragmentRoot(fragment.getParent().getElementName()).getPackageFragment(fragment.getElementName()).getHandleIdentifier();
        } else if (javaElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
            newHandle = newJavaProject.getPackageFragmentRoot(root.getElementName()).getHandleIdentifier();
        } else if (javaElement instanceof IJavaProject) {
            newHandle = newJavaProject.getHandleIdentifier();
        } else {
            return;
        }
        changeList.addAttributeChange(config, "org.eclipse.jdt.junit.CONTAINER", (String)var7_9);
        changeList.addRenameChangeIfNeeded(config, this.fProject.getElementName());
    }

    protected IJavaElement getJavaElement(String handle) {
        return JavaCore.create((String)handle);
    }
}

