/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQueryFactory;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePreferences;

public class RefactoringCore {
    private static IValidationCheckResultQueryFactory fQueryFactory = new DefaultQueryFactory();

    private RefactoringCore() {
    }

    public static IUndoManager getUndoManager() {
        return RefactoringCorePlugin.getUndoManager();
    }

    public static int getConditionCheckingFailedSeverity() {
        return RefactoringCorePreferences.getStopSeverity();
    }

    public static IValidationCheckResultQueryFactory getQueryFactory() {
        return fQueryFactory;
    }

    public static void internalSetQueryFactory(IValidationCheckResultQueryFactory factory) {
        fQueryFactory = factory == null ? new DefaultQueryFactory() : factory;
    }

    private static class NullQuery
    implements IValidationCheckResultQuery {
        NullQuery() {
        }

        public boolean proceed(RefactoringStatus status) {
            return true;
        }

        public void stopped(RefactoringStatus status) {
        }
    }

    private static class DefaultQueryFactory
    implements IValidationCheckResultQueryFactory {
        DefaultQueryFactory() {
        }

        public IValidationCheckResultQuery create(IAdaptable context) {
            return new NullQuery();
        }
    }
}

