/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaMonitorThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;

public class JavaMonitor {
    private IJavaObject fMonitor;
    private JavaMonitorThread fOwningThread;
    private JavaMonitorThread[] fWaitingThreads = new JavaMonitorThread[0];
    private boolean fIsInDeadlock;
    private boolean fToUpdate = true;
    private List fElements = new ArrayList();

    public JavaMonitor(IJavaObject monitor) {
        this.fMonitor = monitor;
    }

    public IJavaObject getMonitor() {
        return this.fMonitor;
    }

    public IDebugTarget getDebugTarget() {
        return this.fMonitor.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fMonitor.getLaunch();
    }

    public String getModelIdentifier() {
        return this.fMonitor.getModelIdentifier();
    }

    protected JavaMonitorThread getOwningThread0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fOwningThread;
    }

    protected JavaMonitorThread[] getWaitingThreads0() {
        if (this.fToUpdate) {
            this.update();
        }
        return this.fWaitingThreads;
    }

    /*
     * Exception decompiling
     */
    private boolean update() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 385->397)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fireChangeEvent(int detail) {
        Object[] elements = this.fElements.toArray();
        DebugEvent[] changeEvents = new DebugEvent[elements.length];
        int i = 0;
        while (i < elements.length) {
            changeEvents[i] = new DebugEvent(elements[i], 16, detail);
            ++i;
        }
        DebugPlugin.getDefault().fireDebugEventSet(changeEvents);
    }

    public synchronized void setToUpdate() {
        if (!this.fToUpdate) {
            this.fToUpdate = true;
            if (this.fOwningThread != null) {
                this.fOwningThread.setToUpdate();
            }
            if (this.fWaitingThreads != null) {
                int i = 0;
                while (i < this.fWaitingThreads.length) {
                    this.fWaitingThreads[i].setToUpdate();
                    ++i;
                }
            }
        }
    }

    protected void addElement(JavaOwnedMonitor monitor) {
        this.fElements.add(monitor);
    }

    protected void addElement(JavaContendedMonitor monitor) {
        this.fElements.add(monitor);
    }

    public void refresh() {
        if (this.fToUpdate && !this.update()) {
            if (this.fOwningThread != null) {
                this.fOwningThread.refresh();
            }
            int i = 0;
            while (i < this.fWaitingThreads.length) {
                this.fWaitingThreads[i].refresh();
                ++i;
            }
        }
    }

    public boolean isInDeadlock() {
        return this.fIsInDeadlock;
    }

    public void setInDeadlock(boolean isInDeadlock) {
        boolean oldValue = this.fIsInDeadlock;
        this.fIsInDeadlock = isInDeadlock;
        if (oldValue != isInDeadlock) {
            this.fireChangeEvent(256);
        }
    }
}

