/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.jres.BuildJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JREContainerWizardPage
extends WizardPage
implements IClasspathContainerPage {
    private IClasspathEntry fSelection;
    private JREsComboBlock fJREBlock;

    public JREContainerWizardPage() {
        super(JREMessages.JREContainerWizardPage_JRE_System_Library_1);
    }

    public boolean finish() {
        IVMInstall vm;
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        if (!this.fJREBlock.isDefaultJRE() && (vm = this.fJREBlock.getJRE()) != null) {
            path = path.append(vm.getVMInstallType().getId());
            path = path.append(vm.getName());
        }
        this.fSelection = JavaCore.newContainerEntry((IPath)path);
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            String typeId = null;
            String name = null;
            if (this.fSelection == null) {
                this.fJREBlock.setUseDefaultJRE();
                return;
            }
            IPath path = this.fSelection.getPath();
            if (path.segmentCount() <= 1) {
                this.fJREBlock.setUseDefaultJRE();
                return;
            }
            typeId = path.segment(1);
            name = path.segment(2);
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                if (type.getId().equals(typeId)) {
                    IVMInstall[] installs = type.getVMInstalls();
                    int j = 0;
                    while (j < installs.length) {
                        IVMInstall install = installs[j];
                        if (install.getName().equals(name)) {
                            this.fJREBlock.setJRE(install);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.fJREBlock.setUseDefaultJRE();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.fJREBlock = new JREsComboBlock();
        this.fJREBlock.setDefaultJREDescriptor(new BuildJREDescriptor());
        this.fJREBlock.setTitle(JREMessages.JREContainerWizardPage_3);
        this.fJREBlock.createControl(composite);
        gd = new GridData(768);
        this.fJREBlock.getControl().setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.setTitle(JREMessages.JREContainerWizardPage_JRE_System_Library_1);
        this.setMessage(JREMessages.JREContainerWizardPage_Select_the_JRE_used_to_build_this_project__4);
        this.initializeFromSelection();
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }
}

