/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.JavaWatchExpressionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;

public class JavaWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String fExpressionText;
    private IWatchExpressionListener fListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fExpressionText = expression;
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (frame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IJavaStackFrame javaStackFrame;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((javaStackFrame = (IJavaStackFrame)frame.getAdapter((Class)clazz)) != null) {
                this.doEvaluation(javaStackFrame);
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    protected void doEvaluation(IJavaStackFrame javaStackFrame) {
        IJavaThread thread = (IJavaThread)javaStackFrame.getThread();
        if (this.preEvaluationCheck(thread)) {
            thread.queueRunnable((Runnable)new EvaluationRunnable(javaStackFrame));
        } else {
            this.fListener.watchEvaluationFinished(null);
        }
    }

    private boolean preEvaluationCheck(IJavaThread javaThread) {
        if (javaThread == null) {
            return false;
        }
        return !javaThread.isSuspended() || !((JDIThread)javaThread).isInvokingMethod();
    }

    private IJavaProject getProject(IJavaStackFrame javaStackFrame) {
        ILaunch launch = javaStackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)javaStackFrame);
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sourceElement = iAdaptable.getAdapter((Class)clazz);
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        return null;
    }

    private final class EvaluationRunnable
    implements Runnable {
        private final IJavaStackFrame fStackFrame;

        EvaluationRunnable(IJavaStackFrame frame) {
            this.fStackFrame = frame;
        }

        public void run() {
            IJavaProject project = JavaWatchExpressionDelegate.this.getProject(this.fStackFrame);
            if (project == null) {
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
                return;
            }
            IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)this.fStackFrame.getDebugTarget());
            IEvaluationListener listener = new IEvaluationListener(this){
                final /* synthetic */ EvaluationRunnable this$1;
                {
                    this.this$1 = evaluationRunnable;
                }

                public void evaluationComplete(IEvaluationResult result) {
                    IWatchExpressionResult watchResult = new IWatchExpressionResult(this, result){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ IEvaluationResult val$result;
                        {
                            this.this$2 = var1_1;
                            this.val$result = iEvaluationResult;
                        }

                        public IValue getValue() {
                            return this.val$result.getValue();
                        }

                        public boolean hasErrors() {
                            return this.val$result.hasErrors();
                        }

                        public String[] getErrorMessages() {
                            return JavaInspectExpression.getErrorMessages(this.val$result);
                        }

                        public String getExpressionText() {
                            return this.val$result.getSnippet();
                        }

                        public DebugException getException() {
                            return this.val$result.getException();
                        }
                    };
                    JavaWatchExpressionDelegate.access$1(EvaluationRunnable.access$0(this.this$1)).watchEvaluationFinished(watchResult);
                }
            };
            try {
                evaluationEngine.evaluate(JavaWatchExpressionDelegate.this.fExpressionText, this.fStackFrame, listener, 128, false);
            }
            catch (DebugException e) {
                JDIDebugPlugin.log((Throwable)e);
                JavaWatchExpressionDelegate.this.fListener.watchEvaluationFinished(null);
            }
        }

        static /* synthetic */ JavaWatchExpressionDelegate access$0(EvaluationRunnable evaluationRunnable) {
            return evaluationRunnable.JavaWatchExpressionDelegate.this;
        }
    }
}

